/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.constants.SortScopeOptions;
import org.apache.carbondata.core.datastore.TableSpec;
import org.apache.carbondata.core.datastore.block.SegmentProperties;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataLoadMetrics;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.index.IndexWriterListener;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.store.CarbonDataFileAttributes;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.log4j.Logger;

public class CarbonFactDataHandlerModel {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonFactDataHandlerModel.class.getName());
    private String databaseName;
    private String tableName;
    private int blockSize;
    private String[] storeLocation;
    private Map<Integer, GenericDataType> complexIndexMap;
    private SegmentProperties segmentProperties;
    private DataType[] measureDataType;
    private CarbonColumn[] noDictAndComplexColumns;
    private CarbonDataFileAttributes carbonDataFileAttributes;
    private String carbonDataDirectoryPath;
    private List<ColumnSchema> wrapperColumnSchema;
    private boolean isCompactionFlow;
    private int bucketId = 0;
    private String segmentId;
    private long schemaUpdatedTimeStamp;
    private int taskExtension;
    private TableSpec tableSpec;
    private SortScopeOptions.SortScope sortScope;
    private IndexWriterListener indexWriterlistener;
    private short writingCoresCount;
    private Map<String, LocalDictionaryGenerator> columnLocalDictGenMap;
    private int numberOfCores;
    private String columnCompressor;
    private List<DataType> noDictDataTypesList;
    private int noDictAllComplexColumnDepth;
    private DataLoadMetrics metrics;

    public int getBlockSizeInMB() {
        return this.blockSize;
    }

    public void setBlockSizeInMB(int blockSize) {
        this.blockSize = blockSize;
    }

    public static CarbonFactDataHandlerModel createCarbonFactDataHandlerModel(CarbonDataLoadConfiguration configuration, String[] storeLocation, int bucketId, int taskExtension, IndexWriterListener listener) {
        int simpleDimsCount;
        CarbonTableIdentifier identifier = configuration.getTableIdentifier().getCarbonTableIdentifier();
        CarbonTable carbonTable = configuration.getTableSpec().getCarbonTable();
        List wrapperColumnSchema = CarbonUtil.getColumnSchemaList((List)carbonTable.getVisibleDimensions(), (List)carbonTable.getVisibleMeasures());
        SegmentProperties segmentProperties = new SegmentProperties(wrapperColumnSchema);
        int complexDimensionCount = segmentProperties.getNumberOfComplexDimensions();
        int surrIndex = simpleDimsCount = segmentProperties.getNumberOfPrimitiveDimensions();
        Iterator<Map.Entry<String, GenericDataType>> complexMap = CarbonDataProcessorUtil.getComplexTypesMap(configuration.getDataFields(), configuration.getDataLoadProperty("SERIALIZATION_NULL_FORMAT").toString()).entrySet().iterator();
        HashMap<Integer, GenericDataType> complexIndexMap = new HashMap<Integer, GenericDataType>(complexDimensionCount);
        while (complexMap.hasNext()) {
            Map.Entry<String, GenericDataType> complexDataType = complexMap.next();
            complexDataType.getValue().setOutputArrayIndex(0);
            complexIndexMap.put(simpleDimsCount, complexDataType.getValue());
            ++simpleDimsCount;
            ArrayList primitiveTypes = new ArrayList();
            complexDataType.getValue().getAllPrimitiveChildren(primitiveTypes);
            Iterator iterator = primitiveTypes.iterator();
            while (iterator.hasNext()) {
                GenericDataType eachPrimitive = (GenericDataType)iterator.next();
                if (!eachPrimitive.getIsColumnDictionary()) continue;
                eachPrimitive.setSurrogateIndex(surrIndex++);
            }
        }
        ArrayList<DataType> noDictDataTypesList = new ArrayList<DataType>();
        for (DataField dataField : configuration.getDataFields()) {
            if (dataField.isDateDataType() || !dataField.getColumn().isDimension().booleanValue()) continue;
            noDictDataTypesList.add(dataField.getColumn().getDataType());
        }
        CarbonDataFileAttributes carbonDataFileAttributes = new CarbonDataFileAttributes(configuration.getTaskNo(), (long)((Long)configuration.getDataLoadProperty("FACT_TIME_STAMP")));
        String carbonDataDirectoryPath = CarbonFactDataHandlerModel.getCarbonDataFolderLocation(configuration);
        CarbonFactDataHandlerModel carbonFactDataHandlerModel = new CarbonFactDataHandlerModel();
        carbonFactDataHandlerModel.setSchemaUpdatedTimeStamp(configuration.getSchemaUpdatedTimeStamp());
        carbonFactDataHandlerModel.setDatabaseName(identifier.getDatabaseName());
        carbonFactDataHandlerModel.setTableName(identifier.getTableName());
        carbonFactDataHandlerModel.setStoreLocation(storeLocation);
        carbonFactDataHandlerModel.setNoDictDataTypesList(noDictDataTypesList);
        carbonFactDataHandlerModel.setComplexIndexMap(complexIndexMap);
        carbonFactDataHandlerModel.setSegmentProperties(segmentProperties);
        carbonFactDataHandlerModel.setMeasureDataType(configuration.getMeasureDataType());
        carbonFactDataHandlerModel.setNoDictAndComplexColumns(configuration.getNoDictAndComplexDimensions());
        carbonFactDataHandlerModel.setWrapperColumnSchema(wrapperColumnSchema);
        carbonFactDataHandlerModel.setCarbonDataFileAttributes(carbonDataFileAttributes);
        carbonFactDataHandlerModel.setCarbonDataDirectoryPath(carbonDataDirectoryPath);
        carbonFactDataHandlerModel.setBlockSizeInMB(carbonTable.getBlockSizeInMB());
        carbonFactDataHandlerModel.bucketId = bucketId;
        carbonFactDataHandlerModel.segmentId = configuration.getSegmentId();
        carbonFactDataHandlerModel.taskExtension = taskExtension;
        carbonFactDataHandlerModel.tableSpec = configuration.getTableSpec();
        carbonFactDataHandlerModel.sortScope = CarbonDataProcessorUtil.getSortScope(configuration);
        carbonFactDataHandlerModel.columnCompressor = configuration.getColumnCompressor();
        if (listener == null) {
            listener = new IndexWriterListener();
            listener.registerAllWriter(configuration.getTableSpec().getCarbonTable(), configuration.getSegmentId(), CarbonTablePath.getShardName((String)carbonDataFileAttributes.getTaskId(), (int)bucketId, (int)taskExtension, (String)String.valueOf(carbonDataFileAttributes.getFactTimeStamp()), (String)configuration.getSegmentId()), segmentProperties);
        }
        carbonFactDataHandlerModel.indexWriterlistener = listener;
        carbonFactDataHandlerModel.writingCoresCount = configuration.getWritingCoresCount();
        carbonFactDataHandlerModel.initNumberOfCores();
        carbonFactDataHandlerModel.setMetrics(configuration.getMetrics());
        return carbonFactDataHandlerModel;
    }

    public static CarbonFactDataHandlerModel getCarbonFactDataHandlerModel(CarbonLoadModel loadModel, CarbonTable carbonTable, SegmentProperties segmentProperties, String tableName, String[] tempStoreLocation, String carbonDataDirectoryPath) {
        List allDimensions = carbonTable.getVisibleDimensions();
        CarbonColumn[] noDicAndComplexColumns = new CarbonColumn[segmentProperties.getNumberOfNoDictionaryDimension() + segmentProperties.getComplexDimensions().size()];
        int noDicAndComp = 0;
        ArrayList<DataType> noDictDataTypesList = new ArrayList<DataType>();
        for (CarbonDimension dim : allDimensions) {
            if (dim.getDataType() == DataTypes.DATE) continue;
            noDicAndComplexColumns[noDicAndComp++] = new CarbonColumn(dim.getColumnSchema(), dim.getOrdinal(), dim.getSchemaOrdinal());
            noDictDataTypesList.add(dim.getDataType());
        }
        CarbonFactDataHandlerModel carbonFactDataHandlerModel = new CarbonFactDataHandlerModel();
        carbonFactDataHandlerModel.setSchemaUpdatedTimeStamp(carbonTable.getTableLastUpdatedTime());
        carbonFactDataHandlerModel.setDatabaseName(loadModel.getDatabaseName());
        carbonFactDataHandlerModel.setTableName(tableName);
        carbonFactDataHandlerModel.setStoreLocation(tempStoreLocation);
        carbonFactDataHandlerModel.setSegmentProperties(segmentProperties);
        carbonFactDataHandlerModel.setSegmentId(loadModel.getSegmentId());
        List wrapperColumnSchema = CarbonUtil.getColumnSchemaList((List)carbonTable.getVisibleDimensions(), (List)carbonTable.getVisibleMeasures());
        carbonFactDataHandlerModel.setWrapperColumnSchema(wrapperColumnSchema);
        carbonFactDataHandlerModel.setComplexIndexMap(CarbonFactDataHandlerModel.convertComplexDimensionToComplexIndexMap(segmentProperties, loadModel.getSerializationNullFormat()));
        DataType[] measureDataTypes = new DataType[segmentProperties.getMeasures().size()];
        int i = 0;
        for (CarbonMeasure msr : segmentProperties.getMeasures()) {
            measureDataTypes[i++] = msr.getDataType();
        }
        carbonFactDataHandlerModel.setMeasureDataType(measureDataTypes);
        carbonFactDataHandlerModel.setNoDictAndComplexColumns(noDicAndComplexColumns);
        carbonFactDataHandlerModel.setNoDictDataTypesList(noDictDataTypesList);
        CarbonUtil.checkAndCreateFolderWithPermission((String)carbonDataDirectoryPath);
        carbonFactDataHandlerModel.setCarbonDataDirectoryPath(carbonDataDirectoryPath);
        carbonFactDataHandlerModel.setBlockSizeInMB(carbonTable.getBlockSizeInMB());
        carbonFactDataHandlerModel.setColumnCompressor(loadModel.getColumnCompressor());
        carbonFactDataHandlerModel.tableSpec = new TableSpec(carbonTable, false);
        IndexWriterListener listener = new IndexWriterListener();
        listener.registerAllWriter(carbonTable, loadModel.getSegmentId(), CarbonTablePath.getShardName((String)CarbonTablePath.DataFileUtil.getTaskIdFromTaskNo((String)loadModel.getTaskNo()), (int)carbonFactDataHandlerModel.getBucketId(), (int)carbonFactDataHandlerModel.getTaskExtension(), (String)String.valueOf(loadModel.getFactTimeStamp()), (String)loadModel.getSegmentId()), segmentProperties);
        carbonFactDataHandlerModel.indexWriterlistener = listener;
        carbonFactDataHandlerModel.initNumberOfCores();
        carbonFactDataHandlerModel.setColumnLocalDictGenMap(CarbonUtil.getLocalDictionaryModel((CarbonTable)carbonTable));
        carbonFactDataHandlerModel.sortScope = carbonTable.getSortScope();
        carbonFactDataHandlerModel.setMetrics(loadModel.getMetrics());
        return carbonFactDataHandlerModel;
    }

    private static Map<Integer, GenericDataType> convertComplexDimensionToComplexIndexMap(SegmentProperties segmentProperties, String nullFormat) {
        List complexDimensions = segmentProperties.getComplexDimensions();
        int simpleDimsCount = segmentProperties.getNumberOfPrimitiveDimensions();
        DataField[] dataFields = new DataField[complexDimensions.size()];
        int i = 0;
        for (CarbonColumn complexDimension : complexDimensions) {
            dataFields[i++] = new DataField(complexDimension);
        }
        return CarbonFactDataHandlerModel.getComplexMap(nullFormat, simpleDimsCount, dataFields);
    }

    private static Map<Integer, GenericDataType> getComplexMap(String nullFormat, int simpleDimsCount, DataField[] dataFields) {
        int surrIndex = 0;
        Iterator<Map.Entry<String, GenericDataType>> complexMap = CarbonDataProcessorUtil.getComplexTypesMap(dataFields, nullFormat).entrySet().iterator();
        HashMap<Integer, GenericDataType> complexIndexMap = new HashMap<Integer, GenericDataType>(dataFields.length);
        while (complexMap.hasNext()) {
            Map.Entry<String, GenericDataType> complexDataType = complexMap.next();
            complexDataType.getValue().setOutputArrayIndex(0);
            complexIndexMap.put(simpleDimsCount, complexDataType.getValue());
            ++simpleDimsCount;
            ArrayList<GenericDataType> primitiveTypes = new ArrayList<GenericDataType>();
            complexDataType.getValue().getAllPrimitiveChildren(primitiveTypes);
            for (GenericDataType eachPrimitive : primitiveTypes) {
                if (!eachPrimitive.getIsColumnDictionary()) continue;
                eachPrimitive.setSurrogateIndex(surrIndex++);
            }
        }
        return complexIndexMap;
    }

    private static String getCarbonDataFolderLocation(CarbonDataLoadConfiguration configuration) {
        if (configuration.getDataWritePath() != null) {
            AbsoluteTableIdentifier absoluteTableIdentifier;
            String partPath;
            String paths = configuration.getDataWritePath();
            String[] dirs = paths.split(partPath = (absoluteTableIdentifier = configuration.getTableIdentifier()).getTablePath());
            if (dirs.length > 1) {
                String[] partDirs;
                for (String partDir : partDirs = dirs[1].split("/")) {
                    if (partDir.isEmpty()) continue;
                    partPath = partPath.concat("/" + partDir);
                    CarbonUtil.checkAndCreateFolderWithPermission((String)partPath);
                }
            } else {
                CarbonUtil.checkAndCreateFolderWithPermission((String)paths);
            }
            return paths;
        }
        AbsoluteTableIdentifier absoluteTableIdentifier = configuration.getTableIdentifier();
        String carbonDataDirectoryPath = !configuration.isCarbonTransactionalTable() ? absoluteTableIdentifier.getTablePath() : (configuration.getSegmentPath() != null ? configuration.getSegmentPath() : CarbonTablePath.getSegmentPath((String)absoluteTableIdentifier.getTablePath(), (String)(configuration.getSegmentId() + "")));
        CarbonUtil.checkAndCreateFolder((String)carbonDataDirectoryPath);
        return carbonDataDirectoryPath;
    }

    public CarbonDataFileAttributes getCarbonDataFileAttributes() {
        return this.carbonDataFileAttributes;
    }

    public void setCarbonDataFileAttributes(CarbonDataFileAttributes carbonDataFileAttributes) {
        this.carbonDataFileAttributes = carbonDataFileAttributes;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getMeasureCount() {
        return this.segmentProperties.getNumberOfMeasures();
    }

    public String[] getStoreLocation() {
        return this.storeLocation;
    }

    public void setStoreLocation(String[] storeLocation) {
        this.storeLocation = storeLocation;
    }

    public int getNoDictionaryCount() {
        return this.segmentProperties.getNumberOfNoDictionaryDimension();
    }

    public int getDictDimensionCount() {
        return this.segmentProperties.getNumberOfDictDimensions();
    }

    public Map<Integer, GenericDataType> getComplexIndexMap() {
        return this.complexIndexMap;
    }

    public void setComplexIndexMap(Map<Integer, GenericDataType> complexIndexMap) {
        this.complexIndexMap = complexIndexMap;
    }

    public DataType[] getMeasureDataType() {
        return this.measureDataType;
    }

    public void setMeasureDataType(DataType[] measureDataType) {
        this.measureDataType = measureDataType;
    }

    public String getCarbonDataDirectoryPath() {
        return this.carbonDataDirectoryPath;
    }

    public void setCarbonDataDirectoryPath(String carbonDataDirectoryPath) {
        this.carbonDataDirectoryPath = carbonDataDirectoryPath;
    }

    public boolean isCompactionFlow() {
        return this.isCompactionFlow;
    }

    public void setCompactionFlow(boolean compactionFlow) {
        this.isCompactionFlow = compactionFlow;
        this.initNumberOfCores();
    }

    public SegmentProperties getSegmentProperties() {
        return this.segmentProperties;
    }

    public void setSegmentProperties(SegmentProperties segmentProperties) {
        this.segmentProperties = segmentProperties;
    }

    public List<ColumnSchema> getWrapperColumnSchema() {
        return this.wrapperColumnSchema;
    }

    public void setWrapperColumnSchema(List<ColumnSchema> wrapperColumnSchema) {
        this.wrapperColumnSchema = wrapperColumnSchema;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(int bucketId) {
        this.bucketId = bucketId;
    }

    public long getSchemaUpdatedTimeStamp() {
        return this.schemaUpdatedTimeStamp;
    }

    public void setSchemaUpdatedTimeStamp(long schemaUpdatedTimeStamp) {
        this.schemaUpdatedTimeStamp = schemaUpdatedTimeStamp;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public int getTaskExtension() {
        return this.taskExtension;
    }

    public int getComplexColumnCount() {
        return this.segmentProperties.getNumberOfComplexDimensions();
    }

    public int getExpandedComplexColsCount() {
        int count = 0;
        int dictDimensionCount = this.getDictDimensionCount();
        for (int i = 0; i < dictDimensionCount; ++i) {
            GenericDataType complexDataType = this.getComplexIndexMap().get(i);
            if (complexDataType == null) continue;
            count += complexDataType.getColsCount();
        }
        return count;
    }

    public TableSpec getTableSpec() {
        return this.tableSpec;
    }

    public SortScopeOptions.SortScope getSortScope() {
        return this.sortScope;
    }

    public short getWritingCoresCount() {
        return this.writingCoresCount;
    }

    public IndexWriterListener getIndexWriterlistener() {
        return this.indexWriterlistener;
    }

    public Map<String, LocalDictionaryGenerator> getColumnLocalDictGenMap() {
        return this.columnLocalDictGenMap;
    }

    public void setColumnLocalDictGenMap(Map<String, LocalDictionaryGenerator> columnLocalDictGenMap) {
        this.columnLocalDictGenMap = columnLocalDictGenMap;
    }

    private void initNumberOfCores() {
        this.numberOfCores = this.isCompactionFlow() ? CarbonProperties.getInstance().getNumberOfCompactingCores() : CarbonProperties.getInstance().getNumberOfLoadingCores();
        if (this.sortScope != null && this.sortScope.equals((Object)SortScopeOptions.SortScope.GLOBAL_SORT) && (this.tableSpec.getCarbonTable().getRangeColumn() == null || this.tableSpec.getCarbonTable().getRangeColumn() != null && !this.isCompactionFlow)) {
            this.numberOfCores = 1;
        }
        if (this.getWritingCoresCount() > 0) {
            this.numberOfCores = this.getWritingCoresCount();
        }
    }

    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    public String getColumnCompressor() {
        return this.columnCompressor;
    }

    public void setColumnCompressor(String columnCompressor) {
        this.columnCompressor = columnCompressor;
    }

    public CarbonColumn[] getNoDictAndComplexColumns() {
        return this.noDictAndComplexColumns;
    }

    public void setNoDictAndComplexColumns(CarbonColumn[] noDictAndComplexColumns) {
        this.noDictAndComplexColumns = noDictAndComplexColumns;
    }

    public List<DataType> getNoDictDataTypesList() {
        return this.noDictDataTypesList;
    }

    public void setNoDictDataTypesList(List<DataType> noDictDataTypesList) {
        this.noDictDataTypesList = noDictDataTypesList;
    }

    public int getNoDictAllComplexColumnDepth() {
        return this.noDictAllComplexColumnDepth;
    }

    public void setNoDictAllComplexColumnDepth(int noDictAllComplexColumnDepth) {
        this.noDictAllComplexColumnDepth = noDictAllComplexColumnDepth;
    }

    public DataLoadMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(DataLoadMetrics metrics) {
        this.metrics = metrics;
    }
}

