/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.block.Distributable;
import org.apache.carbondata.core.datastore.block.TableBlockInfo;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.enums.EscapeSequences;
import org.apache.carbondata.core.index.Segment;
import org.apache.carbondata.core.locks.CarbonLockUtil;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.SegmentFileStore;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.CarbonIndexFileMergeWriter;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.NodeMultiBlockRelation;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class CarbonLoaderUtil {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonLoaderUtil.class.getName());

    private CarbonLoaderUtil() {
    }

    public static void deleteSegmentForFailure(CarbonLoadModel loadModel) {
        int currentLoad = Integer.parseInt(loadModel.getSegmentId());
        String segmentPath = CarbonTablePath.getSegmentPath((String)loadModel.getTablePath(), (String)(currentLoad + ""));
        try {
            if (FileFactory.isFileExist((String)segmentPath)) {
                CarbonFile carbonFile = FileFactory.getCarbonFile((String)segmentPath);
                CarbonUtil.deleteFoldersAndFiles((CarbonFile[])new CarbonFile[]{carbonFile});
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error((Object)("Unable to delete segment: " + segmentPath + ", " + e.getMessage()), (Throwable)e);
        }
    }

    public static boolean isValidSegment(CarbonLoadModel loadModel, int currentLoad) {
        int fileCount = 0;
        String segmentPath = CarbonTablePath.getSegmentPath((String)loadModel.getTablePath(), (String)(currentLoad + ""));
        CarbonFile carbonFile = FileFactory.getCarbonFile((String)segmentPath);
        CarbonFile[] files = carbonFile.listFiles(new CarbonFileFilter(){

            public boolean accept(CarbonFile file) {
                return file.getName().endsWith(CarbonTablePath.getCarbonIndexExtension()) || file.getName().endsWith(CarbonTablePath.getCarbonDataExtension());
            }
        });
        fileCount += files.length;
        if (files.length > 0) {
            return true;
        }
        return fileCount != 0;
    }

    public static boolean recordNewLoadMetadata(LoadMetadataDetails newMetaEntry, CarbonLoadModel loadModel, boolean loadStartEntry, boolean insertOverwrite) throws IOException {
        return CarbonLoaderUtil.recordNewLoadMetadata(newMetaEntry, loadModel, loadStartEntry, insertOverwrite, "", false);
    }

    public static boolean recordNewLoadMetadata(CarbonLoadModel loadModel) throws IOException {
        LoadMetadataDetails newLoadMetaEntry = new LoadMetadataDetails();
        loadModel.setFactTimeStamp(System.currentTimeMillis());
        CarbonLoaderUtil.populateNewLoadMetaEntry(newLoadMetaEntry, SegmentStatus.INSERT_IN_PROGRESS, loadModel.getFactTimeStamp(), false);
        return CarbonLoaderUtil.recordNewLoadMetadata(newLoadMetaEntry, loadModel, true, false);
    }

    public static void deleteNonTransactionalTableForInsertOverwrite(final CarbonLoadModel loadModel) throws IOException {
        CarbonFile[] filteredList;
        ArrayList<String> filesToBeDeleted = new ArrayList<String>();
        CarbonFile carbonFile = FileFactory.getCarbonFile((String)loadModel.getTablePath());
        for (CarbonFile file : filteredList = carbonFile.listFiles(new CarbonFileFilter(){

            public boolean accept(CarbonFile file) {
                return !file.getName().contains(loadModel.getFactTimeStamp() + "");
            }
        })) {
            filesToBeDeleted.add(file.getAbsolutePath());
        }
        CarbonLoaderUtil.deleteFiles(filesToBeDeleted);
    }

    public static boolean recordNewLoadMetadata(LoadMetadataDetails newMetaEntry, CarbonLoadModel loadModel, boolean loadStartEntry, boolean insertOverwrite, String uuid, boolean isUpdateStatusRequired) throws IOException {
        if (!loadModel.isCarbonTransactionalTable()) {
            return true;
        }
        return CarbonLoaderUtil.recordNewLoadMetadata(newMetaEntry, loadModel, loadStartEntry, insertOverwrite, uuid, new ArrayList<Segment>(), new ArrayList<Segment>(), isUpdateStatusRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean recordNewLoadMetadata(LoadMetadataDetails newMetaEntry, CarbonLoadModel loadModel, boolean loadStartEntry, boolean insertOverwrite, String uuid, List<Segment> segmentsToBeDeleted, List<Segment> segmentFilesTobeUpdated, boolean isUpdateStatusRequired) throws IOException {
        String metadataPath;
        boolean status = false;
        AbsoluteTableIdentifier identifier = loadModel.getCarbonDataLoadSchema().getCarbonTable().getAbsoluteTableIdentifier();
        if (loadModel.isCarbonTransactionalTable() && !FileFactory.isFileExist((String)(metadataPath = CarbonTablePath.getMetadataPath((String)identifier.getTablePath())))) {
            FileFactory.mkdirs((String)metadataPath);
        }
        String tableStatusPath = CarbonTablePath.getTableStatusFilePath((String)identifier.getTablePath());
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
        ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
        int retryCount = CarbonLockUtil.getLockProperty((String)"carbon.concurrent.lock.retries", (int)100);
        int maxTimeout = CarbonLockUtil.getLockProperty((String)"carbon.concurrent.lock.retry.timeout.sec", (int)1);
        try {
            if (carbonLock.lockWithRetries(retryCount, maxTimeout)) {
                LOGGER.info((Object)("Acquired lock for table" + loadModel.getDatabaseName() + "." + loadModel.getTableName() + " for table status updation"));
                LoadMetadataDetails[] listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata((String)CarbonTablePath.getMetadataPath((String)identifier.getTablePath()));
                ArrayList<LoadMetadataDetails> listOfLoadFolderDetails = new ArrayList<LoadMetadataDetails>(16);
                Collections.addAll(listOfLoadFolderDetails, listOfLoadFolderDetailsArray);
                if (loadStartEntry) {
                    String segmentId = String.valueOf(SegmentStatusManager.createNewSegmentId((LoadMetadataDetails[])listOfLoadFolderDetailsArray));
                    loadModel.setLoadMetadataDetails(listOfLoadFolderDetails);
                    LoadMetadataDetails entryTobeRemoved = null;
                    if (loadModel.getCarbonDataLoadSchema().getCarbonTable().isMV() && !loadModel.getSegmentId().isEmpty()) {
                        for (LoadMetadataDetails entry : listOfLoadFolderDetails) {
                            if (!entry.getLoadName().equalsIgnoreCase(loadModel.getSegmentId())) continue;
                            newMetaEntry.setLoadName(loadModel.getSegmentId());
                            newMetaEntry.setExtraInfo(entry.getExtraInfo());
                            entryTobeRemoved = entry;
                        }
                    } else {
                        if (isUpdateStatusRequired && segmentId.equalsIgnoreCase("0") && !StringUtils.isBlank((CharSequence)uuid)) {
                            newMetaEntry.setUpdateStatusFileName(CarbonUpdateUtil.getUpdateStatusFileName((String)uuid));
                        }
                        newMetaEntry.setLoadName(segmentId);
                        loadModel.setSegmentId(segmentId);
                    }
                    listOfLoadFolderDetails.remove(entryTobeRemoved);
                    for (LoadMetadataDetails entry : listOfLoadFolderDetails) {
                        if (entry.getSegmentStatus() == SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS && SegmentStatusManager.isLoadInProgress((AbsoluteTableIdentifier)identifier, (String)entry.getLoadName())) {
                            throw new RuntimeException("Already insert overwrite is in progress");
                        }
                        if (newMetaEntry.getSegmentStatus() != SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS || entry.getSegmentStatus() != SegmentStatus.INSERT_IN_PROGRESS || !SegmentStatusManager.isLoadInProgress((AbsoluteTableIdentifier)identifier, (String)entry.getLoadName())) continue;
                        throw new RuntimeException("Already insert into or load is in progress");
                    }
                    listOfLoadFolderDetails.add(newMetaEntry);
                } else {
                    newMetaEntry.setLoadName(String.valueOf(loadModel.getSegmentId()));
                    int indexToOverwriteNewMetaEntry = 0;
                    boolean found = false;
                    for (LoadMetadataDetails entry : listOfLoadFolderDetails) {
                        if (entry.getLoadName().equals(newMetaEntry.getLoadName()) && entry.getLoadStartTime() == newMetaEntry.getLoadStartTime()) {
                            newMetaEntry.setExtraInfo(entry.getExtraInfo());
                            found = true;
                            break;
                        }
                        ++indexToOverwriteNewMetaEntry;
                    }
                    if (insertOverwrite) {
                        for (LoadMetadataDetails entry : listOfLoadFolderDetails) {
                            if (entry.getSegmentStatus() == SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS) continue;
                            entry.setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
                        }
                    }
                    if (!found) {
                        LOGGER.error((Object)("Entry not found to update " + newMetaEntry + " From list :: " + listOfLoadFolderDetails));
                        throw new IOException("Entry not found to update in the table status file");
                    }
                    listOfLoadFolderDetails.set(indexToOverwriteNewMetaEntry, newMetaEntry);
                }
                for (LoadMetadataDetails detail : listOfLoadFolderDetails) {
                    if (segmentsToBeDeleted.contains(new Segment(detail.getLoadName()))) {
                        detail.setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
                        continue;
                    }
                    if (segmentFilesTobeUpdated.contains(Segment.toSegment((String)detail.getLoadName(), null))) {
                        detail.setSegmentFile(detail.getLoadName() + "_" + newMetaEntry.getUpdateStatusFileName() + ".segment");
                        continue;
                    }
                    if (!isUpdateStatusRequired || !detail.getLoadName().equalsIgnoreCase("0") || StringUtils.isBlank((CharSequence)uuid)) continue;
                    detail.setUpdateStatusFileName(CarbonUpdateUtil.getUpdateStatusFileName((String)uuid));
                }
                SegmentStatusManager.writeLoadDetailsIntoFile((String)tableStatusPath, (LoadMetadataDetails[])listOfLoadFolderDetails.toArray(new LoadMetadataDetails[0]));
                status = true;
            } else {
                LOGGER.error((Object)("Not able to acquire the lock for Table status updation for table " + loadModel.getDatabaseName() + "." + loadModel.getTableName()));
            }
        }
        finally {
            if (carbonLock.unlock()) {
                LOGGER.info((Object)("Table unlocked successfully after table status updation" + loadModel.getDatabaseName() + "." + loadModel.getTableName()));
            } else {
                LOGGER.error((Object)("Unable to unlock Table lock for table" + loadModel.getDatabaseName() + "." + loadModel.getTableName() + " during table status updation"));
            }
        }
        return status;
    }

    public static void populateNewLoadMetaEntry(LoadMetadataDetails loadMetadataDetails, SegmentStatus loadStatus, long loadStartTime, boolean addLoadEndTime) {
        if (addLoadEndTime) {
            long loadEndDate = CarbonUpdateUtil.readCurrentTime();
            loadMetadataDetails.setLoadEndTime(loadEndDate);
        }
        loadMetadataDetails.setSegmentStatus(loadStatus);
        loadMetadataDetails.setLoadStartTime(loadStartTime);
    }

    public static boolean isValidEscapeSequence(String escapeChar) {
        return escapeChar.equalsIgnoreCase(EscapeSequences.NEW_LINE.getName()) || escapeChar.equalsIgnoreCase(EscapeSequences.CARRIAGE_RETURN.getName()) || escapeChar.equalsIgnoreCase(EscapeSequences.TAB.getName()) || escapeChar.equalsIgnoreCase(EscapeSequences.BACKSPACE.getName());
    }

    public static boolean isValidBinaryDecoder(String binaryDecoderChar) {
        return "base64".equalsIgnoreCase(binaryDecoderChar) || "hex".equalsIgnoreCase(binaryDecoderChar) || StringUtils.isBlank((CharSequence)binaryDecoderChar);
    }

    public static String getEscapeChar(String escapeCharacter) {
        if (escapeCharacter.equalsIgnoreCase(EscapeSequences.NEW_LINE.getName())) {
            return EscapeSequences.NEW_LINE.getEscapeChar();
        }
        if (escapeCharacter.equalsIgnoreCase(EscapeSequences.BACKSPACE.getName())) {
            return EscapeSequences.BACKSPACE.getEscapeChar();
        }
        if (escapeCharacter.equalsIgnoreCase(EscapeSequences.TAB.getName())) {
            return EscapeSequences.TAB.getEscapeChar();
        }
        if (escapeCharacter.equalsIgnoreCase(EscapeSequences.CARRIAGE_RETURN.getName())) {
            return EscapeSequences.CARRIAGE_RETURN.getEscapeChar();
        }
        return escapeCharacter;
    }

    public static void readAndUpdateLoadProgressInTableMeta(CarbonLoadModel model, boolean insertOverwrite, String uuid) throws IOException {
        LoadMetadataDetails newLoadMetaEntry = new LoadMetadataDetails();
        SegmentStatus status = SegmentStatus.INSERT_IN_PROGRESS;
        if (insertOverwrite) {
            status = SegmentStatus.INSERT_OVERWRITE_IN_PROGRESS;
        }
        if (model.getFactTimeStamp() == 0L) {
            long loadStartTime = CarbonUpdateUtil.readCurrentTime();
            model.setFactTimeStamp(loadStartTime);
        }
        CarbonLoaderUtil.populateNewLoadMetaEntry(newLoadMetaEntry, status, model.getFactTimeStamp(), false);
        boolean entryAdded = CarbonLoaderUtil.recordNewLoadMetadata(newLoadMetaEntry, model, true, insertOverwrite, uuid, false);
        if (!entryAdded) {
            throw new IOException("Dataload failed due to failure in table status updation for " + model.getTableName());
        }
    }

    public static void readAndUpdateLoadProgressInTableMeta(CarbonLoadModel model, boolean insertOverwrite) throws IOException {
        CarbonLoaderUtil.readAndUpdateLoadProgressInTableMeta(model, insertOverwrite, "");
    }

    public static void updateTableStatusForFailure(CarbonLoadModel model, String uuid) throws IOException {
        SegmentStatus loadStatus = SegmentStatus.MARKED_FOR_DELETE;
        LoadMetadataDetails loadMetaEntry = model.getCurrentLoadMetadataDetail();
        if (loadMetaEntry == null) {
            return;
        }
        CarbonLoaderUtil.populateNewLoadMetaEntry(loadMetaEntry, loadStatus, model.getFactTimeStamp(), true);
        boolean entryAdded = CarbonLoaderUtil.recordNewLoadMetadata(loadMetaEntry, model, false, false, uuid, false);
        if (!entryAdded) {
            throw new IOException("Failed to update failure entry in table status for " + model.getTableName());
        }
    }

    public static void updateTableStatusForFailure(CarbonLoadModel model) throws IOException {
        CarbonLoaderUtil.updateTableStatusForFailure(model, "");
    }

    public static Map<String, List<List<Distributable>>> nodeBlockTaskMapping(List<Distributable> blockInfos, int noOfNodesInput, int parallelism, List<String> activeNode) {
        Map<String, List<Distributable>> mapOfNodes = CarbonLoaderUtil.nodeBlockMapping(blockInfos, noOfNodesInput, activeNode, BlockAssignmentStrategy.BLOCK_NUM_FIRST, null);
        int taskPerNode = parallelism / mapOfNodes.size();
        int noOfTasksPerNode = taskPerNode == 0 ? 1 : taskPerNode;
        return CarbonLoaderUtil.assignBlocksToTasksPerNode(mapOfNodes, noOfTasksPerNode);
    }

    public static Map<String, List<Distributable>> nodeBlockMapping(List<Distributable> blockInfos, int noOfNodesInput, List<String> activeNodes) {
        return CarbonLoaderUtil.nodeBlockMapping(blockInfos, noOfNodesInput, activeNodes, BlockAssignmentStrategy.BLOCK_NUM_FIRST, null);
    }

    public static Map<String, List<Distributable>> nodeBlockMapping(List<Distributable> blockInfos) {
        return CarbonLoaderUtil.nodeBlockMapping(blockInfos, -1, null, BlockAssignmentStrategy.BLOCK_NUM_FIRST, null);
    }

    public static Map<String, List<Distributable>> nodeBlockMapping(List<Distributable> blockInfos, int numOfNodesInput, List<String> activeNodes, BlockAssignmentStrategy blockAssignmentStrategy, String expectedMinSizePerNode) {
        int numOfNodes;
        ArrayList<NodeMultiBlockRelation> rtnNode2Blocks = new ArrayList<NodeMultiBlockRelation>();
        HashSet<Distributable> uniqueBlocks = new HashSet<Distributable>(blockInfos);
        ArrayList<NodeMultiBlockRelation> originNode2Blocks = CarbonLoaderUtil.createNode2BlocksMapping(blockInfos);
        HashSet<String> nodes = new HashSet<String>(originNode2Blocks.size());
        for (NodeMultiBlockRelation relation : originNode2Blocks) {
            nodes.add(relation.getNode());
        }
        int n = numOfNodes = -1 == numOfNodesInput ? nodes.size() : numOfNodesInput;
        if (null != activeNodes) {
            numOfNodes = activeNodes.size();
        }
        long sizePerNode = 0L;
        long totalFileSize = 0L;
        if (BlockAssignmentStrategy.BLOCK_NUM_FIRST == blockAssignmentStrategy) {
            if (blockInfos.size() > 0) {
                sizePerNode = blockInfos.size() / numOfNodes;
            }
            sizePerNode = sizePerNode <= 0L ? 1L : sizePerNode;
        } else if (BlockAssignmentStrategy.BLOCK_SIZE_FIRST == blockAssignmentStrategy || BlockAssignmentStrategy.NODE_MIN_SIZE_FIRST == blockAssignmentStrategy) {
            for (Distributable blockInfo : uniqueBlocks) {
                totalFileSize += ((TableBlockInfo)blockInfo).getBlockLength();
            }
            sizePerNode = totalFileSize / (long)numOfNodes;
        }
        if (BlockAssignmentStrategy.NODE_MIN_SIZE_FIRST == blockAssignmentStrategy) {
            long expectedMinSizePerNodeInt = 0L;
            if (CarbonUtil.validateValidIntType((String)expectedMinSizePerNode)) {
                expectedMinSizePerNodeInt = Integer.parseInt(expectedMinSizePerNode);
            } else {
                LOGGER.warn((Object)("Invalid load_min_size_inmb value found: " + expectedMinSizePerNode + ", only int value greater than 0 is supported."));
                expectedMinSizePerNodeInt = Integer.parseInt("0");
            }
            if (expectedMinSizePerNodeInt * 1024L * 1024L < sizePerNode) {
                if (CarbonProperties.getInstance().isLoadSkewedDataOptimizationEnabled()) {
                    blockAssignmentStrategy = BlockAssignmentStrategy.BLOCK_SIZE_FIRST;
                } else {
                    blockAssignmentStrategy = BlockAssignmentStrategy.BLOCK_NUM_FIRST;
                    sizePerNode = numOfNodes == 0 ? 1L : ((sizePerNode = (long)(blockInfos.size() / numOfNodes)) <= 0L ? 1L : sizePerNode);
                }
                LOGGER.info((Object)("Specified minimum data size to load is less than the average size for each node, fallback to default strategy" + (Object)((Object)blockAssignmentStrategy)));
            } else {
                sizePerNode = expectedMinSizePerNodeInt;
            }
        }
        if (BlockAssignmentStrategy.NODE_MIN_SIZE_FIRST == blockAssignmentStrategy) {
            CarbonLoaderUtil.assignBlocksIgnoreDataLocality(rtnNode2Blocks, sizePerNode, uniqueBlocks, activeNodes);
        } else {
            CarbonLoaderUtil.assignBlocksByDataLocality(rtnNode2Blocks, sizePerNode, uniqueBlocks, originNode2Blocks, activeNodes, blockAssignmentStrategy);
        }
        CarbonLoaderUtil.assignLeftOverBlocks(rtnNode2Blocks, uniqueBlocks, sizePerNode, activeNodes, blockAssignmentStrategy);
        HashMap<String, List<Distributable>> rtnNodeBlocksMap = new HashMap<String, List<Distributable>>(16);
        for (NodeMultiBlockRelation relation : rtnNode2Blocks) {
            rtnNodeBlocksMap.put(relation.getNode(), relation.getBlocks());
        }
        return rtnNodeBlocksMap;
    }

    private static Map<String, List<List<Distributable>>> assignBlocksToTasksPerNode(Map<String, List<Distributable>> nodeBlocksMap, int noOfTasksPerNode) {
        HashMap<String, List<List<Distributable>>> outputMap = new HashMap<String, List<List<Distributable>>>(16);
        for (Map.Entry<String, List<Distributable>> eachNode : nodeBlocksMap.entrySet()) {
            List<Distributable> blockOfEachNode = eachNode.getValue();
            Collections.sort(blockOfEachNode);
            CarbonLoaderUtil.createTaskListForNode(outputMap, noOfTasksPerNode, eachNode.getKey());
            CarbonLoaderUtil.divideBlockToTasks(outputMap, eachNode.getKey(), blockOfEachNode);
        }
        return outputMap;
    }

    private static void divideBlockToTasks(Map<String, List<List<Distributable>>> outputMap, String key, List<Distributable> blockOfEachNode) {
        List<List<Distributable>> taskLists = outputMap.get(key);
        int tasksOfNode = taskLists.size();
        int i = 0;
        for (Distributable block : blockOfEachNode) {
            taskLists.get(i % tasksOfNode).add(block);
            ++i;
        }
    }

    private static void createTaskListForNode(Map<String, List<List<Distributable>>> outputMap, int noOfTasksPerNode, String key) {
        ArrayList nodeTaskList = new ArrayList(16);
        for (int i = 0; i < noOfTasksPerNode; ++i) {
            ArrayList eachTask = new ArrayList(16);
            nodeTaskList.add(eachTask);
        }
        outputMap.put(key, nodeTaskList);
    }

    private static void assignLeftOverBlocks(ArrayList<NodeMultiBlockRelation> outputMap, Set<Distributable> leftOverBlocks, long expectedSizePerNode, List<String> activeNodes, BlockAssignmentStrategy blockAssignmentStrategy) {
        HashMap<String, Integer> node2Idx = new HashMap<String, Integer>(outputMap.size());
        for (int idx = 0; idx < outputMap.size(); ++idx) {
            node2Idx.put(outputMap.get(idx).getNode(), idx);
        }
        if (activeNodes != null) {
            for (String activeNode : activeNodes) {
                ArrayList<Distributable> blockLst;
                Integer idx;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Second assignment iteration: assign for executor: " + activeNode));
                }
                if (node2Idx.containsKey(activeNode)) {
                    idx = (Integer)node2Idx.get(activeNode);
                    blockLst = outputMap.get(idx).getBlocks();
                } else {
                    idx = node2Idx.size();
                    blockLst = new ArrayList(16);
                }
                CarbonLoaderUtil.populateBlocks(leftOverBlocks, expectedSizePerNode, blockLst, blockAssignmentStrategy);
                if (node2Idx.containsKey(activeNode) || blockLst.size() <= 0) continue;
                outputMap.add(idx, new NodeMultiBlockRelation(activeNode, blockLst));
                node2Idx.put(activeNode, idx);
            }
        } else {
            for (NodeMultiBlockRelation entry : outputMap) {
                List<Distributable> blockLst = entry.getBlocks();
                CarbonLoaderUtil.populateBlocks(leftOverBlocks, expectedSizePerNode, blockLst, blockAssignmentStrategy);
            }
        }
        CarbonLoaderUtil.assignBlocksUseRoundRobin(outputMap, leftOverBlocks, blockAssignmentStrategy);
    }

    private static void populateBlocks(Set<Distributable> remainingBlocks, long expectedSizePerNode, List<Distributable> blockLst, BlockAssignmentStrategy blockAssignmentStrategy) {
        switch (blockAssignmentStrategy) {
            case BLOCK_NUM_FIRST: {
                CarbonLoaderUtil.populateBlocksByNum(remainingBlocks, expectedSizePerNode, blockLst);
                break;
            }
            case BLOCK_SIZE_FIRST: 
            case NODE_MIN_SIZE_FIRST: {
                CarbonLoaderUtil.populateBlocksBySize(remainingBlocks, expectedSizePerNode, blockLst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported block assignment strategy: " + (Object)((Object)blockAssignmentStrategy));
            }
        }
    }

    private static void populateBlocksByNum(Set<Distributable> remainingBlocks, long expectedSizePerNode, List<Distributable> blockLst) {
        Iterator<Distributable> blocks = remainingBlocks.iterator();
        if ((long)blockLst.size() == expectedSizePerNode) {
            return;
        }
        while (blocks.hasNext()) {
            Distributable block = blocks.next();
            blockLst.add(block);
            blocks.remove();
            if ((long)blockLst.size() < expectedSizePerNode) continue;
            break;
        }
    }

    private static void populateBlocksBySize(Set<Distributable> remainingBlocks, long expectedSizePerNode, List<Distributable> blockLst) {
        Iterator<Distributable> blocks = remainingBlocks.iterator();
        long fileSize = 0L;
        for (Distributable block : blockLst) {
            fileSize += ((TableBlockInfo)block).getBlockLength();
        }
        if (fileSize >= expectedSizePerNode) {
            LOGGER.debug((Object)"Capacity is full, skip allocate blocks on this node");
            return;
        }
        while (blocks.hasNext()) {
            Distributable block = blocks.next();
            long thisBlockSize = ((TableBlockInfo)block).getBlockLength();
            if (fileSize >= expectedSizePerNode) break;
            if (fileSize != 0L && !((double)(fileSize + thisBlockSize) <= (double)expectedSizePerNode * 1.1)) continue;
            blockLst.add(block);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Second Assignment iteration: " + ((TableBlockInfo)block).getFilePath() + "-" + ((TableBlockInfo)block).getBlockLength() + "-->currentNode"));
            }
            fileSize += thisBlockSize;
            blocks.remove();
        }
    }

    private static void assignBlocksUseRoundRobin(ArrayList<NodeMultiBlockRelation> node2Blocks, Set<Distributable> remainingBlocks, BlockAssignmentStrategy blockAssignmentStrategy) {
        switch (blockAssignmentStrategy) {
            case BLOCK_NUM_FIRST: {
                CarbonLoaderUtil.roundRobinAssignBlocksByNum(node2Blocks, remainingBlocks);
                break;
            }
            case BLOCK_SIZE_FIRST: 
            case NODE_MIN_SIZE_FIRST: {
                CarbonLoaderUtil.roundRobinAssignBlocksBySize(node2Blocks, remainingBlocks);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported block assignment strategy: " + (Object)((Object)blockAssignmentStrategy));
            }
        }
    }

    private static void roundRobinAssignBlocksByNum(ArrayList<NodeMultiBlockRelation> outputMap, Set<Distributable> remainingBlocks) {
        for (NodeMultiBlockRelation relation : outputMap) {
            Iterator<Distributable> blocks = remainingBlocks.iterator();
            if (!blocks.hasNext()) continue;
            Distributable block = blocks.next();
            List<Distributable> blockLst = relation.getBlocks();
            blockLst.add(block);
            blocks.remove();
        }
    }

    private static void roundRobinAssignBlocksBySize(ArrayList<NodeMultiBlockRelation> outputMap, Set<Distributable> remainingBlocks) {
        Iterator<Distributable> blocks = remainingBlocks.iterator();
        while (blocks.hasNext()) {
            Collections.sort(outputMap, NodeMultiBlockRelation.DATA_SIZE_ASC_COMPARATOR);
            Distributable block = blocks.next();
            List<Distributable> blockLst = outputMap.get(0).getBlocks();
            blockLst.add(block);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("RoundRobin assignment iteration: " + ((TableBlockInfo)block).getFilePath() + "-" + ((TableBlockInfo)block).getBlockLength() + "-->" + outputMap.get(0).getNode()));
            }
            blocks.remove();
        }
    }

    private static void assignBlocksByDataLocality(ArrayList<NodeMultiBlockRelation> outputNode2Blocks, long expectedSizePerNode, Set<Distributable> remainingBlocks, List<NodeMultiBlockRelation> inputNode2Blocks, List<String> activeNodes, BlockAssignmentStrategy blockAssignmentStrategy) {
        if (BlockAssignmentStrategy.BLOCK_SIZE_FIRST == blockAssignmentStrategy) {
            Collections.sort(inputNode2Blocks, NodeMultiBlockRelation.DATA_SIZE_DESC_COMPARATOR);
        } else {
            Collections.sort(inputNode2Blocks);
        }
        HashMap<String, Integer> node2Idx = new HashMap<String, Integer>();
        block2: for (NodeMultiBlockRelation nodeMultiBlockRelation : inputNode2Blocks) {
            String nodeName;
            String activeNode = nodeName = nodeMultiBlockRelation.getNode();
            if (null != activeNodes && null == (activeNode = CarbonLoaderUtil.getActiveNode(activeNodes, nodeName))) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("First Assignment iteration: assign for executor: " + activeNode));
            }
            List<Distributable> blocksInThisNode = nodeMultiBlockRelation.getBlocks();
            if (BlockAssignmentStrategy.BLOCK_SIZE_FIRST == blockAssignmentStrategy) {
                Collections.sort(blocksInThisNode, TableBlockInfo.DATA_SIZE_DESC_COMPARATOR);
            }
            long nodeCapacity = 0L;
            for (Distributable block : nodeMultiBlockRelation.getBlocks()) {
                Integer idx;
                if (!remainingBlocks.contains(block)) continue;
                if (!node2Idx.containsKey(activeNode)) {
                    idx = node2Idx.size();
                    outputNode2Blocks.add(idx, new NodeMultiBlockRelation(activeNode, new ArrayList<Distributable>(16)));
                    node2Idx.put(activeNode, idx);
                }
                if (BlockAssignmentStrategy.BLOCK_NUM_FIRST == blockAssignmentStrategy) {
                    if (nodeCapacity >= expectedSizePerNode) continue block2;
                    idx = (Integer)node2Idx.get(activeNode);
                    List<Distributable> infos = outputNode2Blocks.get(idx).getBlocks();
                    infos.add(block);
                    ++nodeCapacity;
                    if (LOGGER.isDebugEnabled()) {
                        try {
                            LOGGER.debug((Object)("First Assignment iteration: block(" + StringUtils.join((Object[])block.getLocations(), (String)", ") + ")-->" + activeNode));
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    remainingBlocks.remove(block);
                    continue;
                }
                if (BlockAssignmentStrategy.BLOCK_SIZE_FIRST == blockAssignmentStrategy) {
                    long thisBlockSize = ((TableBlockInfo)block).getBlockLength();
                    if (nodeCapacity != 0L && nodeCapacity >= expectedSizePerNode) continue block2;
                    if (nodeCapacity != 0L && !((double)(nodeCapacity + thisBlockSize) <= (double)expectedSizePerNode * 1.05)) continue;
                    Integer idx2 = (Integer)node2Idx.get(activeNode);
                    List<Distributable> blocks = outputNode2Blocks.get(idx2).getBlocks();
                    blocks.add(block);
                    nodeCapacity += thisBlockSize;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("First Assignment iteration: " + ((TableBlockInfo)block).getFilePath() + '-' + ((TableBlockInfo)block).getBlockLength() + "-->" + activeNode));
                    }
                    remainingBlocks.remove(block);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported block assignment strategy: " + (Object)((Object)blockAssignmentStrategy));
            }
        }
    }

    private static void assignBlocksIgnoreDataLocality(ArrayList<NodeMultiBlockRelation> outputNode2Blocks, long expectedSizePerNode, Set<Distributable> remainingBlocks, List<String> activeNodes) {
        HashSet<Distributable> uniqueBlocks = new HashSet<Distributable>(remainingBlocks);
        ArrayList<String> shuffleNodes = new ArrayList<String>(activeNodes);
        Collections.shuffle(shuffleNodes);
        for (String activeNode : shuffleNodes) {
            long nodeCapacity = 0L;
            NodeMultiBlockRelation nodeBlock = new NodeMultiBlockRelation(activeNode, new ArrayList<Distributable>(16));
            for (Distributable block : uniqueBlocks) {
                if (!remainingBlocks.contains(block)) continue;
                long thisBlockSize = ((TableBlockInfo)block).getBlockLength();
                if (nodeCapacity != 0L && nodeCapacity + thisBlockSize > expectedSizePerNode * 1024L * 1024L) break;
                nodeBlock.getBlocks().add(block);
                nodeCapacity += thisBlockSize;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("First Assignment iteration: " + ((TableBlockInfo)block).getFilePath() + '-' + ((TableBlockInfo)block).getBlockLength() + "-->" + activeNode));
                }
                remainingBlocks.remove(block);
            }
            if (nodeBlock.getBlocks().size() == 0) continue;
            outputNode2Blocks.add(nodeBlock);
        }
    }

    private static String getActiveNode(List<String> activeNode, String nodeName) {
        try {
            boolean isActiveNode = activeNode.contains(nodeName);
            if (isActiveNode) {
                return nodeName;
            }
            if (nodeName.equals("localhost")) {
                String hostName = InetAddress.getLocalHost().getHostName();
                isActiveNode = activeNode.contains(hostName);
                if (isActiveNode) {
                    return hostName;
                }
            } else {
                String hostAddress = InetAddress.getByName(nodeName).getHostAddress();
                isActiveNode = activeNode.contains(hostAddress);
                if (isActiveNode) {
                    return hostAddress;
                }
            }
        }
        catch (UnknownHostException ue) {
            return null;
        }
        return null;
    }

    private static ArrayList<NodeMultiBlockRelation> createNode2BlocksMapping(List<Distributable> blockInfos) {
        HashMap<String, Integer> node2Idx = new HashMap<String, Integer>();
        ArrayList<NodeMultiBlockRelation> node2Blocks = new ArrayList<NodeMultiBlockRelation>();
        for (Distributable blockInfo : blockInfos) {
            try {
                for (String eachNode : blockInfo.getLocations()) {
                    List<Object> blocks;
                    Integer idx;
                    if (node2Idx.containsKey(eachNode)) {
                        idx = (Integer)node2Idx.get(eachNode);
                        blocks = node2Blocks.get(idx).getBlocks();
                        blocks.add(blockInfo);
                        continue;
                    }
                    idx = node2Idx.size();
                    blocks = new ArrayList<Distributable>();
                    blocks.add(blockInfo);
                    node2Blocks.add(idx, new NodeMultiBlockRelation(eachNode, blocks));
                    node2Idx.put(eachNode, idx);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("error getting location of block: " + blockInfo.toString(), e);
            }
        }
        return node2Blocks;
    }

    public static void checkAndCreateCarbonDataLocation(String segmentId, CarbonTable carbonTable) {
        String segmentFolder = CarbonTablePath.getSegmentPath((String)carbonTable.getTablePath(), (String)segmentId);
        CarbonUtil.checkAndCreateFolder((String)segmentFolder);
    }

    public static Long addDataIndexSizeIntoMetaEntry(LoadMetadataDetails loadMetadataDetails, String segmentId, CarbonTable carbonTable) throws IOException {
        HashMap dataIndexSize = CarbonUtil.getDataSizeAndIndexSize((String)carbonTable.getTablePath(), (Segment)new Segment(segmentId, loadMetadataDetails.getSegmentFile()));
        Long dataSize = (Long)dataIndexSize.get("datasize");
        loadMetadataDetails.setDataSize(String.valueOf(dataSize));
        Long indexSize = (Long)dataIndexSize.get("indexsize");
        loadMetadataDetails.setIndexSize(String.valueOf(indexSize));
        return dataSize + indexSize;
    }

    public static void addIndexSizeIntoMetaEntry(LoadMetadataDetails loadMetadataDetails, String segmentId, CarbonTable carbonTable) throws IOException {
        SegmentFileStore fileStore;
        Segment segment = new Segment(segmentId, loadMetadataDetails.getSegmentFile());
        if (segment.getSegmentFileName() != null && (fileStore = new SegmentFileStore(carbonTable.getTablePath(), segment.getSegmentFileName())).getLocationMap() != null) {
            fileStore.readIndexFiles(FileFactory.getConfiguration());
            long carbonIndexSize = CarbonUtil.getCarbonIndexSize((SegmentFileStore)fileStore, (Map)fileStore.getLocationMap());
            loadMetadataDetails.setIndexSize(String.valueOf(carbonIndexSize));
        }
    }

    public static String mergeIndexFilesInPartitionedSegment(CarbonTable table, String segmentId, String uuid, String partitionPath, boolean isOldStoreIndexFilesPresent) {
        String tablePath = table.getTablePath();
        return new CarbonIndexFileMergeWriter(table).mergeCarbonIndexFilesOfSegment(segmentId, uuid, tablePath, partitionPath, isOldStoreIndexFilesPresent);
    }

    public static SegmentFileStore.FolderDetails mergeIndexFilesInPartitionedTempSegment(CarbonTable table, String segmentId, String partitionPath, List<String> partitionInfo, String uuid, String tempFolderPath, String currPartitionSpec) throws IOException {
        String tablePath = table.getTablePath();
        return new CarbonIndexFileMergeWriter(table).mergeCarbonIndexFilesOfSegment(segmentId, tablePath, partitionPath, partitionInfo, uuid, tempFolderPath, currPartitionSpec);
    }

    public static String mergeIndexFilesInAddLoadSegment(CarbonTable table, String segmentId, String segmentPath, String uuid) {
        try {
            return new CarbonIndexFileMergeWriter(table).writeMergeIndexFileBasedOnSegmentFolder(null, false, segmentPath, segmentId, uuid, false);
        }
        catch (IOException e) {
            String message = "Failed to merge index files in path: " + segmentPath + ". " + e.getMessage();
            LOGGER.error((Object)message);
            throw new RuntimeException(message, e);
        }
    }

    private static void deleteFiles(List<String> filesToBeDeleted) throws IOException {
        for (String filePath : filesToBeDeleted) {
            FileFactory.deleteFile((String)filePath);
        }
    }

    public static void updateTableStatusInCaseOfFailure(String loadName, CarbonTable carbonTable, SegmentStatus status) throws IOException {
        CarbonLoaderUtil.updateTableStatusInCaseOfFailure(loadName, carbonTable.getAbsoluteTableIdentifier(), carbonTable.getTableName(), carbonTable.getDatabaseName(), carbonTable.getTablePath(), carbonTable.getMetadataPath(), status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTableStatusInCaseOfFailure(String loadName, AbsoluteTableIdentifier absoluteTableIdentifier, String tableName, String databaseName, String tablePath, String metaDataPath, SegmentStatus status) throws IOException {
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(absoluteTableIdentifier);
        ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
        try {
            if (carbonLock.lockWithRetries()) {
                LOGGER.info((Object)("Acquired lock for table" + databaseName + "." + tableName + " for table status updation"));
                LoadMetadataDetails[] loadMetadataDetails = SegmentStatusManager.readLoadMetadata((String)metaDataPath);
                boolean ifTableStatusUpdateRequired = false;
                for (LoadMetadataDetails loadMetadataDetail : loadMetadataDetails) {
                    if (loadMetadataDetail.getSegmentStatus() != status || !loadName.equalsIgnoreCase(loadMetadataDetail.getLoadName())) continue;
                    loadMetadataDetail.setSegmentStatus(SegmentStatus.MARKED_FOR_DELETE);
                    ifTableStatusUpdateRequired = true;
                    break;
                }
                if (ifTableStatusUpdateRequired) {
                    SegmentStatusManager.writeLoadDetailsIntoFile((String)CarbonTablePath.getTableStatusFilePath((String)tablePath), (LoadMetadataDetails[])loadMetadataDetails);
                }
            } else {
                LOGGER.error((Object)("Not able to acquire the lock for Table status updation for table " + databaseName + "." + tableName));
            }
        }
        finally {
            if (carbonLock.unlock()) {
                LOGGER.info((Object)("Table unlocked successfully after table status updation" + databaseName + "." + tableName));
            } else {
                LOGGER.error((Object)("Unable to unlock Table lock for table" + databaseName + "." + tableName + " during table status updation"));
            }
        }
    }

    public static enum BlockAssignmentStrategy {
        BLOCK_NUM_FIRST("Assign blocks to node base on number of blocks"),
        BLOCK_SIZE_FIRST("Assign blocks to node base on data size of blocks"),
        NODE_MIN_SIZE_FIRST("Assign blocks to node base on minimum size of inputs");

        private String name;

        private BlockAssignmentStrategy(String name) {
            this.name = name;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + ':' + this.name;
        }
    }
}

