/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.UUID;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hadoop.internal.ObjectArrayWritable;
import org.apache.carbondata.processing.loading.csvinput.CSVInputFormat;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

@InterfaceAudience.Internal
class CSVCarbonWriter
extends CarbonWriter {
    private Configuration configuration;
    private RecordWriter<NullWritable, ObjectArrayWritable> recordWriter;
    private TaskAttemptContext context;
    private ObjectArrayWritable writable;
    private CsvParser csvParser = null;
    private boolean skipHeader = false;
    private CarbonFile[] dataFiles;

    CSVCarbonWriter(CarbonLoadModel loadModel, Configuration hadoopConf) throws IOException {
        CarbonTableOutputFormat.setLoadModel((Configuration)hadoopConf, (CarbonLoadModel)loadModel);
        CarbonTableOutputFormat format = new CarbonTableOutputFormat();
        JobID jobId = new JobID(UUID.randomUUID().toString(), 0);
        Random random = new Random();
        TaskID task = new TaskID(jobId, TaskType.MAP, random.nextInt());
        TaskAttemptID attemptID = new TaskAttemptID(task, random.nextInt());
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(hadoopConf, attemptID);
        this.recordWriter = format.getRecordWriter((TaskAttemptContext)context);
        this.context = context;
        this.writable = new ObjectArrayWritable();
        this.configuration = hadoopConf;
    }

    public void setSkipHeader(boolean skipHeader) {
        this.skipHeader = skipHeader;
    }

    @Override
    public void write(Object object) throws IOException {
        try {
            this.writable.set((Object[])object);
            this.recordWriter.write((Object)NullWritable.get(), (Object)this.writable);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private CsvParser buildCsvParser(Configuration conf) {
        CsvParserSettings settings = CSVInputFormat.extractCsvParserSettings((Configuration)conf);
        return new CsvParser(settings);
    }

    @Override
    public void setDataFiles(CarbonFile[] dataFiles) throws IOException {
        if (dataFiles == null || dataFiles.length == 0) {
            throw new RuntimeException("data files can't be empty.");
        }
        FilterInputStream csvInputStream = null;
        CsvParser csvParser = this.buildCsvParser(this.configuration);
        for (CarbonFile dataFile : dataFiles) {
            try {
                csvInputStream = FileFactory.getDataInputStream((String)dataFile.getPath(), (int)-1, (Configuration)this.configuration);
                csvParser.beginParsing((InputStream)csvInputStream);
            }
            catch (IllegalArgumentException ex) {
                if (ex.getCause() instanceof FileNotFoundException) {
                    throw new FileNotFoundException("File " + dataFile + " not found to build carbon writer.");
                }
                throw ex;
            }
            finally {
                if (csvInputStream != null) {
                    csvInputStream.close();
                }
            }
        }
        this.dataFiles = dataFiles;
    }

    @Override
    public void write() throws IOException {
        if (this.dataFiles == null || this.dataFiles.length == 0) {
            throw new RuntimeException("'withCsvPath()' must be called to support load files");
        }
        this.csvParser = this.buildCsvParser(this.configuration);
        for (CarbonFile dataFile : this.dataFiles) {
            this.loadSingleFile(dataFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSingleFile(CarbonFile file) throws IOException {
        DataInputStream csvDataInputStream = FileFactory.getDataInputStream((String)file.getPath(), (int)-1, (Configuration)this.configuration);
        this.csvParser.beginParsing((InputStream)csvDataInputStream);
        boolean skipFirstRow = this.skipHeader;
        try {
            String[] row;
            while ((row = this.csvParser.parseNext()) != null) {
                if (skipFirstRow) {
                    skipFirstRow = false;
                    continue;
                }
                this.write(row);
            }
        }
        finally {
            if (csvDataInputStream != null) {
                csvDataInputStream.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.recordWriter.close(this.context);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

