/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.carbondata.common.exceptions.sql.InvalidLoadOptionException;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.Field;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.scan.expression.logical.AndExpression;
import org.apache.carbondata.core.scan.expression.logical.OrExpression;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hadoop.internal.ObjectArrayWritable;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.carbondata.sdk.file.CarbonSchemaReader;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;

public class CarbonIUD {
    private final Configuration configuration;
    private final Map<String, Map<String, Set<String>>> filterColumnToValueMappingForDelete;
    private final Map<String, Map<String, Set<String>>> filterColumnToValueMappingForUpdate;
    private final Map<String, Map<String, String>> updateColumnToValueMapping;

    private CarbonIUD(Configuration conf) {
        this.configuration = conf;
        this.filterColumnToValueMappingForDelete = new HashMap<String, Map<String, Set<String>>>();
        this.filterColumnToValueMappingForUpdate = new HashMap<String, Map<String, Set<String>>>();
        this.updateColumnToValueMapping = new HashMap<String, Map<String, String>>();
    }

    public static CarbonIUD getInstance(Configuration conf) {
        return new CarbonIUD(conf);
    }

    public static CarbonIUD getInstance() {
        return new CarbonIUD(null);
    }

    public CarbonIUD delete(String path, String column, String value) {
        this.prepareDelete(path, column, value, this.filterColumnToValueMappingForDelete);
        return this;
    }

    public void delete(String path, Expression filterExpression) throws IOException, InterruptedException {
        CarbonReader reader = CarbonReader.builder(path).projection(new String[]{"tupleId"}).withHadoopConf(this.configuration).filter(filterExpression).build();
        RecordWriter deleteDeltaWriter = CarbonTableOutputFormat.getDeleteDeltaRecordWriter((String)path);
        ObjectArrayWritable writable = new ObjectArrayWritable();
        while (reader.hasNext()) {
            Object[] row = (Object[])reader.readNextRow();
            writable.set(row);
            deleteDeltaWriter.write((Object)NullWritable.get(), (Object)writable);
        }
        deleteDeltaWriter.close(null);
        reader.close();
    }

    private void closeDelete() throws IOException, InterruptedException {
        for (Map.Entry<String, Map<String, Set<String>>> path : this.filterColumnToValueMappingForDelete.entrySet()) {
            this.deleteExecution(path.getKey());
            this.createEmptyMetadataFile(path.getKey());
        }
    }

    private void createEmptyMetadataFile(String path) throws IOException {
        CarbonFile emptySDKDirectory;
        if (!StringUtils.isEmpty((CharSequence)path) && !(emptySDKDirectory = FileFactory.getCarbonFile((String)(path = path + "/" + "emptyMetadataFolder"))).exists()) {
            emptySDKDirectory.mkdirs();
        }
    }

    public CarbonIUD update(String path, String column, String value, String updColumn, String updValue) {
        this.prepareUpdate(path, column, value, updColumn, updValue);
        return this;
    }

    public void update(String path, Expression filterExpression, Map<String, String> updatedColumnToValueMapping) throws IOException, InterruptedException, InvalidLoadOptionException {
        List<String> indexFiles = this.getCarbonIndexFile(path);
        Schema schema = CarbonSchemaReader.readSchema(indexFiles.get(0)).asOriginOrder();
        Field[] fields = schema.getFields();
        String[] projectionColumns = new String[fields.length + 1];
        for (int i = 0; i < fields.length; ++i) {
            projectionColumns[i] = fields[i].getFieldName();
        }
        projectionColumns[projectionColumns.length - 1] = "tupleId";
        CarbonWriter writer = CarbonWriter.builder().outputPath(path).withHadoopConf(this.configuration).withCsvInput(schema).writtenBy("CarbonIUD").build();
        CarbonReader reader = CarbonReader.builder(path).projection(projectionColumns).withHadoopConf(this.configuration).filter(filterExpression).build();
        RecordWriter deleteDeltaWriter = CarbonTableOutputFormat.getDeleteDeltaRecordWriter((String)path);
        ObjectArrayWritable writable = new ObjectArrayWritable();
        while (reader.hasNext()) {
            Object[] row = (Object[])reader.readNextRow();
            writable.set(Arrays.copyOfRange(row, row.length - 1, row.length));
            for (Map.Entry<String, String> column : updatedColumnToValueMapping.entrySet()) {
                row[this.getColumnIndex((Field[])fields, (String)column.getKey())] = column.getValue();
            }
            writer.write(Arrays.copyOfRange(row, 0, row.length - 1));
            deleteDeltaWriter.write((Object)NullWritable.get(), (Object)writable);
        }
        deleteDeltaWriter.close(null);
        writer.close();
        reader.close();
    }

    private void closeUpdate() throws IOException, InterruptedException, InvalidLoadOptionException {
        for (Map.Entry<String, Map<String, Set<String>>> path : this.filterColumnToValueMappingForUpdate.entrySet()) {
            if (!this.updateColumnToValueMapping.containsKey(path.getKey())) continue;
            this.updateExecution(path.getKey());
            this.createEmptyMetadataFile(path.getKey());
        }
    }

    public void commit() throws IOException, InterruptedException, InvalidLoadOptionException {
        if (this.filterColumnToValueMappingForDelete.size() != 0) {
            this.closeDelete();
        }
        if (this.filterColumnToValueMappingForUpdate.size() != 0 && !this.ifRowsDeleted()) {
            this.closeUpdate();
        }
    }

    private void updateExecution(String path) throws IOException, InterruptedException, InvalidLoadOptionException {
        Expression filterExpression = this.getExpression(path, this.filterColumnToValueMappingForUpdate.get(path));
        this.update(path, filterExpression, this.updateColumnToValueMapping.get(path));
    }

    private void deleteExecution(String path) throws IOException, InterruptedException {
        Expression filterExpression = this.getExpression(path, this.filterColumnToValueMappingForDelete.get(path));
        this.delete(path, filterExpression);
    }

    private void prepareUpdate(String path, String column, String value, String updColumn, String updValue) {
        this.prepareDelete(path, column, value, this.filterColumnToValueMappingForUpdate);
        updColumn = updColumn.toLowerCase().trim();
        if (this.updateColumnToValueMapping.containsKey(path)) {
            this.updateColumnToValueMapping.get(path).put(updColumn, updValue);
        } else {
            HashMap<String, String> columnToValue = new HashMap<String, String>();
            columnToValue.put(updColumn, updValue);
            this.updateColumnToValueMapping.put(path, columnToValue);
        }
    }

    private void prepareDelete(String path, String column, String value, Map<String, Map<String, Set<String>>> filterColumnToValueMapping) {
        column = column.toLowerCase().trim();
        if (filterColumnToValueMapping.containsKey(path)) {
            Map<String, Set<String>> columnToValueMapping = filterColumnToValueMapping.get(path);
            if (columnToValueMapping.containsKey(column)) {
                columnToValueMapping.get(column).add(value);
            } else {
                HashSet<String> columnValues = new HashSet<String>();
                columnValues.add(value);
                columnToValueMapping.put(column, columnValues);
            }
        } else {
            HashMap columnToValueMapping = new HashMap();
            HashSet<String> columnValues = new HashSet<String>();
            columnValues.add(value);
            columnToValueMapping.put(column, columnValues);
            filterColumnToValueMapping.put(path, columnToValueMapping);
        }
    }

    private Expression getExpression(String path, Map<String, Set<String>> columnToValueMapping) throws IOException {
        List<String> indexFiles = this.getCarbonIndexFile(path);
        Schema schema = CarbonSchemaReader.readSchema(indexFiles.get(0)).asOriginOrder();
        Field[] fields = schema.getFields();
        ArrayList<Expression> listOfExpressions = new ArrayList<Expression>();
        for (Map.Entry<String, Set<String>> column : columnToValueMapping.entrySet()) {
            DataType dataType = this.getColumnDataType(fields, column.getKey());
            ArrayList<EqualToExpression> listOfOrExpressions = new ArrayList<EqualToExpression>();
            for (String value : column.getValue()) {
                listOfOrExpressions.add(new EqualToExpression((Expression)new ColumnExpression(column.getKey(), dataType), (Expression)new LiteralExpression((Object)value, dataType)));
            }
            Expression OrFilterExpression = null;
            if (listOfOrExpressions.size() > 0) {
                OrFilterExpression = (Expression)listOfOrExpressions.get(0);
            }
            for (int i = 1; i < listOfOrExpressions.size(); ++i) {
                OrFilterExpression = new OrExpression(OrFilterExpression, (Expression)listOfOrExpressions.get(i));
            }
            listOfExpressions.add(OrFilterExpression);
        }
        Expression filterExpression = null;
        if (listOfExpressions.size() > 0) {
            filterExpression = (Expression)listOfExpressions.get(0);
        }
        for (int i = 1; i < listOfExpressions.size(); ++i) {
            filterExpression = new AndExpression(filterExpression, (Expression)listOfExpressions.get(i));
        }
        return filterExpression;
    }

    private int getColumnIndex(Field[] fields, String column) {
        int index = -1;
        for (Field field : fields) {
            if (!field.getFieldName().equals(column)) continue;
            index = field.getSchemaOrdinal();
            break;
        }
        if (index == -1) {
            throw new RuntimeException("ColumnName doesn't exists");
        }
        return index;
    }

    private List<String> getCarbonIndexFile(String path) {
        List<String> indexFiles = null;
        try (Stream<Path> walk = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);){
            indexFiles = walk.map(x -> x.toString()).filter(f -> f.endsWith(".carbonindex")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (indexFiles == null || indexFiles.size() < 1) {
            throw new RuntimeException("Carbon index file does not exists.");
        }
        return indexFiles;
    }

    private DataType getColumnDataType(Field[] fields, String column) {
        DataType type = null;
        for (Field field : fields) {
            if (!field.getFieldName().equals(column)) continue;
            type = field.getDataType();
            break;
        }
        if (null == type) {
            throw new RuntimeException("ColumnName doesn't exists");
        }
        if (type.isComplexType()) {
            throw new RuntimeException("IUD operation not supported for Complex data types");
        }
        return type;
    }

    private boolean ifRowsDeleted() {
        for (Map.Entry<String, Map<String, Set<String>>> path : this.filterColumnToValueMappingForUpdate.entrySet()) {
            if (!this.filterColumnToValueMappingForDelete.containsKey(path.getKey())) {
                return false;
            }
            for (Map.Entry<String, Set<String>> column : this.filterColumnToValueMappingForDelete.get(path.getKey()).entrySet()) {
                if (!this.filterColumnToValueMappingForUpdate.get(path.getKey()).containsKey(column.getKey())) {
                    return false;
                }
                for (String value : this.filterColumnToValueMappingForUpdate.get(path.getKey()).get(column.getKey())) {
                    if (column.getValue().contains(value)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

