/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.hadoop.AbstractRecordReader;
import org.apache.carbondata.hadoop.CarbonRecordReader;
import org.apache.carbondata.hadoop.util.CarbonVectorizedRecordReader;
import org.apache.carbondata.sdk.file.CarbonReaderBuilder;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonReader<T> {
    private List<RecordReader<Void, T>> readers;
    private RecordReader<Void, T> currentReader;
    private int index;
    private boolean initialise;
    private Object[] batchRows;

    CarbonReader(List<RecordReader<Void, T>> readers) {
        if (readers == null) {
            return;
        }
        this.initialise = true;
        this.readers = readers;
        this.index = 0;
        this.currentReader = 0 == readers.size() ? null : readers.get(0);
    }

    public boolean hasNext() throws IOException, InterruptedException {
        if (0 == this.readers.size() || this.currentReader == null) {
            return false;
        }
        this.validateReader();
        if (this.currentReader.nextKeyValue()) {
            return true;
        }
        if (this.index == this.readers.size() - 1) {
            return false;
        }
        this.currentReader.close();
        this.readers.set(this.index, null);
        ++this.index;
        this.currentReader = this.readers.get(this.index);
        boolean hasNext = this.currentReader.nextKeyValue();
        return hasNext;
    }

    public T readNextRow() throws IOException, InterruptedException {
        this.validateReader();
        Object row = this.currentReader.getCurrentValue();
        if (row instanceof CarbonRow) {
            return (T)row;
        }
        return this.formatDateAndTimeStamp((Object[])row);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getFormattedData(CarbonDimension dimension, Object row, SimpleDateFormat dateFormat, SimpleDateFormat timeStampFormat) {
        ColumnSchema columnSchema = dimension.getColumnSchema();
        if (row == null || columnSchema == null) return row;
        DataType dataType = columnSchema.getDataType();
        if (dataType == DataTypes.DATE) {
            return dateFormat.format(new Date(86400000L * (long)((Integer)row).intValue()));
        }
        if (dataType == DataTypes.TIMESTAMP) {
            return timeStampFormat.format(new Date((Long)row / 1000L));
        }
        if (!dataType.isComplexType()) return row;
        List listOfChildDimensions = dimension.getListOfChildDimensions();
        Object[] childDimensionFormattedValues = new Object[((Object[])row).length];
        if (listOfChildDimensions == null || listOfChildDimensions.size() <= 0) return row;
        int i = 0;
        if (DataTypes.isArrayType((DataType)dataType)) {
            DataType childDataType = ((CarbonDimension)listOfChildDimensions.get(0)).getColumnSchema().getDataType();
            if (childDataType != DataTypes.DATE && childDataType != DataTypes.TIMESTAMP && !childDataType.isComplexType()) return row;
            for (Object val : (Object[])row) {
                childDimensionFormattedValues[i] = this.getFormattedData((CarbonDimension)listOfChildDimensions.get(0), val, dateFormat, timeStampFormat);
                ++i;
            }
            return childDimensionFormattedValues;
        } else if (DataTypes.isStructType((DataType)dataType)) {
            for (Object val : (Object[])row) {
                childDimensionFormattedValues[i] = this.getFormattedData((CarbonDimension)listOfChildDimensions.get(i), val, dateFormat, timeStampFormat);
                ++i;
            }
            return childDimensionFormattedValues;
        } else {
            CarbonDimension childDimension;
            ColumnSchema childSchema;
            DataType childDataType;
            if (!DataTypes.isMapType((DataType)dataType) || !DataTypes.isStructType((DataType)(childDataType = (childSchema = (childDimension = (CarbonDimension)listOfChildDimensions.get(0)).getColumnSchema()).getDataType()))) return childDimensionFormattedValues;
            List mapChilds = childDimension.getListOfChildDimensions();
            ColumnSchema arraySchema = childSchema.clone();
            arraySchema.setDataType((DataType)DataTypes.createArrayType((DataType)((CarbonDimension)mapChilds.get(i)).getColumnSchema().getDataType()));
            CarbonDimension arrayDimension = new CarbonDimension(arraySchema, childDimension.getOrdinal(), childDimension.getKeyOrdinal(), childDimension.getSchemaOrdinal());
            for (Object val : (Object[])row) {
                arrayDimension.initializeChildDimensionsList(1);
                arrayDimension.getListOfChildDimensions().add(mapChilds.get(i));
                childDimensionFormattedValues[i] = this.getFormattedData(arrayDimension, val, dateFormat, timeStampFormat);
                ++i;
            }
        }
        return childDimensionFormattedValues;
    }

    public T formatDateAndTimeStamp(Object[] row) {
        List dimensions = ((AbstractRecordReader)this.currentReader).getQueryModel().getProjectionDimensions();
        String carbonDateFormat = CarbonProperties.getInstance().getProperty("carbon.date.format");
        if (carbonDateFormat == null) {
            carbonDateFormat = "yyyy-MM-dd";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(carbonDateFormat);
        String carbonTimeStampFormat = CarbonProperties.getInstance().getProperty("carbon.timestamp.format");
        if (carbonTimeStampFormat == null) {
            carbonTimeStampFormat = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat timeStampFormat = new SimpleDateFormat(carbonTimeStampFormat);
        for (ProjectionDimension dimension : dimensions) {
            row[dimension.getOrdinal()] = this.getFormattedData(dimension.getDimension(), row[dimension.getOrdinal()], dateFormat, timeStampFormat);
        }
        return (T)row;
    }

    public Object[] readNextBatchRow() throws Exception {
        this.validateReader();
        if (this.currentReader instanceof CarbonRecordReader) {
            Object[] rows;
            List batchValue = ((CarbonRecordReader)this.currentReader).getBatchValue();
            if (batchValue == null) {
                return null;
            }
            for (Object row : rows = batchValue.toArray()) {
                row = this.formatDateAndTimeStamp((Object[])row);
            }
            return rows;
        }
        if (this.currentReader instanceof CarbonVectorizedRecordReader) {
            int batch = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.detail.batch.size", String.valueOf(100)));
            this.batchRows = new Object[batch];
            int sum = 0;
            for (int i = 0; i < batch; ++i) {
                this.batchRows[i] = this.formatDateAndTimeStamp((Object[])this.currentReader.getCurrentValue());
                ++sum;
                if (i == batch - 1 || this.hasNext()) continue;
                Object[] lessBatch = new Object[sum];
                for (int j = 0; j < sum; ++j) {
                    lessBatch[j] = this.batchRows[j];
                }
                return lessBatch;
            }
            return this.batchRows;
        }
        throw new Exception("Didn't support read next batch row by this reader.");
    }

    public static CarbonReaderBuilder builder(String tablePath, String tableName) {
        return new CarbonReaderBuilder(tablePath, tableName);
    }

    public static CarbonReaderBuilder builder(InputSplit inputSplit) {
        return new CarbonReaderBuilder(inputSplit);
    }

    public static CarbonReaderBuilder builder(String tablePath) {
        UUID uuid = UUID.randomUUID();
        String tableName = "UnknownTable" + uuid;
        return CarbonReader.builder(tablePath, tableName);
    }

    public static CarbonReaderBuilder builder() {
        UUID uuid = UUID.randomUUID();
        String tableName = "UnknownTable" + uuid;
        return new CarbonReaderBuilder(tableName);
    }

    public List<CarbonReader> split(int maxSplits) {
        this.validateReader();
        if (maxSplits < 1) {
            throw new RuntimeException(this.getClass().getSimpleName() + ".split: maxSplits must be positive");
        }
        ArrayList<CarbonReader> carbonReaders = new ArrayList<CarbonReader>();
        if (maxSplits < this.readers.size()) {
            float filesPerSplit = (float)this.readers.size() / (float)maxSplits;
            for (int i = 0; i < maxSplits; ++i) {
                carbonReaders.add(new CarbonReader<T>(this.readers.subList((int)Math.ceil((float)i * filesPerSplit), (int)Math.ceil((float)(i + 1) * filesPerSplit))));
            }
        } else {
            for (int i = 0; i < this.readers.size(); ++i) {
                carbonReaders.add(new CarbonReader<T>(this.readers.subList(i, i + 1)));
            }
        }
        this.initialise = false;
        return carbonReaders;
    }

    public void close() throws IOException {
        this.validateReader();
        CarbonProperties.getInstance().addProperty("carbon.detail.batch.size", String.valueOf(100));
        if (null != this.currentReader) {
            this.currentReader.close();
        }
        this.initialise = false;
    }

    private void validateReader() {
        if (!this.initialise) {
            throw new RuntimeException(this.getClass().getSimpleName() + " not initialise, please create it first.");
        }
    }
}

