/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.index.IndexStoreManager;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonSessionInfo;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.hadoop.api.CarbonFileInputFormat;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;
import org.apache.carbondata.hadoop.util.CarbonVectorizedRecordReader;
import org.apache.carbondata.processing.loading.iterator.CarbonOutputIteratorWrapper;
import org.apache.carbondata.sdk.file.ArrowCarbonReader;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.carbondata.sdk.file.PaginationCarbonReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonReaderBuilder {
    private String tablePath;
    private String[] projectionColumns;
    private Expression filterExpression;
    private String tableName;
    private Configuration hadoopConf;
    private boolean useVectorReader = true;
    private InputSplit inputSplit;
    private boolean useArrowReader;
    private boolean usePaginationReader;
    private List fileLists;
    private Class<? extends CarbonReadSupport> readSupportClass;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonOutputIteratorWrapper.class.getName());

    CarbonReaderBuilder(String tablePath, String tableName) {
        this.tablePath = tablePath;
        this.tableName = tableName;
        ThreadLocalSessionInfo.setCarbonSessionInfo((CarbonSessionInfo)new CarbonSessionInfo());
    }

    CarbonReaderBuilder(InputSplit inputSplit) {
        this.inputSplit = inputSplit;
        ThreadLocalSessionInfo.setCarbonSessionInfo((CarbonSessionInfo)new CarbonSessionInfo());
    }

    CarbonReaderBuilder(String tableName) {
        this.tableName = tableName;
        ThreadLocalSessionInfo.setCarbonSessionInfo((CarbonSessionInfo)new CarbonSessionInfo());
    }

    public CarbonReaderBuilder withFolder(String tablePath) {
        this.tablePath = tablePath;
        return this;
    }

    public CarbonReaderBuilder withFileLists(List fileLists) {
        if (null == this.fileLists) {
            this.fileLists = fileLists;
        } else {
            this.fileLists.addAll(fileLists);
        }
        return this;
    }

    public CarbonReaderBuilder withFile(String file) {
        ArrayList<String> fileLists = new ArrayList<String>();
        fileLists.add(file);
        return this.withFileLists(fileLists);
    }

    public CarbonReaderBuilder withReadSupport(Class<? extends CarbonReadSupport> readSupportClass) {
        this.readSupportClass = readSupportClass;
        return this;
    }

    public CarbonReaderBuilder projection(String[] projectionColumnNames) {
        Objects.requireNonNull(projectionColumnNames);
        this.projectionColumns = projectionColumnNames;
        return this;
    }

    public CarbonReaderBuilder projection(List<String> projectionColumnNames) {
        Objects.requireNonNull(projectionColumnNames);
        String[] strings = new String[projectionColumnNames.size()];
        for (int i = 0; i < projectionColumnNames.size(); ++i) {
            strings[i] = projectionColumnNames.get(i);
        }
        return this.projection(strings);
    }

    public CarbonReaderBuilder filter(Expression filterExpression) {
        Objects.requireNonNull(filterExpression);
        this.filterExpression = filterExpression;
        return this;
    }

    public CarbonReaderBuilder withHadoopConf(Configuration conf) {
        if (conf != null) {
            this.hadoopConf = conf;
        }
        return this;
    }

    public CarbonReaderBuilder withBatch(int batch) {
        CarbonProperties.getInstance().addProperty("carbon.detail.batch.size", String.valueOf(batch));
        return this;
    }

    public CarbonReaderBuilder withHadoopConf(String key, String value) {
        if (this.hadoopConf == null) {
            this.hadoopConf = new Configuration();
        }
        this.hadoopConf.set(key, value);
        return this;
    }

    public CarbonReaderBuilder withRowRecordReader() {
        this.useVectorReader = false;
        return this;
    }

    void setInputSplit(InputSplit inputSplit) {
        this.inputSplit = inputSplit;
    }

    public <T> ArrowCarbonReader<T> buildArrowReader() throws IOException, InterruptedException {
        this.useArrowReader = true;
        return (ArrowCarbonReader)this.build();
    }

    public CarbonReaderBuilder withPaginationSupport() {
        this.usePaginationReader = true;
        return this;
    }

    public <T> PaginationCarbonReader<T> buildPaginationReader() throws IOException, InterruptedException {
        this.usePaginationReader = true;
        return (PaginationCarbonReader)this.build();
    }

    private CarbonFileInputFormat prepareFileInputFormat(Job job, boolean enableBlockletDistribution, boolean disableLoadBlockIndex) throws IOException {
        CarbonTable table;
        if (this.inputSplit != null && this.inputSplit instanceof CarbonInputSplit) {
            this.tablePath = ((CarbonInputSplit)this.inputSplit).getSegment().getReadCommittedScope().getFilePath();
            this.tableName = "UnknownTable" + UUID.randomUUID();
        }
        if (null == this.fileLists && null == this.tablePath) {
            throw new IllegalArgumentException("Please set table path first.");
        }
        if (null != this.fileLists) {
            if (this.fileLists.size() < 1) {
                throw new IllegalArgumentException("fileLists must have one file in list as least!");
            }
            String commonString = String.valueOf(this.fileLists.get(0));
            for (int i = 1; i < this.fileLists.size(); ++i) {
                commonString = commonString.substring(0, StringUtils.indexOfDifference((CharSequence)commonString, (CharSequence)String.valueOf(this.fileLists.get(i))));
            }
            int index = commonString.lastIndexOf("/");
            commonString = commonString.substring(0, index);
            table = CarbonTable.buildTable((String)commonString, (String)this.tableName, (Configuration)this.hadoopConf);
        } else {
            table = CarbonTable.buildTable((String)this.tablePath, (String)this.tableName, (Configuration)this.hadoopConf);
        }
        if (enableBlockletDistribution) {
            Map tableProperties = table.getTableInfo().getFactTable().getTableProperties();
            tableProperties.put("cache_level", "BLOCKLET");
            table.getTableInfo().getFactTable().setTableProperties(tableProperties);
        }
        CarbonFileInputFormat format = new CarbonFileInputFormat();
        CarbonFileInputFormat.setTableInfo((Configuration)job.getConfiguration(), (TableInfo)table.getTableInfo());
        CarbonFileInputFormat.setTablePath((Configuration)job.getConfiguration(), (String)table.getTablePath());
        CarbonFileInputFormat.setTableName((Configuration)job.getConfiguration(), (String)table.getTableName());
        CarbonFileInputFormat.setDatabaseName((Configuration)job.getConfiguration(), (String)table.getDatabaseName());
        if (this.filterExpression != null) {
            CarbonFileInputFormat.setFilterPredicates((Configuration)job.getConfiguration(), (IndexFilter)new IndexFilter(table, this.filterExpression, true));
        }
        if (null != this.fileLists) {
            format.setFileLists(this.fileLists);
        }
        if (this.projectionColumns != null) {
            int len = this.projectionColumns.length;
            for (int i = 0; i < len; ++i) {
                if (!this.projectionColumns[i].contains(".")) continue;
                throw new UnsupportedOperationException("Complex child columns projection NOT supported through CarbonReader");
            }
            CarbonFileInputFormat.setColumnProjection((Configuration)job.getConfiguration(), (String[])this.projectionColumns);
        }
        if (disableLoadBlockIndex && this.filterExpression == null) {
            job.getConfiguration().set("filter_blocks", "false");
        }
        return format;
    }

    private <T> RecordReader getRecordReader(Job job, CarbonFileInputFormat format, List<RecordReader<Void, T>> readers, InputSplit split) throws IOException, InterruptedException {
        RecordReader reader;
        TaskAttemptContextImpl attempt = new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID());
        QueryModel queryModel = format.createQueryModel(split, (TaskAttemptContext)attempt);
        boolean hasComplex = false;
        for (ProjectionDimension projectionDimension : queryModel.getProjectionDimensions()) {
            if (!projectionDimension.getDimension().isComplex().booleanValue()) continue;
            hasComplex = true;
            break;
        }
        if (this.useVectorReader && !hasComplex) {
            queryModel.setDirectVectorFill(this.filterExpression == null);
            reader = new CarbonVectorizedRecordReader(queryModel);
        } else {
            reader = format.createRecordReader(split, (TaskAttemptContext)attempt);
        }
        try {
            reader.initialize(split, (TaskAttemptContext)attempt);
        }
        catch (Exception e) {
            CarbonUtil.closeStreams((Closeable[])((Closeable[])readers.toArray(new RecordReader[0])));
            throw e;
        }
        return reader;
    }

    public <T> CarbonReader<T> build() throws IOException, InterruptedException {
        if (this.inputSplit != null) {
            return this.buildWithSplits(this.inputSplit);
        }
        if (this.hadoopConf == null) {
            this.hadoopConf = FileFactory.getConfiguration();
        }
        CarbonTableInputFormat.setCarbonReadSupport((Configuration)this.hadoopConf, this.readSupportClass);
        Job job = new Job((Configuration)new JobConf(this.hadoopConf));
        CarbonFileInputFormat format = null;
        try {
            if (!this.usePaginationReader) {
                format = this.prepareFileInputFormat(job, false, true);
                List splits = format.getSplits((JobContext)new JobContextImpl(job.getConfiguration(), new JobID()));
                ArrayList readers = new ArrayList(splits.size());
                for (InputSplit split : splits) {
                    RecordReader reader = this.getRecordReader(job, format, readers, split);
                    readers.add(reader);
                }
                if (this.useArrowReader) {
                    return new ArrowCarbonReader(readers);
                }
                return new CarbonReader(readers);
            }
            format = this.prepareFileInputFormat(job, true, false);
            List splits = format.getSplits((JobContext)new JobContextImpl(job.getConfiguration(), new JobID()));
            ArrayList<Long> rowCountInSplit = new ArrayList<Long>(splits.size());
            this.totalRowCountInSplits(job, splits, rowCountInSplit);
            return new PaginationCarbonReader(splits, this, rowCountInSplit);
        }
        catch (Exception ex) {
            if (format != null) {
                IndexStoreManager.getInstance().clearIndexCache(format.getOrCreateCarbonTable(job.getConfiguration()).getAbsoluteTableIdentifier(), false);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void totalRowCountInSplits(Job job, List<InputSplit> splits, List<Long> rowCountInSplit) throws IOException, InterruptedException {
        CarbonFile emptyMetadataFile;
        CarbonFileInputFormat format = this.prepareFileInputFormat(job, false, true);
        long sum = 0L;
        boolean isIUDTable = false;
        if (!StringUtils.isEmpty((CharSequence)this.tablePath) && (emptyMetadataFile = FileFactory.getCarbonFile((String)(this.tablePath + "/" + "emptyMetadataFolder"), (Configuration)this.hadoopConf)).exists() && emptyMetadataFile.isDirectory()) {
            isIUDTable = true;
        }
        if (this.filterExpression != null || isIUDTable) {
            RecordReader reader = null;
            CarbonReader<T> carbonReader = null;
            for (InputSplit split : splits) {
                ArrayList<RecordReader<Void, T>> readers = new ArrayList<RecordReader<Void, T>>();
                try {
                    reader = this.getRecordReader(job, format, readers, split);
                    readers.add(reader);
                    carbonReader = new CarbonReader<T>(readers);
                    while (carbonReader.hasNext()) {
                        try {
                            sum += (long)carbonReader.readNextBatchRow().length;
                        }
                        catch (Exception ex) {
                            LOGGER.error((Object)("Exception occured while reading the batch row " + ex.getMessage()));
                        }
                    }
                    rowCountInSplit.add(sum);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (carbonReader == null) continue;
                    carbonReader.close();
                }
            }
        } else {
            for (InputSplit split : splits) {
                rowCountInSplit.add(sum += (long)((CarbonInputSplit)split).getDetailInfo().getRowCount());
            }
        }
    }

    private <T> CarbonReader<T> buildWithSplits(InputSplit inputSplit) throws IOException, InterruptedException {
        if (this.hadoopConf == null) {
            this.hadoopConf = FileFactory.getConfiguration();
        }
        CarbonTableInputFormat.setCarbonReadSupport((Configuration)this.hadoopConf, this.readSupportClass);
        Job job = new Job((Configuration)new JobConf(this.hadoopConf));
        CarbonFileInputFormat format = this.prepareFileInputFormat(job, false, true);
        format.setAllColumnProjectionIfNotConfigured((JobContext)job, format.getOrCreateCarbonTable(job.getConfiguration()));
        ArrayList<RecordReader<Void, T>> readers = new ArrayList<RecordReader<Void, T>>(1);
        RecordReader reader = this.getRecordReader(job, format, readers, inputSplit);
        readers.add(reader);
        if (this.useArrowReader) {
            return new ArrowCarbonReader<T>(readers);
        }
        return new CarbonReader<T>(readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSplit[] getSplits(boolean enableBlockletDistribution) throws IOException {
        List splits;
        if (this.hadoopConf == null) {
            this.hadoopConf = FileFactory.getConfiguration();
        }
        Job job = null;
        CarbonFileInputFormat format = null;
        try {
            job = new Job((Configuration)new JobConf(this.hadoopConf));
            format = this.prepareFileInputFormat(job, enableBlockletDistribution, false);
            splits = format.getSplits((JobContext)new JobContextImpl(job.getConfiguration(), new JobID()));
            for (InputSplit split : splits) {
                ((CarbonInputSplit)split).getDetailInfo();
            }
        }
        finally {
            if (format != null) {
                IndexStoreManager.getInstance().clearIndexCache(format.getOrCreateCarbonTable(job.getConfiguration()).getAbsoluteTableIdentifier(), false);
            }
        }
        return splits.toArray(new InputSplit[splits.size()]);
    }
}

