/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hadoop.internal.ObjectArrayWritable;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeInmemoryMergeHolder;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@InterfaceAudience.User
public class JsonCarbonWriter
extends CarbonWriter {
    private Configuration configuration;
    private RecordWriter<NullWritable, ObjectArrayWritable> recordWriter;
    private TaskAttemptContext context;
    private ObjectArrayWritable writable;
    private CarbonFile[] dataFiles;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)UnsafeInmemoryMergeHolder.class.getName());

    JsonCarbonWriter(CarbonLoadModel loadModel, Configuration configuration) throws IOException {
        CarbonTableOutputFormat.setLoadModel((Configuration)configuration, (CarbonLoadModel)loadModel);
        CarbonTableOutputFormat outputFormat = new CarbonTableOutputFormat();
        JobID jobId = new JobID(UUID.randomUUID().toString(), 0);
        Random random = new Random();
        TaskID task = new TaskID(jobId, TaskType.MAP, random.nextInt());
        TaskAttemptID attemptID = new TaskAttemptID(task, random.nextInt());
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(configuration, attemptID);
        this.recordWriter = outputFormat.getRecordWriter((TaskAttemptContext)context);
        this.context = context;
        this.writable = new ObjectArrayWritable();
        this.configuration = configuration;
    }

    @Override
    public void setDataFiles(CarbonFile[] dataFiles) throws IOException {
        if (dataFiles == null || dataFiles.length == 0) {
            throw new RuntimeException("data files can't be empty.");
        }
        Reader jsonReader = null;
        for (CarbonFile dataFile : dataFiles) {
            try {
                jsonReader = this.buildJsonReader(dataFile, this.configuration);
                new JSONParser().parse(jsonReader);
            }
            catch (FileNotFoundException ex) {
                throw new FileNotFoundException("File " + dataFile + " not found to build carbon writer.");
            }
            catch (ParseException ex) {
                throw new RuntimeException("File " + dataFile + " is not in json format.");
            }
            finally {
                if (jsonReader != null) {
                    jsonReader.close();
                }
            }
        }
        this.dataFiles = dataFiles;
    }

    private Reader buildJsonReader(CarbonFile file, Configuration conf) throws IOException {
        DataInputStream inputStream = FileFactory.getDataInputStream((String)file.getPath(), (int)-1, (Configuration)conf);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
        return reader;
    }

    @Override
    public void write(Object object) throws IOException {
        Objects.requireNonNull(object, "Input cannot be null");
        try {
            Object[] jsonString = new String[]{(String)object};
            this.writable.set(jsonString);
            this.recordWriter.write((Object)NullWritable.get(), (Object)this.writable);
        }
        catch (Exception e) {
            this.close();
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.recordWriter.close(this.context);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void loadSingleFile(CarbonFile file) throws IOException {
        try (Reader reader = null;){
            reader = this.buildJsonReader(file, this.configuration);
            JSONParser jsonParser = new JSONParser();
            Object jsonRecord = jsonParser.parse(reader);
            if (jsonRecord instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)jsonRecord;
                for (Object record : jsonArray) {
                    this.write(record.toString());
                }
            } else {
                this.write(jsonRecord.toString());
            }
        }
    }

    @Override
    public void write() throws IOException {
        if (this.dataFiles == null || this.dataFiles.length == 0) {
            throw new RuntimeException("'withJsonPath()' must be called to support load json files");
        }
        for (CarbonFile dataFile : this.dataFiles) {
            this.loadSingleFile(dataFile);
        }
    }
}

