/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.cache.Cacheable;
import org.apache.carbondata.core.cache.CarbonLRUCache;
import org.apache.carbondata.core.indexstore.BlockletDetailInfo;
import org.apache.carbondata.hadoop.CarbonInputSplit;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.carbondata.sdk.file.CarbonReaderBuilder;
import org.apache.carbondata.sdk.file.cache.BlockletRows;
import org.apache.hadoop.mapreduce.InputSplit;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class PaginationCarbonReader<T>
extends CarbonReader<T> {
    private List<InputSplit> allBlockletSplits;
    private List<Long> rowCountInSplits;
    private CarbonReaderBuilder readerBuilder;
    private boolean isClosed;
    private CarbonLRUCache cache = new CarbonLRUCache("carbon.max.pagination.lru.cache.size.in.mb", "-1");

    PaginationCarbonReader(List<InputSplit> splits, CarbonReaderBuilder readerBuilder, List<Long> rowsInSplits) {
        super(null);
        this.allBlockletSplits = splits;
        this.readerBuilder = readerBuilder;
        this.rowCountInSplits = rowsInSplits;
    }

    public Object[] read(long fromRowNumber, long toRowNumber) throws IOException, InterruptedException {
        if (this.isClosed) {
            throw new RuntimeException("Pagination Reader is closed. please build again");
        }
        if (fromRowNumber < 1L) {
            throw new IllegalArgumentException("from row id:" + fromRowNumber + " is less than 1");
        }
        if (fromRowNumber > toRowNumber) {
            throw new IllegalArgumentException("from row id:" + fromRowNumber + " is greater than to row id:" + toRowNumber);
        }
        if (toRowNumber > this.getTotalRows()) {
            throw new IllegalArgumentException("to row id:" + toRowNumber + " is greater than total rows:" + this.getTotalRows());
        }
        return this.getRows(fromRowNumber, toRowNumber);
    }

    public long getTotalRows() {
        if (this.isClosed) {
            throw new RuntimeException("Pagination Reader is closed. please build again");
        }
        if (this.rowCountInSplits.size() == 0) {
            return 0L;
        }
        return this.rowCountInSplits.get(this.rowCountInSplits.size() - 1);
    }

    public String getTotalRowsAsString() {
        if (this.isClosed) {
            throw new RuntimeException("Pagination Reader is closed. please build again");
        }
        return this.rowCountInSplits.get(this.rowCountInSplits.size() - 1).toString();
    }

    private static int findBlockletIndex(List<Long> summationArray, Long key) {
        int index = Collections.binarySearch(summationArray, key);
        if (index < 0) {
            index = Math.abs(index + 1);
        }
        return index;
    }

    private Range getBlockletIndexRange(long fromRowNumber, long toRowNumber) {
        int upperBound = PaginationCarbonReader.findBlockletIndex(this.rowCountInSplits, toRowNumber);
        int lowerBound = PaginationCarbonReader.findBlockletIndex(this.rowCountInSplits.subList(0, upperBound), fromRowNumber);
        return new Range(lowerBound, upperBound);
    }

    private Object[] getRows(long fromRowNumber, long toRowNumber) throws IOException, InterruptedException {
        int rowCount = 0;
        Object[] rows = new Object[(int)(toRowNumber - fromRowNumber + 1L)];
        Range blockletIndexRange = this.getBlockletIndexRange(fromRowNumber, toRowNumber);
        for (int i = blockletIndexRange.getFrom(); i <= blockletIndexRange.getTo(); ++i) {
            int end;
            int start;
            BlockletRows blockletRows;
            String blockletUniqueId = String.valueOf(i);
            if (this.cache.get(blockletUniqueId) != null) {
                blockletRows = (BlockletRows)this.cache.get(blockletUniqueId);
            } else {
                BlockletDetailInfo detailInfo = ((CarbonInputSplit)this.allBlockletSplits.get(i)).getDetailInfo();
                ArrayList rowsInBlocklet = new ArrayList();
                this.readerBuilder.setInputSplit(this.allBlockletSplits.get(i));
                CarbonReader carbonReader = this.readerBuilder.build();
                while (carbonReader.hasNext()) {
                    rowsInBlocklet.add(carbonReader.readNextRow());
                }
                carbonReader.close();
                long fromRowId = i == 0 ? 1L : this.rowCountInSplits.get(i - 1) + 1L;
                blockletRows = new BlockletRows(fromRowId, detailInfo.getBlockSize(), rowsInBlocklet.toArray());
                this.cache.put(String.valueOf(i), (Cacheable)blockletRows, blockletRows.getMemorySize(), Integer.MAX_VALUE);
            }
            long fromBlockletRow = blockletRows.getRowIdStartIndex();
            long toBlockletRow = fromBlockletRow + (long)blockletRows.getRowsCount();
            Object[] rowsInBlocklet = blockletRows.getRows();
            if (toRowNumber >= toBlockletRow) {
                if (fromRowNumber >= fromBlockletRow) {
                    start = (int)(fromRowNumber - blockletRows.getRowIdStartIndex());
                    end = blockletRows.getRowsCount();
                    while (start < end) {
                        rows[rowCount++] = rowsInBlocklet[start++];
                    }
                    continue;
                }
                System.arraycopy(rowsInBlocklet, 0, rows, rowCount, rowsInBlocklet.length);
                rowCount += rowsInBlocklet.length;
                continue;
            }
            if (fromRowNumber >= fromBlockletRow) {
                start = (int)(fromRowNumber - blockletRows.getRowIdStartIndex());
                end = (int)((long)start + (toRowNumber + 1L - fromRowNumber));
                while (start < end) {
                    rows[rowCount++] = rowsInBlocklet[start++];
                }
                continue;
            }
            start = 0;
            end = (int)(toRowNumber + 1L - blockletRows.getRowIdStartIndex());
            while (start < end) {
                rows[rowCount++] = rowsInBlocklet[start++];
            }
        }
        return rows;
    }

    @Override
    public boolean hasNext() throws IOException, InterruptedException {
        throw new UnsupportedOperationException("cannot support this operation with pagination");
    }

    @Override
    public T readNextRow() throws IOException, InterruptedException {
        throw new UnsupportedOperationException("cannot support this operation with pagination");
    }

    @Override
    public Object[] readNextBatchRow() throws Exception {
        throw new UnsupportedOperationException("cannot support this operation with pagination");
    }

    @Override
    public List<CarbonReader> split(int maxSplits) {
        throw new UnsupportedOperationException("cannot support this operation with pagination");
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            throw new RuntimeException("Pagination Reader is already closed");
        }
        this.cache.clear();
        this.rowCountInSplits = null;
        this.allBlockletSplits = null;
        this.isClosed = true;
    }

    private class Range {
        private int from;
        private int to;

        Range(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }
    }
}

