/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.sdk.file.AvroCarbonWriter;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;

public class ParquetCarbonWriter
extends CarbonWriter {
    private Configuration configuration;
    private CarbonFile[] dataFiles;
    private AvroCarbonWriter avroCarbonWriter;

    ParquetCarbonWriter(CarbonLoadModel loadModel, Configuration hadoopConf, Schema avroSchema) throws IOException {
        this.avroCarbonWriter = new AvroCarbonWriter(loadModel, hadoopConf, avroSchema);
        this.configuration = hadoopConf;
    }

    @Override
    public void setDataFiles(CarbonFile[] dataFiles) throws IOException {
        if (dataFiles == null || dataFiles.length == 0) {
            throw new RuntimeException("data files can't be empty.");
        }
        Schema parquetSchema = null;
        for (CarbonFile dataFile : dataFiles) {
            Schema currentFileSchema = ParquetCarbonWriter.extractParquetSchema(dataFile, this.configuration);
            if (parquetSchema == null) {
                parquetSchema = currentFileSchema;
                continue;
            }
            if (parquetSchema.equals((Object)currentFileSchema)) continue;
            throw new RuntimeException("All the parquet files must be having the same schema.");
        }
        this.dataFiles = dataFiles;
    }

    public static Schema extractParquetSchema(CarbonFile dataFile, Configuration configuration) throws IOException {
        ParquetReader<GenericRecord> parquetReader = ParquetCarbonWriter.buildParquetReader(dataFile.getPath(), configuration);
        Schema parquetSchema = ((GenericRecord)parquetReader.read()).getSchema();
        parquetReader.close();
        return parquetSchema;
    }

    private static ParquetReader<GenericRecord> buildParquetReader(String path, Configuration conf) throws IOException {
        try {
            AvroReadSupport avroReadSupport = new AvroReadSupport();
            return ParquetReader.builder((ReadSupport)avroReadSupport, (Path)new Path(path)).withConf(conf).build();
        }
        catch (FileNotFoundException ex) {
            throw new FileNotFoundException("File " + path + " not found to build carbon writer.");
        }
    }

    @Override
    public void write(Object object) {
        throw new UnsupportedOperationException("Carbon doesn't support writing a single Parquet object");
    }

    @Override
    public void close() throws IOException {
        this.avroCarbonWriter.close();
    }

    @Override
    public void write() throws IOException {
        if (this.dataFiles == null || this.dataFiles.length == 0) {
            throw new RuntimeException("'withParquetPath()' must be called to support loading parquet files");
        }
        for (CarbonFile dataFile : this.dataFiles) {
            this.loadSingleFile(dataFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSingleFile(CarbonFile file) throws IOException {
        try (ParquetReader<GenericRecord> parquetReader = null;){
            GenericRecord genericRecord;
            parquetReader = ParquetCarbonWriter.buildParquetReader(file.getPath(), this.configuration);
            while ((genericRecord = (GenericRecord)parquetReader.read()) != null) {
                this.avroCarbonWriter.write(genericRecord);
            }
        }
    }
}

