/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.CarbonWriterBuilder;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Developer(value={"Test"})
public class TestUtil {
    public static final Configuration configuration = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenericData.Record jsonToAvro(String json, String avroSchema) throws IOException {
        InputStream input = null;
        DataFileWriter writer = null;
        ByteArrayOutputStream output = null;
        try {
            org.apache.avro.Schema schema = new Schema.Parser().parse(avroSchema);
            GenericDatumReader reader = new GenericDatumReader(schema);
            input = new ByteArrayInputStream(json.getBytes("UTF-8"));
            output = new ByteArrayOutputStream();
            DataInputStream din = new DataInputStream(input);
            writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
            writer.create(schema, (OutputStream)output);
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)din);
            GenericData.Record record = (GenericData.Record)reader.read(null, (Decoder)decoder);
            return record;
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    static void writeFilesAndVerify(Schema schema, String path, String[] sortColumns) {
        TestUtil.writeFilesAndVerify(100, schema, path, sortColumns, -1, -1);
    }

    public static void writeFilesAndVerify(Schema schema, String path) {
        TestUtil.writeFilesAndVerify(100, schema, path, null, -1, -1);
    }

    public static void writeFilesAndVerify(int rows, Schema schema, String path) {
        TestUtil.writeFilesAndVerify(rows, schema, path, null, -1, -1);
    }

    public static void writeFilesAndVerify(int rows, Schema schema, String path, String[] sortColumns, int blockletSize, int blockSize) {
        try {
            CarbonWriterBuilder builder = CarbonWriter.builder().outputPath(path);
            if (sortColumns != null) {
                builder = builder.sortBy(sortColumns);
            }
            if (blockletSize != -1) {
                builder = builder.withBlockletSize(blockletSize);
            }
            if (blockSize != -1) {
                builder = builder.withBlockSize(blockSize);
            }
            CarbonWriter writer = builder.withCsvInput(schema).writtenBy("TestUtil").build();
            for (int i = 0; i < rows; ++i) {
                writer.write(new String[]{"robot" + i % 10, String.valueOf(i % 3000000), String.valueOf((double)i / 2.0)});
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        File[] dataFiles = new File(path).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".carbondata");
            }
        });
        if (dataFiles == null) {
            throw new RuntimeException("Test failed: dataFiles is null");
        }
        if (dataFiles.length == 0) {
            throw new RuntimeException("Test failed: dataFiles is empty");
        }
    }
}

