/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file.arrow;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.util.TimeZone;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.apache.carbondata.core.stream.ExtendedByteArrayOutputStream;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.carbondata.sdk.file.arrow.ArrowUtils;
import org.apache.carbondata.sdk.file.arrow.ArrowWriter;

public class ArrowConverter {
    private final BufferAllocator allocator;
    private VectorSchemaRoot root;
    private ArrowWriter arrowWriter;
    private org.apache.arrow.vector.types.pojo.Schema arrowSchema;
    private ExtendedByteArrayOutputStream out;
    private ArrowFileWriter writer;

    public ArrowConverter(Schema schema, int initialSize) {
        this.arrowSchema = ArrowUtils.toArrowSchema(schema, TimeZone.getDefault().getID());
        this.allocator = ArrowUtils.rootAllocator.newChildAllocator("toArrowBuffer", (long)initialSize, Long.MAX_VALUE);
        this.root = VectorSchemaRoot.create((org.apache.arrow.vector.types.pojo.Schema)this.arrowSchema, (BufferAllocator)this.allocator);
        this.arrowWriter = ArrowWriter.create(this.root);
        this.out = new ExtendedByteArrayOutputStream(0x2000000);
        this.writer = new ArrowFileWriter(this.root, null, Channels.newChannel((OutputStream)this.out));
    }

    public void addToArrowBuffer(Object[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.arrowWriter.write((Object[])data[i]);
        }
    }

    public byte[] toSerializeArray() throws IOException {
        this.arrowWriter.finish();
        this.writer.writeBatch();
        this.writer.close();
        this.arrowWriter.reset();
        this.root.close();
        byte[] bytes = this.out.toByteArray();
        this.allocator.close();
        this.out.close();
        return bytes;
    }

    public long copySerializeArrayToOffHeap() throws IOException {
        this.arrowWriter.finish();
        this.writer.writeBatch();
        this.writer.close();
        this.arrowWriter.reset();
        this.root.close();
        long address = this.out.copyToAddress();
        this.allocator.close();
        this.out.close();
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrowRecordBatch byteArrayToArrowBatch(byte[] batchBytes, BufferAllocator bufferAllocator) throws IOException {
        ByteArrayReadableSeekableByteChannel in = new ByteArrayReadableSeekableByteChannel(batchBytes);
        try (ArrowFileReader reader = new ArrowFileReader((SeekableByteChannel)in, bufferAllocator);){
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            VectorUnloader unloader = new VectorUnloader(root);
            reader.loadNextBatch();
            ArrowRecordBatch arrowRecordBatch = unloader.getRecordBatch();
            return arrowRecordBatch;
        }
    }

    public VectorSchemaRoot getArrowVectors() throws IOException {
        this.arrowWriter.finish();
        this.writer.writeBatch();
        this.writer.close();
        return this.root;
    }
}

