/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file.arrow;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.carbondata.core.metadata.datatype.ArrayType;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.DecimalType;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.datatype.StructType;
import org.apache.carbondata.sdk.file.Schema;

public class ArrowUtils {
    public static final RootAllocator rootAllocator = new RootAllocator(Long.MAX_VALUE);

    public static ArrowType toArrowType(DataType carbonDataType, String timeZoneId) {
        if (carbonDataType == DataTypes.STRING || carbonDataType == DataTypes.VARCHAR || carbonDataType == DataTypes.TIMESTAMP || carbonDataType == DataTypes.DATE) {
            return ArrowType.Utf8.INSTANCE;
        }
        if (carbonDataType == DataTypes.BYTE) {
            return new ArrowType.Int(DataTypes.BYTE.getSizeInBytes() * 8, true);
        }
        if (carbonDataType == DataTypes.SHORT) {
            return new ArrowType.Int(DataTypes.SHORT.getSizeInBytes() * 8, true);
        }
        if (carbonDataType == DataTypes.INT) {
            return new ArrowType.Int(DataTypes.INT.getSizeInBytes() * 8, true);
        }
        if (carbonDataType == DataTypes.LONG) {
            return new ArrowType.Int(DataTypes.LONG.getSizeInBytes() * 8, true);
        }
        if (carbonDataType == DataTypes.FLOAT) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        }
        if (carbonDataType == DataTypes.DOUBLE) {
            return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        }
        if (carbonDataType == DataTypes.BOOLEAN) {
            return ArrowType.Bool.INSTANCE;
        }
        if (carbonDataType instanceof DecimalType) {
            DecimalType decimal = (DecimalType)carbonDataType;
            return new ArrowType.Decimal(decimal.getPrecision(), decimal.getScale());
        }
        if (carbonDataType == DataTypes.BINARY) {
            return ArrowType.Binary.INSTANCE;
        }
        throw new UnsupportedOperationException("Operation not supported");
    }

    public static Field toArrowField(String name, DataType dataType, String timeZoneId) {
        if (dataType instanceof ArrayType) {
            FieldType fieldType = new FieldType(true, (ArrowType)ArrowType.List.INSTANCE, null);
            ArrayList<Field> structFields = new ArrayList<Field>();
            DataType elementType = ((ArrayType)dataType).getElementType();
            structFields.add(ArrowUtils.toArrowField("element", elementType, timeZoneId));
            return new Field(name, fieldType, structFields);
        }
        if (dataType instanceof StructType) {
            StructType dataType1 = (StructType)dataType;
            FieldType fieldType = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null);
            List fields = dataType1.getFields();
            ArrayList<Field> structFields = new ArrayList<Field>();
            for (int i = 0; i < fields.size(); ++i) {
                structFields.add(ArrowUtils.toArrowField(((StructField)fields.get(i)).getFieldName(), ((StructField)fields.get(i)).getDataType(), timeZoneId));
            }
            return new Field(name, fieldType, structFields);
        }
        FieldType fieldType = new FieldType(true, ArrowUtils.toArrowType(dataType, timeZoneId), null);
        return new Field(name, fieldType, new ArrayList());
    }

    public static org.apache.arrow.vector.types.pojo.Schema toArrowSchema(Schema carbonSchema, String timeZoneId) {
        org.apache.carbondata.core.metadata.datatype.Field[] fields = carbonSchema.getFields();
        LinkedHashSet<Field> arrowField = new LinkedHashSet<Field>();
        for (int i = 0; i < fields.length; ++i) {
            arrowField.add(ArrowUtils.toArrowField(fields[i].getFieldName(), fields[i].getDataType(), timeZoneId));
        }
        return new org.apache.arrow.vector.types.pojo.Schema(arrowField);
    }
}

