/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.index.IndexFilter;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.carbondata.store.CarbonRowReadSupport;
import org.apache.carbondata.store.MetaCachedCarbonStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
class LocalCarbonStore
extends MetaCachedCarbonStore {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)LocalCarbonStore.class.getName());

    LocalCarbonStore() {
    }

    @Override
    public Iterator<CarbonRow> scan(AbsoluteTableIdentifier tableIdentifier, String[] projectColumns) throws IOException {
        return this.scan(tableIdentifier, projectColumns, null);
    }

    @Override
    public Iterator<CarbonRow> scan(AbsoluteTableIdentifier tableIdentifier, String[] projectColumns, Expression filter) throws IOException {
        Objects.requireNonNull(tableIdentifier);
        Objects.requireNonNull(projectColumns);
        CarbonTable table = this.getTable(tableIdentifier.getTablePath());
        if (table.isStreamingSink() || table.isHivePartitionTable()) {
            throw new UnsupportedOperationException("streaming and partition table is not supported");
        }
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        Job job = new Job(new Configuration());
        CarbonInputFormat.setTableInfo((Configuration)job.getConfiguration(), (TableInfo)table.getTableInfo());
        CarbonInputFormat.setTablePath((Configuration)job.getConfiguration(), (String)table.getTablePath());
        CarbonInputFormat.setTableName((Configuration)job.getConfiguration(), (String)table.getTableName());
        CarbonInputFormat.setDatabaseName((Configuration)job.getConfiguration(), (String)table.getDatabaseName());
        CarbonInputFormat.setCarbonReadSupport((Configuration)job.getConfiguration(), CarbonRowReadSupport.class);
        CarbonInputFormat.setColumnProjection((Configuration)job.getConfiguration(), (CarbonProjection)new CarbonProjection(projectColumns));
        if (filter != null) {
            CarbonInputFormat.setFilterPredicates((Configuration)job.getConfiguration(), (IndexFilter)new IndexFilter(table, filter));
        }
        List splits = format.getSplits((JobContext)new JobContextImpl(job.getConfiguration(), new JobID()));
        ArrayList<RecordReader> readers = new ArrayList<RecordReader>(splits.size());
        ArrayList<CarbonRow> rows = new ArrayList<CarbonRow>();
        try {
            for (InputSplit split : splits) {
                TaskAttemptContextImpl attempt = new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID());
                RecordReader reader = format.createRecordReader(split, (TaskAttemptContext)attempt);
                reader.initialize(split, (TaskAttemptContext)attempt);
                readers.add(reader);
            }
            for (RecordReader reader : readers) {
                while (reader.nextKeyValue()) {
                    rows.add((CarbonRow)reader.getCurrentValue());
                }
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            for (RecordReader reader : readers) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return rows.iterator();
    }

    @Override
    public Iterator<CarbonRow> sql(String sqlString) {
        throw new UnsupportedOperationException();
    }
}

