/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.reader.CarbonHeaderReader;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.sdk.file.CarbonReaderBuilder;
import org.apache.hadoop.mapreduce.RecordReader;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonReader<T> {
    private List<RecordReader<Void, T>> readers;
    private RecordReader<Void, T> currentReader;
    private int index;

    CarbonReader(List<RecordReader<Void, T>> readers) {
        if (readers.size() == 0) {
            throw new IllegalArgumentException("no reader");
        }
        this.readers = readers;
        this.index = 0;
        this.currentReader = readers.get(0);
    }

    public boolean hasNext() throws IOException, InterruptedException {
        if (this.currentReader.nextKeyValue()) {
            return true;
        }
        if (this.index == this.readers.size() - 1) {
            return false;
        }
        ++this.index;
        this.currentReader = this.readers.get(this.index);
        return this.currentReader.nextKeyValue();
    }

    public T readNextRow() throws IOException, InterruptedException {
        return (T)this.currentReader.getCurrentValue();
    }

    public static CarbonReaderBuilder builder(String tablePath, String tableName) {
        return new CarbonReaderBuilder(tablePath, tableName);
    }

    public static List<ColumnSchema> readSchemaInDataFile(String dataFilePath) throws IOException {
        CarbonHeaderReader reader = new CarbonHeaderReader(dataFilePath);
        return reader.readSchema();
    }

    public static org.apache.carbondata.core.metadata.schema.table.TableInfo readSchemaFile(String schemaFilePath) throws IOException {
        TableInfo tableInfo = CarbonUtil.readSchemaFile((String)schemaFilePath);
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        return schemaConverter.fromExternalToWrapperTableInfo(tableInfo, "", "", "");
    }

    public void close() throws IOException {
        this.currentReader.close();
    }
}

