/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.common.exceptions.sql.InvalidLoadOptionException;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.metadata.datatype.ArrayType;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.datatype.StructType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.TableSchemaBuilder;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.ThriftWriter;
import org.apache.carbondata.format.SchemaEvolutionEntry;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.model.CarbonLoadModelBuilder;
import org.apache.carbondata.sdk.file.AvroCarbonWriter;
import org.apache.carbondata.sdk.file.CSVCarbonWriter;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.Field;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.thrift.TBase;

@InterfaceAudience.User
@InterfaceStability.Unstable
public class CarbonWriterBuilder {
    private Schema schema;
    private String path;
    private String[] sortColumns;
    private boolean persistSchemaFile;
    private int blockletSize;
    private int blockSize;
    private boolean isTransactionalTable;
    private long UUID;
    private Map<String, String> options;
    private String taskNo;

    public CarbonWriterBuilder outputPath(String path) {
        Objects.requireNonNull(path, "path should not be null");
        this.path = path;
        return this;
    }

    public CarbonWriterBuilder sortBy(String[] sortColumns) {
        this.sortColumns = sortColumns;
        return this;
    }

    public CarbonWriterBuilder taskNo(long taskNo) {
        this.taskNo = String.valueOf(taskNo);
        return this;
    }

    public CarbonWriterBuilder persistSchemaFile(boolean persist) {
        this.persistSchemaFile = persist;
        return this;
    }

    public CarbonWriterBuilder isTransactionalTable(boolean isTransactionalTable) {
        Objects.requireNonNull(Boolean.valueOf(isTransactionalTable), "Transactional Table should not be null");
        this.isTransactionalTable = isTransactionalTable;
        return this;
    }

    public CarbonWriterBuilder setAccessKey(String key, String value) {
        FileFactory.getConfiguration().set(key, value);
        return this;
    }

    public CarbonWriterBuilder setAccessKey(String value) {
        return this.setAccessKey("fs.s3a.access.key", value);
    }

    public CarbonWriterBuilder setSecretKey(String key, String value) {
        FileFactory.getConfiguration().set(key, value);
        return this;
    }

    public CarbonWriterBuilder setSecretKey(String value) {
        return this.setSecretKey("fs.s3a.secret.key", value);
    }

    public CarbonWriterBuilder setEndPoint(String key, String value) {
        FileFactory.getConfiguration().set(key, value);
        return this;
    }

    public CarbonWriterBuilder setEndPoint(String value) {
        FileFactory.getConfiguration().set("fs.s3a.endpoint", value);
        return this;
    }

    public CarbonWriterBuilder uniqueIdentifier(long UUID2) {
        Objects.requireNonNull(Long.valueOf(UUID2), "Unique Identifier should not be null");
        this.UUID = UUID2;
        return this;
    }

    public CarbonWriterBuilder withLoadOptions(Map<String, String> options) {
        Objects.requireNonNull(options, "Load options should not be null");
        if (options.size() > 9) {
            throw new IllegalArgumentException("Supports only nine options now. Refer method header or documentation");
        }
        for (String option : options.keySet()) {
            if (option.equalsIgnoreCase("bad_records_logger_enable") || option.equalsIgnoreCase("bad_records_action") || option.equalsIgnoreCase("bad_record_path") || option.equalsIgnoreCase("dateformat") || option.equalsIgnoreCase("timestampformat") || option.equalsIgnoreCase("complex_delimiter_level_1") || option.equalsIgnoreCase("complex_delimiter_level_2") || option.equalsIgnoreCase("quotechar") || option.equalsIgnoreCase("escapechar")) continue;
            throw new IllegalArgumentException("Unsupported options. Refer method header or documentation");
        }
        TreeMap<String, String> optionsTreeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        optionsTreeMap.putAll(options);
        this.options = optionsTreeMap;
        return this;
    }

    public CarbonWriterBuilder withBlockSize(int blockSize) {
        if (blockSize <= 0 || blockSize > 2048) {
            throw new IllegalArgumentException("blockSize should be between 1 MB to 2048 MB");
        }
        this.blockSize = blockSize;
        return this;
    }

    public CarbonWriterBuilder withBlockletSize(int blockletSize) {
        if (blockletSize <= 0) {
            throw new IllegalArgumentException("blockletSize should be greater than zero");
        }
        this.blockletSize = blockletSize;
        return this;
    }

    public CarbonWriter buildWriterForCSVInput(Schema schema) throws IOException, InvalidLoadOptionException {
        Objects.requireNonNull(schema, "schema should not be null");
        Objects.requireNonNull(this.path, "path should not be null");
        this.schema = schema;
        CarbonLoadModel loadModel = this.createLoadModel();
        return new CSVCarbonWriter(loadModel);
    }

    public CarbonWriter buildWriterForAvroInput(org.apache.avro.Schema avroSchema) throws IOException, InvalidLoadOptionException {
        this.schema = AvroCarbonWriter.getCarbonSchemaFromAvroSchema(avroSchema);
        Objects.requireNonNull(this.schema, "schema should not be null");
        Objects.requireNonNull(this.path, "path should not be null");
        CarbonLoadModel loadModel = this.createLoadModel();
        loadModel.setLoadWithoutConverterStep(true);
        return new AvroCarbonWriter(loadModel);
    }

    private void setCsvHeader(CarbonLoadModel model) {
        Field[] fields = this.schema.getFields();
        StringBuilder builder = new StringBuilder();
        String[] columns = new String[fields.length];
        int i = 0;
        for (Field field : fields) {
            if (null == field) continue;
            builder.append(field.getFieldName());
            builder.append(",");
            columns[i++] = field.getFieldName();
        }
        String header = builder.toString();
        model.setCsvHeader(header.substring(0, header.length() - 1));
        model.setCsvHeaderColumns(columns);
    }

    private CarbonLoadModel createLoadModel() throws IOException, InvalidLoadOptionException {
        CarbonTable table = this.buildCarbonTable();
        if (this.persistSchemaFile) {
            this.persistSchemaFile(table, CarbonTablePath.getSchemaFilePath((String)this.path));
        }
        return this.buildLoadModel(table, this.UUID, this.taskNo, this.options);
    }

    private CarbonTable buildCarbonTable() {
        String dbName;
        String tableName;
        TableSchemaBuilder tableSchemaBuilder = TableSchema.builder();
        if (this.blockSize > 0) {
            tableSchemaBuilder = tableSchemaBuilder.blockSize(this.blockSize);
        }
        if (this.blockletSize > 0) {
            tableSchemaBuilder = tableSchemaBuilder.blockletSize(this.blockletSize);
        }
        List<Object> sortColumnsList = new ArrayList();
        if (this.sortColumns == null || this.sortColumns.length == 0) {
            for (Field field : this.schema.getFields()) {
                if (null == field || field.getDataType() != DataTypes.STRING && field.getDataType() != DataTypes.DATE && field.getDataType() != DataTypes.TIMESTAMP) continue;
                sortColumnsList.add(field.getFieldName());
            }
            this.sortColumns = new String[sortColumnsList.size()];
            this.sortColumns = sortColumnsList.toArray(this.sortColumns);
        } else {
            sortColumnsList = Arrays.asList(this.sortColumns);
        }
        ColumnSchema[] sortColumnsSchemaList = new ColumnSchema[sortColumnsList.size()];
        Field[] fields = this.schema.getFields();
        this.buildTableSchema(fields, tableSchemaBuilder, sortColumnsList, sortColumnsSchemaList);
        tableSchemaBuilder.setSortColumns(Arrays.asList(sortColumnsSchemaList));
        if (this.isTransactionalTable) {
            tableName = "_tempTable";
            dbName = "_tempDB";
        } else {
            dbName = "";
            tableName = "_tempTable_" + String.valueOf(this.UUID);
        }
        TableSchema schema = tableSchemaBuilder.build();
        schema.setTableName(tableName);
        CarbonTable table = CarbonTable.builder().tableName(schema.getTableName()).databaseName(dbName).tablePath(this.path).tableSchema(schema).isTransactionalTable(this.isTransactionalTable).build();
        return table;
    }

    private void buildTableSchema(Field[] fields, TableSchemaBuilder tableSchemaBuilder, List<String> sortColumnsList, ColumnSchema[] sortColumnsSchemaList) {
        AtomicInteger valIndex = new AtomicInteger(0);
        for (String sortColumn : sortColumnsList) {
            boolean exists = false;
            for (Field field : fields) {
                if (!field.getFieldName().equalsIgnoreCase(sortColumn)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            throw new RuntimeException("column: " + sortColumn + " specified in sort columns does not exist in schema");
        }
        int i = 0;
        for (Field field : fields) {
            if (null == field) continue;
            int isSortColumn = sortColumnsList.indexOf(field.getFieldName());
            if (isSortColumn > -1 && (field.getDataType() == DataTypes.DOUBLE || field.getDataType() == DataTypes.FLOAT || DataTypes.isDecimal((DataType)field.getDataType()) || field.getDataType().isComplexType())) {
                throw new RuntimeException(" sort columns not supported for array, struct, double, float, decimal ");
            }
            if (field.getChildren() != null && field.getChildren().size() > 0) {
                if (field.getDataType().getName().equalsIgnoreCase("ARRAY")) {
                    ArrayType complexType = DataTypes.createArrayType((DataType)field.getChildren().get(0).getDataType());
                    tableSchemaBuilder.addColumn(new StructField(field.getFieldName(), (DataType)complexType), valIndex, false);
                    continue;
                }
                if (!field.getDataType().getName().equalsIgnoreCase("STRUCT")) continue;
                ArrayList<StructField> structFieldsArray = new ArrayList<StructField>(field.getChildren().size());
                for (StructField childFld : field.getChildren()) {
                    structFieldsArray.add(new StructField(childFld.getFieldName(), childFld.getDataType()));
                }
                StructType complexType = DataTypes.createStructType(structFieldsArray);
                tableSchemaBuilder.addColumn(new StructField(field.getFieldName(), (DataType)complexType), valIndex, false);
                continue;
            }
            ColumnSchema columnSchema = tableSchemaBuilder.addColumn(new StructField(field.getFieldName(), field.getDataType()), valIndex, isSortColumn > -1);
            if (isSortColumn > -1) {
                columnSchema.setSortColumn(true);
                sortColumnsSchemaList[isSortColumn] = columnSchema;
                continue;
            }
            if (!sortColumnsList.isEmpty() || !columnSchema.isDimensionColumn() || columnSchema.getNumberOfChild() >= 1) continue;
            columnSchema.setSortColumn(true);
            sortColumnsSchemaList[i] = columnSchema;
            ++i;
        }
    }

    private void persistSchemaFile(CarbonTable table, String persistFilePath) throws IOException {
        org.apache.carbondata.core.metadata.schema.table.TableInfo tableInfo = table.getTableInfo();
        String schemaMetadataPath = CarbonTablePath.getFolderContainingFile((String)persistFilePath);
        CarbonMetadata.getInstance().loadTableMetadata(tableInfo);
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        TableInfo thriftTableInfo = schemaConverter.fromWrapperToExternalTableInfo(tableInfo, tableInfo.getDatabaseName(), tableInfo.getFactTable().getTableName());
        SchemaEvolutionEntry schemaEvolutionEntry = new SchemaEvolutionEntry(tableInfo.getLastUpdatedTime());
        thriftTableInfo.getFact_table().getSchema_evolution().getSchema_evolution_history().add(schemaEvolutionEntry);
        FileFactory.FileType fileType = FileFactory.getFileType((String)schemaMetadataPath);
        if (!FileFactory.isFileExist((String)schemaMetadataPath, (FileFactory.FileType)fileType)) {
            FileFactory.mkdirs((String)schemaMetadataPath, (FileFactory.FileType)fileType);
        }
        ThriftWriter thriftWriter = new ThriftWriter(persistFilePath, false);
        thriftWriter.open();
        thriftWriter.write((TBase)thriftTableInfo);
        thriftWriter.close();
    }

    private CarbonLoadModel buildLoadModel(CarbonTable table, long UUID2, String taskNo, Map<String, String> options) throws InvalidLoadOptionException, IOException {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        CarbonLoadModelBuilder builder = new CarbonLoadModelBuilder(table);
        CarbonLoadModel build = builder.build(options, UUID2, taskNo);
        this.setCsvHeader(build);
        return build;
    }
}

