/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.store;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.carbondata.store.CarbonStore;

@InterfaceAudience.Internal
abstract class MetaCachedCarbonStore
implements CarbonStore {
    private Map<String, CarbonTable> cache = new HashMap<String, CarbonTable>();

    MetaCachedCarbonStore() {
    }

    CarbonTable getTable(String path) throws IOException {
        if (this.cache.containsKey(path)) {
            return this.cache.get(path);
        }
        TableInfo schema = CarbonReader.readSchemaFile(CarbonTablePath.getSchemaFilePath((String)path));
        schema.setTablePath(path);
        CarbonTable table = CarbonTable.buildFromTableInfo((TableInfo)schema);
        this.cache.put(path, table);
        return table;
    }

    @Override
    public void close() throws IOException {
        this.cache.clear();
    }
}

