/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hadoop.internal.ObjectArrayWritable;
import org.apache.carbondata.processing.loading.complexobjects.ArrayObject;
import org.apache.carbondata.processing.loading.complexobjects.StructObject;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.Field;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

@InterfaceAudience.Internal
public class AvroCarbonWriter
extends CarbonWriter {
    private RecordWriter<NullWritable, ObjectArrayWritable> recordWriter;
    private TaskAttemptContext context;
    private ObjectArrayWritable writable;
    private org.apache.avro.Schema avroSchema;
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonTable.class.getName());

    AvroCarbonWriter(CarbonLoadModel loadModel) throws IOException {
        Configuration hadoopConf = new Configuration();
        CarbonTableOutputFormat.setLoadModel((Configuration)hadoopConf, (CarbonLoadModel)loadModel);
        CarbonTableOutputFormat format = new CarbonTableOutputFormat();
        JobID jobId = new JobID(UUID.randomUUID().toString(), 0);
        Random random = new Random();
        TaskID task = new TaskID(jobId, TaskType.MAP, random.nextInt());
        TaskAttemptID attemptID = new TaskAttemptID(task, random.nextInt());
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(hadoopConf, attemptID);
        this.recordWriter = format.getRecordWriter((TaskAttemptContext)context);
        this.context = context;
        this.writable = new ObjectArrayWritable();
    }

    private Object[] avroToCsv(GenericData.Record avroRecord) {
        if (this.avroSchema == null) {
            this.avroSchema = avroRecord.getSchema();
        }
        List fields = this.avroSchema.getFields();
        ArrayList<Object> csvFields = new ArrayList<Object>();
        for (int i = 0; i < fields.size(); ++i) {
            Object field = this.avroFieldToObject((Schema.Field)fields.get(i), avroRecord.get(i));
            if (field == null) continue;
            csvFields.add(field);
        }
        return csvFields.toArray();
    }

    private Object avroFieldToObject(Schema.Field avroField, Object fieldValue) {
        Object out;
        Schema.Type type = avroField.schema().getType();
        LogicalType logicalType = avroField.schema().getLogicalType();
        switch (type) {
            case INT: {
                if (logicalType != null) {
                    if (logicalType instanceof LogicalTypes.Date) {
                        int dateIntValue = (Integer)fieldValue;
                        out = (long)dateIntValue * 86400000L;
                        break;
                    }
                    LOGGER.warn("Actual type: INT, Logical Type: " + logicalType.getName());
                    out = fieldValue;
                    break;
                }
                out = fieldValue;
                break;
            }
            case BOOLEAN: 
            case LONG: {
                if (logicalType != null && !(logicalType instanceof LogicalTypes.TimestampMillis)) {
                    if (logicalType instanceof LogicalTypes.TimestampMicros) {
                        long dateIntValue = (Long)fieldValue;
                        out = dateIntValue / 1000L;
                        break;
                    }
                    LOGGER.warn("Actual type: INT, Logical Type: " + logicalType.getName());
                    out = fieldValue;
                    break;
                }
                out = fieldValue;
                break;
            }
            case DOUBLE: 
            case STRING: {
                out = fieldValue;
                break;
            }
            case FLOAT: {
                out = Double.parseDouble(fieldValue.toString());
                break;
            }
            case RECORD: {
                List fields = avroField.schema().getFields();
                Object[] structChildObjects = new Object[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    Object childObject = this.avroFieldToObject((Schema.Field)fields.get(i), ((GenericData.Record)fieldValue).get(i));
                    if (childObject == null) continue;
                    structChildObjects[i] = childObject;
                }
                StructObject structObject = new StructObject(structChildObjects);
                out = structObject;
                break;
            }
            case ARRAY: {
                Object[] arrayChildObjects;
                if (fieldValue instanceof GenericData.Array) {
                    int size = ((GenericData.Array)fieldValue).size();
                    arrayChildObjects = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        Object childObject = this.avroFieldToObject(new Schema.Field(avroField.name(), avroField.schema().getElementType(), avroField.doc(), avroField.defaultVal()), ((GenericData.Array)fieldValue).get(i));
                        if (childObject == null) continue;
                        arrayChildObjects[i] = childObject;
                    }
                } else {
                    int size = ((ArrayList)fieldValue).size();
                    arrayChildObjects = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        Object childObject = this.avroFieldToObject(new Schema.Field(avroField.name(), avroField.schema().getElementType(), avroField.doc(), avroField.defaultVal()), ((ArrayList)fieldValue).get(i));
                        if (childObject == null) continue;
                        arrayChildObjects[i] = childObject;
                    }
                }
                out = new ArrayObject(arrayChildObjects);
                break;
            }
            case NULL: {
                out = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("carbon not support " + type.toString() + " avro type yet");
            }
        }
        return out;
    }

    public static Schema getCarbonSchemaFromAvroSchema(org.apache.avro.Schema avroSchema) {
        Field[] carbonField = new Field[avroSchema.getFields().size()];
        int i = 0;
        for (Schema.Field avroField : avroSchema.getFields()) {
            Field field = AvroCarbonWriter.prepareFields(avroField);
            if (field != null) {
                carbonField[i] = field;
            }
            ++i;
        }
        return new Schema(carbonField);
    }

    private static Field prepareFields(Schema.Field avroField) {
        String FieldName = avroField.name();
        org.apache.avro.Schema childSchema = avroField.schema();
        Schema.Type type = childSchema.getType();
        LogicalType logicalType = childSchema.getLogicalType();
        switch (type) {
            case BOOLEAN: {
                return new Field(FieldName, DataTypes.BOOLEAN);
            }
            case INT: {
                if (logicalType instanceof LogicalTypes.Date) {
                    return new Field(FieldName, DataTypes.DATE);
                }
                LOGGER.warn("Unsupported logical type. Considering Data Type as INT for " + childSchema.getName());
                return new Field(FieldName, DataTypes.INT);
            }
            case LONG: {
                if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros) {
                    return new Field(FieldName, DataTypes.TIMESTAMP);
                }
                LOGGER.warn("Unsupported logical type. Considering Data Type as LONG for " + childSchema.getName());
                return new Field(FieldName, DataTypes.LONG);
            }
            case DOUBLE: {
                return new Field(FieldName, DataTypes.DOUBLE);
            }
            case STRING: {
                return new Field(FieldName, DataTypes.STRING);
            }
            case FLOAT: {
                return new Field(FieldName, DataTypes.DOUBLE);
            }
            case RECORD: {
                ArrayList<StructField> structSubFields = new ArrayList<StructField>();
                for (Schema.Field avroSubField : childSchema.getFields()) {
                    StructField structField = AvroCarbonWriter.prepareSubFields(avroSubField.name(), avroSubField.schema());
                    if (structField == null) continue;
                    structSubFields.add(structField);
                }
                return new Field(FieldName, "struct", structSubFields);
            }
            case ARRAY: {
                ArrayList<StructField> arraySubField = new ArrayList<StructField>();
                StructField structField = AvroCarbonWriter.prepareSubFields("val", childSchema.getElementType());
                if (structField != null) {
                    arraySubField.add(structField);
                    return new Field(FieldName, "array", arraySubField);
                }
                return null;
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("carbon not support " + type.toString() + " avro type yet");
    }

    private static StructField prepareSubFields(String FieldName, org.apache.avro.Schema childSchema) {
        Schema.Type type = childSchema.getType();
        LogicalType logicalType = childSchema.getLogicalType();
        switch (type) {
            case BOOLEAN: {
                return new StructField(FieldName, DataTypes.BOOLEAN);
            }
            case INT: {
                if (logicalType instanceof LogicalTypes.Date) {
                    return new StructField(FieldName, DataTypes.DATE);
                }
                LOGGER.warn("Unsupported logical type. Considering Data Type as INT for " + childSchema.getName());
                return new StructField(FieldName, DataTypes.INT);
            }
            case LONG: {
                if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros) {
                    return new StructField(FieldName, DataTypes.TIMESTAMP);
                }
                LOGGER.warn("Unsupported logical type. Considering Data Type as LONG for " + childSchema.getName());
                return new StructField(FieldName, DataTypes.LONG);
            }
            case DOUBLE: {
                return new StructField(FieldName, DataTypes.DOUBLE);
            }
            case STRING: {
                return new StructField(FieldName, DataTypes.STRING);
            }
            case FLOAT: {
                return new StructField(FieldName, DataTypes.DOUBLE);
            }
            case RECORD: {
                ArrayList<StructField> structSubFields = new ArrayList<StructField>();
                for (Schema.Field avroSubField : childSchema.getFields()) {
                    StructField structField = AvroCarbonWriter.prepareSubFields(avroSubField.name(), avroSubField.schema());
                    if (structField == null) continue;
                    structSubFields.add(structField);
                }
                return new StructField(FieldName, (DataType)DataTypes.createStructType(structSubFields));
            }
            case ARRAY: {
                DataType subType = AvroCarbonWriter.getMappingDataTypeForArrayRecord(childSchema.getElementType());
                if (subType != null) {
                    return new StructField(FieldName, (DataType)DataTypes.createArrayType((DataType)subType));
                }
                return null;
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("carbon not support " + type.toString() + " avro type yet");
    }

    private static DataType getMappingDataTypeForArrayRecord(org.apache.avro.Schema childSchema) {
        LogicalType logicalType = childSchema.getLogicalType();
        switch (childSchema.getType()) {
            case BOOLEAN: {
                return DataTypes.BOOLEAN;
            }
            case INT: {
                if (logicalType != null) {
                    if (logicalType instanceof LogicalTypes.Date) {
                        return DataTypes.DATE;
                    }
                    LOGGER.warn("Unsupported logical type. Considering Data Type as INT for " + childSchema.getName());
                    return DataTypes.INT;
                }
                return DataTypes.INT;
            }
            case LONG: {
                if (logicalType != null) {
                    if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros) {
                        return DataTypes.TIMESTAMP;
                    }
                    LOGGER.warn("Unsupported logical type. Considering Data Type as LONG for " + childSchema.getName());
                    return DataTypes.LONG;
                }
                return DataTypes.LONG;
            }
            case DOUBLE: {
                return DataTypes.DOUBLE;
            }
            case STRING: {
                return DataTypes.STRING;
            }
            case FLOAT: {
                return DataTypes.DOUBLE;
            }
            case RECORD: {
                ArrayList<StructField> structSubFields = new ArrayList<StructField>();
                for (Schema.Field avroSubField : childSchema.getFields()) {
                    StructField structField = AvroCarbonWriter.prepareSubFields(avroSubField.name(), avroSubField.schema());
                    if (structField == null) continue;
                    structSubFields.add(structField);
                }
                return DataTypes.createStructType(structSubFields);
            }
            case ARRAY: {
                DataType subType = AvroCarbonWriter.getMappingDataTypeForArrayRecord(childSchema.getElementType());
                if (subType != null) {
                    return DataTypes.createArrayType((DataType)subType);
                }
                return null;
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("carbon not support " + childSchema.getType().toString() + " avro type yet");
    }

    @Override
    public void write(Object object) throws IOException {
        try {
            GenericData.Record record = (GenericData.Record)object;
            Object[] csvRecord = this.avroToCsv(record);
            this.writable.set(csvRecord);
            this.recordWriter.write((Object)NullWritable.get(), (Object)this.writable);
        }
        catch (Exception e) {
            this.close();
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.recordWriter.close(this.context);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

