/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hadoop.internal.ObjectArrayWritable;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

@InterfaceAudience.Internal
class CSVCarbonWriter
extends CarbonWriter {
    private RecordWriter<NullWritable, ObjectArrayWritable> recordWriter;
    private TaskAttemptContext context;
    private ObjectArrayWritable writable;

    CSVCarbonWriter(CarbonLoadModel loadModel) throws IOException {
        Configuration hadoopConf = new Configuration();
        CarbonTableOutputFormat.setLoadModel((Configuration)hadoopConf, (CarbonLoadModel)loadModel);
        CarbonTableOutputFormat format = new CarbonTableOutputFormat();
        JobID jobId = new JobID(UUID.randomUUID().toString(), 0);
        Random random = new Random();
        TaskID task = new TaskID(jobId, TaskType.MAP, random.nextInt());
        TaskAttemptID attemptID = new TaskAttemptID(task, random.nextInt());
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(hadoopConf, attemptID);
        this.recordWriter = format.getRecordWriter((TaskAttemptContext)context);
        this.context = context;
        this.writable = new ObjectArrayWritable();
    }

    @Override
    public void write(Object object) throws IOException {
        try {
            this.writable.set((Object[])((String[])object));
            this.recordWriter.write((Object)NullWritable.get(), (Object)this.writable);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.recordWriter.close(this.context);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

