/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.hadoop.api.CarbonFileInputFormat;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonReaderBuilder {
    private String tablePath;
    private String[] projectionColumns;
    private Expression filterExpression;
    private String tableName;
    private boolean isTransactionalTable;

    CarbonReaderBuilder(String tablePath, String tableName) {
        this.tablePath = tablePath;
        this.tableName = tableName;
    }

    public CarbonReaderBuilder projection(String[] projectionColumnNames) {
        Objects.requireNonNull(projectionColumnNames);
        this.projectionColumns = projectionColumnNames;
        return this;
    }

    public CarbonReaderBuilder isTransactionalTable(boolean isTransactionalTable) {
        Objects.requireNonNull(isTransactionalTable);
        this.isTransactionalTable = isTransactionalTable;
        return this;
    }

    public CarbonReaderBuilder filter(Expression filterExpression) {
        Objects.requireNonNull(filterExpression);
        this.filterExpression = filterExpression;
        return this;
    }

    public CarbonReaderBuilder setAccessKey(String key, String value) {
        FileFactory.getConfiguration().set(key, value);
        return this;
    }

    public CarbonReaderBuilder setAccessKey(String value) {
        return this.setAccessKey("fs.s3a.access.key", value);
    }

    public CarbonReaderBuilder setSecretKey(String key, String value) {
        FileFactory.getConfiguration().set(key, value);
        return this;
    }

    public CarbonReaderBuilder setSecretKey(String value) {
        return this.setSecretKey("fs.s3a.secret.key", value);
    }

    public CarbonReaderBuilder setEndPoint(String key, String value) {
        FileFactory.getConfiguration().set(key, value);
        return this;
    }

    public CarbonReaderBuilder setEndPoint(String value) {
        return this.setEndPoint("fs.s3a.endpoint", value);
    }

    public <T> CarbonReader<T> build() throws IOException, InterruptedException {
        CarbonTable table = this.isTransactionalTable ? CarbonTable.buildFromTablePath((String)this.tableName, (String)"default", (String)this.tablePath, (String)UUID.randomUUID().toString()) : (this.filterExpression != null ? CarbonTable.buildTable((String)this.tablePath, (String)this.tableName) : CarbonTable.buildDummyTable((String)this.tablePath));
        CarbonFileInputFormat format = new CarbonFileInputFormat();
        Job job = new Job(new Configuration());
        CarbonFileInputFormat.setTableInfo((Configuration)job.getConfiguration(), (TableInfo)table.getTableInfo());
        CarbonFileInputFormat.setTablePath((Configuration)job.getConfiguration(), (String)table.getTablePath());
        CarbonFileInputFormat.setTableName((Configuration)job.getConfiguration(), (String)table.getTableName());
        CarbonFileInputFormat.setDatabaseName((Configuration)job.getConfiguration(), (String)table.getDatabaseName());
        if (this.filterExpression != null) {
            CarbonFileInputFormat.setFilterPredicates((Configuration)job.getConfiguration(), (Expression)this.filterExpression);
        }
        if (this.projectionColumns != null) {
            CarbonFileInputFormat.setColumnProjection((Configuration)job.getConfiguration(), (String[])this.projectionColumns);
        }
        try {
            List splits = format.getSplits((JobContext)new JobContextImpl(job.getConfiguration(), new JobID()));
            ArrayList readers = new ArrayList(splits.size());
            for (InputSplit split : splits) {
                TaskAttemptContextImpl attempt = new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID());
                RecordReader reader = format.createRecordReader(split, (TaskAttemptContext)attempt);
                try {
                    reader.initialize(split, (TaskAttemptContext)attempt);
                    readers.add(reader);
                }
                catch (Exception e) {
                    reader.close();
                    throw e;
                }
            }
            return new CarbonReader(readers);
        }
        catch (Exception ex) {
            DataMapStoreManager.getInstance().clearDataMaps(table.getAbsoluteTableIdentifier());
            throw ex;
        }
    }
}

