/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.util.CarbonTaskInfo;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ThreadLocalTaskInfo;
import org.apache.carbondata.sdk.file.CarbonReaderBuilder;
import org.apache.hadoop.mapreduce.RecordReader;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonReader<T> {
    private List<RecordReader<Void, T>> readers;
    private RecordReader<Void, T> currentReader;
    private int index;
    private boolean initialise;

    CarbonReader(List<RecordReader<Void, T>> readers) {
        if (readers.size() == 0) {
            throw new IllegalArgumentException("no reader");
        }
        this.initialise = true;
        this.readers = readers;
        this.index = 0;
        this.currentReader = readers.get(0);
        CarbonTaskInfo carbonTaskInfo = new CarbonTaskInfo();
        carbonTaskInfo.setTaskId(CarbonUtil.generateUUID());
        ThreadLocalTaskInfo.setCarbonTaskInfo((CarbonTaskInfo)carbonTaskInfo);
    }

    public boolean hasNext() throws IOException, InterruptedException {
        this.validateReader();
        if (this.currentReader.nextKeyValue()) {
            return true;
        }
        if (this.index == this.readers.size() - 1) {
            return false;
        }
        ++this.index;
        this.currentReader.close();
        this.currentReader = this.readers.get(this.index);
        return this.currentReader.nextKeyValue();
    }

    public T readNextRow() throws IOException, InterruptedException {
        this.validateReader();
        return (T)this.currentReader.getCurrentValue();
    }

    public Object[] readNextStringRow() throws IOException, InterruptedException {
        this.validateReader();
        Object t = this.currentReader.getCurrentValue();
        Object[] objects = (Object[])t;
        Object[] strings = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] instanceof Object[]) {
                Object[] arrayString = (Object[])objects[i];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(String.valueOf(arrayString[0]));
                if (arrayString.length > 1) {
                    for (int j = 1; j < arrayString.length; ++j) {
                        stringBuffer.append("\u0001").append(String.valueOf(arrayString[j]));
                    }
                }
                strings[i] = stringBuffer.toString();
                continue;
            }
            strings[i] = String.valueOf(objects[i]);
        }
        return strings;
    }

    public static CarbonReaderBuilder builder(String tablePath, String tableName) {
        return new CarbonReaderBuilder(tablePath, tableName);
    }

    public static CarbonReaderBuilder builder(String tablePath) {
        String time = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String tableName = "UnknownTable" + time;
        return CarbonReader.builder(tablePath, tableName);
    }

    public void close() throws IOException {
        this.validateReader();
        this.currentReader.close();
        this.initialise = false;
    }

    private void validateReader() {
        if (!this.initialise) {
            throw new RuntimeException(this.getClass().getSimpleName() + " not initialise, please create it first.");
        }
    }
}

