/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.reader.CarbonHeaderReader;
import org.apache.carbondata.core.reader.CarbonIndexFileReader;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.IndexHeader;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.sdk.file.Schema;

public class CarbonSchemaReader {
    public static Schema readSchemaInSchemaFile(String schemaFilePath) throws IOException {
        TableInfo tableInfo = CarbonUtil.readSchemaFile((String)schemaFilePath);
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        List schemaList = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, "", "", "").getFactTable().getListOfColumns();
        return new Schema(schemaList);
    }

    public static Schema readSchemaInDataFile(String dataFilePath) throws IOException {
        CarbonHeaderReader reader = new CarbonHeaderReader(dataFilePath);
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        List schemaList = reader.readSchema();
        for (int i = 0; i < schemaList.size(); ++i) {
            org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema columnSchema = (org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema)schemaList.get(i);
            if (columnSchema.getColumnName().contains(".")) continue;
            columnSchemaList.add(columnSchema);
        }
        return new Schema(columnSchemaList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema readSchemaInIndexFile(String indexFilePath) throws IOException {
        CarbonFile indexFile = FileFactory.getCarbonFile((String)indexFilePath, (FileFactory.FileType)FileFactory.getFileType((String)indexFilePath));
        if (!indexFile.getName().endsWith(".carbonindex")) {
            throw new IOException("Not an index file name");
        }
        byte[] bytes = new byte[(int)indexFile.getSize()];
        try (DataInputStream dataInputStream = FileFactory.getDataInputStream((String)indexFilePath, (FileFactory.FileType)FileFactory.getFileType((String)indexFilePath));){
            dataInputStream.readFully(bytes);
            CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
            indexReader.openThriftReader(bytes);
            IndexHeader readIndexHeader = indexReader.readIndexHeader();
            ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
            List table_columns = readIndexHeader.getTable_columns();
            for (ColumnSchema columnSchema : table_columns) {
                if (columnSchema.column_name.contains(".")) continue;
                columnSchemaList.add(CarbonUtil.thriftColumnSchemaToWrapperColumnSchema((ColumnSchema)columnSchema));
            }
            Schema schema = new Schema(columnSchemaList);
            return schema;
        }
    }
}

