/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.datamap.DataMapStoreManager;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableInfo;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.model.ProjectionDimension;
import org.apache.carbondata.core.scan.model.QueryModel;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonSessionInfo;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.hadoop.api.CarbonFileInputFormat;
import org.apache.carbondata.hadoop.util.CarbonVectorizedRecordReader;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonReaderBuilder {
    private String tablePath;
    private String[] projectionColumns;
    private Expression filterExpression;
    private String tableName;
    private Configuration hadoopConf;
    private boolean useVectorReader = true;

    CarbonReaderBuilder(String tablePath, String tableName) {
        this.tablePath = tablePath;
        this.tableName = tableName;
        ThreadLocalSessionInfo.setCarbonSessionInfo((CarbonSessionInfo)new CarbonSessionInfo());
    }

    public CarbonReaderBuilder projection(String[] projectionColumnNames) {
        Objects.requireNonNull(projectionColumnNames);
        this.projectionColumns = projectionColumnNames;
        return this;
    }

    public CarbonReaderBuilder filter(Expression filterExpression) {
        Objects.requireNonNull(filterExpression);
        this.filterExpression = filterExpression;
        return this;
    }

    public CarbonReaderBuilder withHadoopConf(Configuration conf) {
        if (conf != null) {
            this.hadoopConf = conf;
        }
        return this;
    }

    public CarbonReaderBuilder withBatch(int batch) {
        CarbonProperties.getInstance().addProperty("carbon.detail.batch.size", String.valueOf(batch));
        return this;
    }

    public CarbonReaderBuilder withHadoopConf(String key, String value) {
        if (this.hadoopConf == null) {
            this.hadoopConf = new Configuration();
        }
        this.hadoopConf.set(key, value);
        return this;
    }

    public CarbonReaderBuilder withRowRecordReader() {
        this.useVectorReader = false;
        return this;
    }

    public <T> CarbonReader<T> build() throws IOException, InterruptedException {
        if (this.hadoopConf == null) {
            this.hadoopConf = FileFactory.getConfiguration();
        }
        CarbonTable table = CarbonTable.buildTable((String)this.tablePath, (String)this.tableName, (Configuration)this.hadoopConf);
        CarbonFileInputFormat format = new CarbonFileInputFormat();
        Job job = new Job(this.hadoopConf);
        CarbonFileInputFormat.setTableInfo((Configuration)job.getConfiguration(), (TableInfo)table.getTableInfo());
        CarbonFileInputFormat.setTablePath((Configuration)job.getConfiguration(), (String)table.getTablePath());
        CarbonFileInputFormat.setTableName((Configuration)job.getConfiguration(), (String)table.getTableName());
        CarbonFileInputFormat.setDatabaseName((Configuration)job.getConfiguration(), (String)table.getDatabaseName());
        if (this.filterExpression != null) {
            CarbonFileInputFormat.setFilterPredicates((Configuration)job.getConfiguration(), (Expression)this.filterExpression);
        }
        if (this.projectionColumns != null) {
            int len = this.projectionColumns.length;
            for (int i = 0; i < len; ++i) {
                if (!this.projectionColumns[i].contains(".")) continue;
                throw new UnsupportedOperationException("Complex child columns projection NOT supported through CarbonReader");
            }
            CarbonFileInputFormat.setColumnProjection((Configuration)job.getConfiguration(), (String[])this.projectionColumns);
        }
        try {
            if (this.filterExpression == null) {
                job.getConfiguration().set("filter_blocks", "false");
            }
            List splits = format.getSplits((JobContext)new JobContextImpl(job.getConfiguration(), new JobID()));
            ArrayList<RecordReader<Void, RecordReader>> readers = new ArrayList<RecordReader<Void, RecordReader>>(splits.size());
            for (InputSplit split : splits) {
                RecordReader reader;
                TaskAttemptContextImpl attempt = new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID());
                QueryModel queryModel = format.createQueryModel(split, (TaskAttemptContext)attempt);
                boolean hasComplex = false;
                for (ProjectionDimension projectionDimension : queryModel.getProjectionDimensions()) {
                    if (!projectionDimension.getDimension().isComplex().booleanValue()) continue;
                    hasComplex = true;
                    break;
                }
                if (this.useVectorReader && !hasComplex) {
                    queryModel.setDirectVectorFill(this.filterExpression == null);
                    reader = new CarbonVectorizedRecordReader(queryModel);
                } else {
                    reader = format.createRecordReader(split, (TaskAttemptContext)attempt);
                }
                try {
                    reader.initialize(split, (TaskAttemptContext)attempt);
                    readers.add(reader);
                }
                catch (Exception e) {
                    CarbonUtil.closeStreams((Closeable[])((Closeable[])readers.toArray(new RecordReader[0])));
                    throw e;
                }
            }
            return new CarbonReader(readers);
        }
        catch (Exception ex) {
            DataMapStoreManager.getInstance().clearDataMaps(table.getAbsoluteTableIdentifier());
            throw ex;
        }
    }
}

