/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.FileReader;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.converter.ThriftWrapperSchemaConverterImpl;
import org.apache.carbondata.core.reader.CarbonFooterReaderV3;
import org.apache.carbondata.core.reader.CarbonHeaderReader;
import org.apache.carbondata.core.reader.CarbonIndexFileReader;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.FileFooter3;
import org.apache.carbondata.format.IndexHeader;
import org.apache.carbondata.format.TableInfo;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.sdk.file.Schema;

public class CarbonSchemaReader {
    @Deprecated
    public static Schema readSchemaInSchemaFile(String schemaFilePath) throws IOException {
        TableInfo tableInfo = CarbonUtil.readSchemaFile((String)schemaFilePath);
        ThriftWrapperSchemaConverterImpl schemaConverter = new ThriftWrapperSchemaConverterImpl();
        List schemaList = schemaConverter.fromExternalToWrapperTableInfo(tableInfo, "", "", "").getFactTable().getListOfColumns();
        return new Schema(schemaList);
    }

    private static CarbonFile[] getCarbonFile(String path, final String extension) throws IOException {
        String dataFilePath = path;
        if (!dataFilePath.endsWith(extension)) {
            CarbonFile[] carbonFiles = FileFactory.getCarbonFile((String)path).listFiles(new CarbonFileFilter(){

                public boolean accept(CarbonFile file) {
                    if (file == null) {
                        return false;
                    }
                    return file.getName().endsWith(extension);
                }
            });
            if (carbonFiles == null || carbonFiles.length < 1) {
                throw new IOException("Carbon file not exists.");
            }
            return carbonFiles;
        }
        throw new CarbonDataLoadingException("Please ensure path " + path + " end with " + extension);
    }

    public static Schema readSchema(String path) throws IOException {
        return CarbonSchemaReader.readSchema(path, false);
    }

    public static Schema readSchema(String path, boolean validateSchema) throws IOException {
        if (path.endsWith(".carbonindex")) {
            return CarbonSchemaReader.readSchemaFromIndexFile(path);
        }
        if (path.endsWith(".carbondata")) {
            return CarbonSchemaReader.readSchemaFromDataFile(path);
        }
        if (validateSchema) {
            CarbonFile[] carbonIndexFiles = CarbonSchemaReader.getCarbonFile(path, ".carbonindex");
            if (carbonIndexFiles != null && carbonIndexFiles.length != 0) {
                Schema schema = CarbonSchemaReader.readSchemaFromIndexFile(carbonIndexFiles[0].getAbsolutePath());
                for (int i = 1; i < carbonIndexFiles.length; ++i) {
                    Schema schema2 = CarbonSchemaReader.readSchemaFromIndexFile(carbonIndexFiles[i].getAbsolutePath());
                    if (schema.equals(schema2)) continue;
                    throw new CarbonDataLoadingException("Schema is different between different files.");
                }
                CarbonFile[] carbonDataFiles = CarbonSchemaReader.getCarbonFile(path, ".carbondata");
                for (int i = 0; i < carbonDataFiles.length; ++i) {
                    Schema schema2 = CarbonSchemaReader.readSchemaFromDataFile(carbonDataFiles[i].getAbsolutePath());
                    if (schema.equals(schema2)) continue;
                    throw new CarbonDataLoadingException("Schema is different between different files.");
                }
                return schema;
            }
            throw new CarbonDataLoadingException("No carbonindex file in this path.");
        }
        String indexFilePath = CarbonSchemaReader.getCarbonFile(path, ".carbonindex")[0].getAbsolutePath();
        return CarbonSchemaReader.readSchemaFromIndexFile(indexFilePath);
    }

    @Deprecated
    public static Schema readSchemaInDataFile(String dataFilePath) throws IOException {
        return CarbonSchemaReader.readSchema(dataFilePath, false);
    }

    public static Schema readSchemaFromDataFile(String dataFilePath) throws IOException {
        CarbonHeaderReader reader = new CarbonHeaderReader(dataFilePath);
        ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
        List schemaList = reader.readSchema();
        for (int i = 0; i < schemaList.size(); ++i) {
            org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema columnSchema = (org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema)schemaList.get(i);
            if (columnSchema.getColumnName().contains(".")) continue;
            columnSchemaList.add(columnSchema);
        }
        return new Schema(columnSchemaList);
    }

    @Deprecated
    public static Schema readSchemaInIndexFile(String indexFilePath) throws IOException {
        return CarbonSchemaReader.readSchema(indexFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema readSchemaFromIndexFile(String indexFilePath) throws IOException {
        CarbonFile indexFile = FileFactory.getCarbonFile((String)indexFilePath, (FileFactory.FileType)FileFactory.getFileType((String)indexFilePath));
        if (!indexFile.getName().endsWith(".carbonindex")) {
            throw new IOException("Not an index file name");
        }
        byte[] bytes = new byte[(int)indexFile.getSize()];
        try (DataInputStream dataInputStream = FileFactory.getDataInputStream((String)indexFilePath, (FileFactory.FileType)FileFactory.getFileType((String)indexFilePath));){
            dataInputStream.readFully(bytes);
            CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
            indexReader.openThriftReader(bytes);
            IndexHeader readIndexHeader = indexReader.readIndexHeader();
            ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema> columnSchemaList = new ArrayList<org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema>();
            List table_columns = readIndexHeader.getTable_columns();
            for (ColumnSchema columnSchema : table_columns) {
                if (columnSchema.column_name.contains(".")) continue;
                columnSchemaList.add(CarbonUtil.thriftColumnSchemaToWrapperColumnSchema((ColumnSchema)columnSchema));
            }
            Schema schema = new Schema(columnSchemaList);
            return schema;
        }
    }

    public static String getVersionDetails(String dataFilePath) throws IOException {
        long fileSize = FileFactory.getCarbonFile((String)dataFilePath, (FileFactory.FileType)FileFactory.getFileType((String)dataFilePath)).getSize();
        FileReader fileReader = FileFactory.getFileHolder((FileFactory.FileType)FileFactory.getFileType((String)dataFilePath));
        ByteBuffer buffer = fileReader.readByteBuffer(FileFactory.getUpdatedFilePath((String)dataFilePath), fileSize - 8L, 8);
        fileReader.finish();
        CarbonFooterReaderV3 footerReader = new CarbonFooterReaderV3(dataFilePath, buffer.getLong());
        FileFooter3 footer = footerReader.readFooterVersion3();
        if (null != footer.getExtra_info()) {
            return (String)footer.getExtra_info().get("written_by") + " in version: " + (String)footer.getExtra_info().get("version");
        }
        return "Version Details are not found in carbondata file";
    }
}

