/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.metadata.datatype.ArrayType;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.MapType;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.datatype.StructType;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;

@InterfaceAudience.User
@InterfaceStability.Unstable
public class Field {
    private String name;
    private DataType type;
    private List<StructField> children;
    private String parent;
    private String storeType = "columnar";
    private int schemaOrdinal = -1;
    private int precision = 0;
    private int scale = 0;
    private String rawSchema = "";
    private String columnComment = "";

    public Field(String name, String type) {
        this.name = name.toLowerCase().trim();
        if (type.equalsIgnoreCase("string")) {
            this.type = DataTypes.STRING;
        } else if (type.equalsIgnoreCase("varchar")) {
            this.type = DataTypes.VARCHAR;
        } else if (type.equalsIgnoreCase("date")) {
            this.type = DataTypes.DATE;
        } else if (type.equalsIgnoreCase("timestamp")) {
            this.type = DataTypes.TIMESTAMP;
        } else if (type.equalsIgnoreCase("boolean")) {
            this.type = DataTypes.BOOLEAN;
        } else if (type.equalsIgnoreCase("byte")) {
            this.type = DataTypes.BYTE;
        } else if (type.equalsIgnoreCase("short")) {
            this.type = DataTypes.SHORT;
        } else if (type.equalsIgnoreCase("int")) {
            this.type = DataTypes.INT;
        } else if (type.equalsIgnoreCase("long")) {
            this.type = DataTypes.LONG;
        } else if (type.equalsIgnoreCase("float")) {
            this.type = DataTypes.FLOAT;
        } else if (type.equalsIgnoreCase("double")) {
            this.type = DataTypes.DOUBLE;
        } else if (type.equalsIgnoreCase("array")) {
            this.type = DataTypes.createDefaultArrayType();
        } else if (type.equalsIgnoreCase("struct")) {
            this.type = DataTypes.createDefaultStructType();
        } else if (type.equalsIgnoreCase("map")) {
            this.type = DataTypes.createDefaultMapType();
        } else {
            throw new IllegalArgumentException("unsupported data type: " + type);
        }
    }

    public Field(String name, String type, List<StructField> fields) {
        this.name = name.toLowerCase().trim();
        this.children = fields;
        if (type.equalsIgnoreCase("string")) {
            this.type = DataTypes.STRING;
        } else if (type.equalsIgnoreCase("varchar")) {
            this.type = DataTypes.VARCHAR;
        } else if (type.equalsIgnoreCase("date")) {
            this.type = DataTypes.DATE;
        } else if (type.equalsIgnoreCase("timestamp")) {
            this.type = DataTypes.TIMESTAMP;
        } else if (type.equalsIgnoreCase("boolean")) {
            this.type = DataTypes.BOOLEAN;
        } else if (type.equalsIgnoreCase("byte")) {
            this.type = DataTypes.BYTE;
        } else if (type.equalsIgnoreCase("short")) {
            this.type = DataTypes.SHORT;
        } else if (type.equalsIgnoreCase("int")) {
            this.type = DataTypes.INT;
        } else if (type.equalsIgnoreCase("long")) {
            this.type = DataTypes.LONG;
        } else if (type.equalsIgnoreCase("float")) {
            this.type = DataTypes.FLOAT;
        } else if (type.equalsIgnoreCase("double")) {
            this.type = DataTypes.DOUBLE;
        } else if (type.equalsIgnoreCase("array")) {
            this.type = DataTypes.createArrayType((DataType)fields.get(0).getDataType());
        } else if (type.equalsIgnoreCase("struct")) {
            this.type = DataTypes.createStructType(fields);
        } else {
            throw new IllegalArgumentException("unsupported data type: " + type);
        }
    }

    public Field(String name, DataType type, List<StructField> fields) {
        this.name = name.toLowerCase().trim();
        this.type = type;
        this.children = fields;
    }

    public Field(String name, DataType type) {
        this.name = name.toLowerCase().trim();
        this.type = type;
        this.initComplexTypeChildren();
    }

    public Field(ColumnSchema columnSchema) {
        this.name = columnSchema.getColumnName().toLowerCase().trim();
        this.type = columnSchema.getDataType();
        this.children = new LinkedList<StructField>();
        this.schemaOrdinal = columnSchema.getSchemaOrdinal();
        this.precision = columnSchema.getPrecision();
        this.scale = columnSchema.getScale();
    }

    public String getFieldName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.type;
    }

    public List<StructField> getChildren() {
        return this.children;
    }

    public void setChildren(List<StructField> children) {
        this.children = children;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public int getSchemaOrdinal() {
        return this.schemaOrdinal;
    }

    public void setSchemaOrdinal(int schemaOrdinal) {
        this.schemaOrdinal = schemaOrdinal;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getRawSchema() {
        return this.rawSchema;
    }

    public void setRawSchema(String rawSchema) {
        this.rawSchema = rawSchema;
    }

    public String getColumnComment() {
        return this.columnComment;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }

    public void updateDataTypeToVarchar() {
        this.type = DataTypes.VARCHAR;
    }

    private void initComplexTypeChildren() {
        if (this.getDataType().isComplexType()) {
            StructField subFields = this.prepareSubFields(this.getFieldName(), this.getDataType());
            if (DataTypes.isArrayType((DataType)this.getDataType()) || DataTypes.isMapType((DataType)this.getDataType())) {
                this.children = subFields.getChildren();
            } else if (DataTypes.isStructType((DataType)this.getDataType())) {
                this.children = ((StructType)subFields.getDataType()).getFields();
            }
        }
    }

    public String toString() {
        return "Field{name='" + this.name + '\'' + ", type=" + this.type + ", schemaOrdinal=" + this.schemaOrdinal + '}';
    }

    private StructField prepareSubFields(String fieldName, DataType dataType) {
        if (DataTypes.isArrayType((DataType)dataType)) {
            ArrayList<StructField> arrayFields = new ArrayList<StructField>();
            StructField arrayField = this.prepareSubFields(fieldName, ((ArrayType)dataType).getElementType());
            arrayFields.add(arrayField);
            return new StructField(fieldName, (DataType)DataTypes.createArrayType((DataType)arrayField.getDataType()), arrayFields);
        }
        if (DataTypes.isStructType((DataType)dataType)) {
            ArrayList<StructField> structFields = new ArrayList<StructField>();
            List fields = ((StructType)dataType).getFields();
            for (StructField field : fields) {
                structFields.add(this.prepareSubFields(field.getFieldName(), field.getDataType()));
            }
            return new StructField(fieldName, (DataType)DataTypes.createStructType(structFields), structFields);
        }
        if (DataTypes.isMapType((DataType)dataType)) {
            ArrayList<StructField> mapFields = new ArrayList<StructField>();
            MapType mapType = (MapType)dataType;
            StructField keyField = new StructField(fieldName + ".key", mapType.getKeyType());
            StructField valueField = this.prepareSubFields(fieldName + ".value", mapType.getValueType());
            mapFields.add(keyField);
            mapFields.add(valueField);
            StructField field = new StructField(fieldName + ".val", (DataType)DataTypes.createStructType(mapFields));
            MapType mapDataType = DataTypes.createMapType((DataType)keyField.getDataType(), (DataType)field.getDataType());
            ArrayList<StructField> mapStructField = new ArrayList<StructField>();
            mapStructField.add(field);
            return new StructField(fieldName, (DataType)mapDataType, mapStructField);
        }
        return new StructField(fieldName, dataType);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Field) {
            Field field = (Field)obj;
            return this.getDataType().equals((Object)field.getDataType()) && this.getFieldName().equals(field.getFieldName()) && this.getSchemaOrdinal() == field.getSchemaOrdinal();
        }
        return false;
    }
}

