/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.MapType;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.datatype.StructType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.hadoop.api.CarbonTableOutputFormat;
import org.apache.carbondata.hadoop.internal.ObjectArrayWritable;
import org.apache.carbondata.processing.loading.complexobjects.ArrayObject;
import org.apache.carbondata.processing.loading.complexobjects.StructObject;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.Field;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;

@InterfaceAudience.Internal
public class AvroCarbonWriter
extends CarbonWriter {
    private RecordWriter<NullWritable, ObjectArrayWritable> recordWriter;
    private TaskAttemptContext context;
    private ObjectArrayWritable writable;
    private org.apache.avro.Schema avroSchema;
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)CarbonTable.class.getName());

    AvroCarbonWriter(CarbonLoadModel loadModel, Configuration hadoopConf) throws IOException {
        CarbonTableOutputFormat.setLoadModel((Configuration)hadoopConf, (CarbonLoadModel)loadModel);
        CarbonTableOutputFormat format = new CarbonTableOutputFormat();
        JobID jobId = new JobID(UUID.randomUUID().toString(), 0);
        Random random = new Random();
        TaskID task = new TaskID(jobId, TaskType.MAP, random.nextInt());
        TaskAttemptID attemptID = new TaskAttemptID(task, random.nextInt());
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(hadoopConf, attemptID);
        this.recordWriter = format.getRecordWriter((TaskAttemptContext)context);
        this.context = context;
        this.writable = new ObjectArrayWritable();
    }

    private Object[] avroToCsv(GenericData.Record avroRecord) {
        if (this.avroSchema == null) {
            this.avroSchema = avroRecord.getSchema();
        }
        List fields = this.avroSchema.getFields();
        ArrayList<Object> csvFields = new ArrayList<Object>();
        for (int i = 0; i < fields.size(); ++i) {
            Object field = this.avroFieldToObject((Schema.Field)fields.get(i), avroRecord.get(i));
            if (field == null) continue;
            csvFields.add(field);
        }
        return csvFields.toArray();
    }

    private Object avroFieldToObject(Schema.Field avroField, Object fieldValue) {
        Object out = null;
        Schema.Type type = avroField.schema().getType();
        LogicalType logicalType = avroField.schema().getLogicalType();
        switch (type) {
            case MAP: {
                HashMap mapEntries = (HashMap)fieldValue;
                Object[] arrayMapChildObjects = new Object[mapEntries.size()];
                if (!mapEntries.isEmpty()) {
                    Iterator iterator = mapEntries.entrySet().iterator();
                    int counter = 0;
                    while (iterator.hasNext()) {
                        Object[] mapChildObjects = new Object[2];
                        Map.Entry mapEntry = iterator.next();
                        Object keyObject = this.avroFieldToObject(new Schema.Field(avroField.name(), org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING), avroField.doc(), avroField.defaultVal()), mapEntry.getKey());
                        Object valueObject = this.avroFieldToObject(new Schema.Field(avroField.name(), avroField.schema().getValueType(), avroField.doc(), avroField.defaultVal()), mapEntry.getValue());
                        if (keyObject != null) {
                            mapChildObjects[0] = keyObject;
                        }
                        if (valueObject != null) {
                            mapChildObjects[1] = valueObject;
                        }
                        StructObject keyValueObject = new StructObject(mapChildObjects);
                        arrayMapChildObjects[counter++] = keyValueObject;
                    }
                }
                out = new ArrayObject(arrayMapChildObjects);
                break;
            }
            case RECORD: {
                List fields = avroField.schema().getFields();
                Object[] structChildObjects = new Object[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    Object childObject = this.avroFieldToObject((Schema.Field)fields.get(i), ((GenericData.Record)fieldValue).get(i));
                    if (childObject == null) continue;
                    structChildObjects[i] = childObject;
                }
                StructObject structObject = new StructObject(structChildObjects);
                out = structObject;
                break;
            }
            case ARRAY: {
                Object[] arrayChildObjects;
                if (fieldValue instanceof GenericData.Array) {
                    int size = ((GenericData.Array)fieldValue).size();
                    arrayChildObjects = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        Object childObject = this.avroFieldToObject(new Schema.Field(avroField.name(), avroField.schema().getElementType(), avroField.doc(), avroField.defaultVal()), ((GenericData.Array)fieldValue).get(i));
                        if (childObject == null) continue;
                        arrayChildObjects[i] = childObject;
                    }
                } else {
                    int size = ((ArrayList)fieldValue).size();
                    arrayChildObjects = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        Object childObject = this.avroFieldToObject(new Schema.Field(avroField.name(), avroField.schema().getElementType(), avroField.doc(), avroField.defaultVal()), ((ArrayList)fieldValue).get(i));
                        if (childObject == null) continue;
                        arrayChildObjects[i] = childObject;
                    }
                }
                out = new ArrayObject(arrayChildObjects);
                break;
            }
            case UNION: {
                List unionFields = avroField.schema().getTypes();
                int notNullUnionFieldsCount = 0;
                for (org.apache.avro.Schema unionField : unionFields) {
                    if (unionField.getType().equals((Object)Schema.Type.NULL)) continue;
                    ++notNullUnionFieldsCount;
                }
                Object[] values = new Object[notNullUnionFieldsCount];
                int j = 0;
                for (org.apache.avro.Schema unionField : unionFields) {
                    if (unionField.getType().equals((Object)Schema.Type.NULL)) continue;
                    if (this.validateUnionFieldValue(unionField.getType(), fieldValue, unionField)) {
                        values[j] = this.avroFieldToObjectForUnionType(unionField, fieldValue, avroField);
                        break;
                    }
                    ++j;
                }
                out = new StructObject(values);
                break;
            }
            case BYTES: {
                if (!(logicalType instanceof LogicalTypes.Decimal)) break;
                out = this.extractDecimalValue(fieldValue, ((LogicalTypes.Decimal)avroField.schema().getLogicalType()).getScale(), ((LogicalTypes.Decimal)avroField.schema().getLogicalType()).getPrecision());
                break;
            }
            default: {
                out = this.avroPrimitiveFieldToObject(type, logicalType, fieldValue);
            }
        }
        return out;
    }

    private boolean validateUnionFieldValue(Schema.Type type, Object fieldValue, org.apache.avro.Schema unionField) {
        switch (type) {
            case INT: {
                return fieldValue instanceof Integer;
            }
            case BOOLEAN: {
                return fieldValue instanceof Boolean;
            }
            case LONG: {
                return fieldValue instanceof Long;
            }
            case DOUBLE: {
                return fieldValue instanceof Double;
            }
            case STRING: {
                return fieldValue instanceof Utf8 || fieldValue instanceof String;
            }
            case FLOAT: {
                return fieldValue instanceof Float;
            }
            case RECORD: {
                return fieldValue instanceof GenericData.Record && unionField.equals((Object)((GenericData.Record)fieldValue).getSchema());
            }
            case ARRAY: {
                return fieldValue instanceof GenericData.Array || fieldValue instanceof ArrayList;
            }
            case BYTES: {
                return fieldValue instanceof ByteBuffer;
            }
            case MAP: {
                return fieldValue instanceof HashMap;
            }
            case ENUM: {
                return fieldValue instanceof GenericData.EnumSymbol && unionField.equals((Object)((GenericData.EnumSymbol)fieldValue).getSchema());
            }
        }
        return false;
    }

    private Object avroPrimitiveFieldToObject(Schema.Type type, LogicalType logicalType, Object fieldValue) {
        Object out;
        switch (type) {
            case INT: {
                if (logicalType != null) {
                    if (logicalType instanceof LogicalTypes.Date) {
                        int dateIntValue = (Integer)fieldValue;
                        out = (long)dateIntValue * 86400000L;
                        break;
                    }
                    LOGGER.warn((Object)("Actual type: INT, Logical Type: " + logicalType.getName()));
                    out = fieldValue;
                    break;
                }
                out = fieldValue;
                break;
            }
            case BOOLEAN: 
            case LONG: {
                if (logicalType != null && !(logicalType instanceof LogicalTypes.TimestampMillis)) {
                    if (logicalType instanceof LogicalTypes.TimestampMicros) {
                        long dateIntValue = (Long)fieldValue;
                        out = dateIntValue / 1000L;
                        break;
                    }
                    LOGGER.warn((Object)("Actual type: INT, Logical Type: " + logicalType.getName()));
                    out = fieldValue;
                    break;
                }
                out = fieldValue;
                break;
            }
            case DOUBLE: 
            case STRING: 
            case ENUM: {
                out = fieldValue;
                break;
            }
            case FLOAT: {
                out = Float.valueOf(Float.parseFloat(fieldValue.toString()));
                break;
            }
            case NULL: {
                out = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("carbon not support " + type.toString() + " avro type yet");
            }
        }
        return out;
    }

    private Object avroFieldToObjectForUnionType(org.apache.avro.Schema avroField, Object fieldValue, Schema.Field avroFields) {
        Object out = null;
        Schema.Type type = avroField.getType();
        LogicalType logicalType = avroField.getLogicalType();
        switch (type) {
            case RECORD: {
                if (fieldValue instanceof GenericData.Record) {
                    List fields = avroField.getFields();
                    Object[] structChildObjects = new Object[fields.size()];
                    for (int i = 0; i < fields.size(); ++i) {
                        Object childObject = this.avroFieldToObject((Schema.Field)fields.get(i), ((GenericData.Record)fieldValue).get(i));
                        if (childObject == null) continue;
                        structChildObjects[i] = childObject;
                    }
                    out = new StructObject(structChildObjects);
                    break;
                }
                out = null;
                break;
            }
            case ARRAY: {
                if (fieldValue instanceof GenericData.Array || fieldValue instanceof ArrayList) {
                    Object[] arrayChildObjects;
                    if (fieldValue instanceof GenericData.Array) {
                        int size = ((GenericData.Array)fieldValue).size();
                        arrayChildObjects = new Object[size];
                        for (int i = 0; i < size; ++i) {
                            Object childObject = this.avroFieldToObject(new Schema.Field(avroFields.name(), avroField.getElementType(), avroFields.doc(), avroFields.defaultVal()), ((GenericData.Array)fieldValue).get(i));
                            if (childObject == null) continue;
                            arrayChildObjects[i] = childObject;
                        }
                    } else {
                        int size = ((ArrayList)fieldValue).size();
                        arrayChildObjects = new Object[size];
                        for (int i = 0; i < size; ++i) {
                            Object childObject = this.avroFieldToObject(new Schema.Field(avroFields.name(), avroField.getElementType(), avroFields.doc(), avroFields.defaultVal()), ((ArrayList)fieldValue).get(i));
                            if (childObject == null) continue;
                            arrayChildObjects[i] = childObject;
                        }
                    }
                    out = new ArrayObject(arrayChildObjects);
                    break;
                }
                out = null;
                break;
            }
            case MAP: {
                if (fieldValue instanceof HashMap) {
                    HashMap mapEntries = (HashMap)fieldValue;
                    Object[] arrayMapChildObjects = new Object[mapEntries.size()];
                    if (!mapEntries.isEmpty()) {
                        Iterator iterator = mapEntries.entrySet().iterator();
                        int counter = 0;
                        while (iterator.hasNext()) {
                            Object[] mapChildObjects = new Object[2];
                            Map.Entry mapEntry = iterator.next();
                            Object keyObject = this.avroFieldToObject(new Schema.Field(avroFields.name(), org.apache.avro.Schema.create((Schema.Type)Schema.Type.STRING), avroFields.doc(), avroFields.defaultVal()), mapEntry.getKey());
                            Object valueObject = this.avroFieldToObject(new Schema.Field(avroFields.name(), avroField.getValueType(), avroFields.doc(), avroFields.defaultVal()), mapEntry.getValue());
                            if (keyObject != null) {
                                mapChildObjects[0] = keyObject;
                            }
                            if (valueObject != null) {
                                mapChildObjects[1] = valueObject;
                            }
                            StructObject keyValueObject = new StructObject(mapChildObjects);
                            arrayMapChildObjects[counter++] = keyValueObject;
                        }
                    }
                    out = new ArrayObject(arrayMapChildObjects);
                    break;
                }
                out = null;
                break;
            }
            case BYTES: {
                if (!(logicalType instanceof LogicalTypes.Decimal)) break;
                out = this.extractDecimalValue(fieldValue, ((LogicalTypes.Decimal)avroField.getLogicalType()).getScale(), ((LogicalTypes.Decimal)avroField.getLogicalType()).getPrecision());
                break;
            }
            default: {
                out = this.avroPrimitiveFieldToObject(type, logicalType, fieldValue);
            }
        }
        return out;
    }

    private Object extractDecimalValue(Object fieldValue, int scale, int precision) {
        BigDecimal dataValue = new BigDecimal(new BigInteger(((ByteBuffer)fieldValue).array()), scale);
        if (dataValue.precision() <= precision) {
            return dataValue;
        }
        throw new CarbonDataLoadingException("Data Loading failed as value Precision " + dataValue.precision() + " is greater than specified Precision " + precision + " in Avro Schema");
    }

    public static Schema getCarbonSchemaFromAvroSchema(org.apache.avro.Schema avroSchema) {
        Field[] carbonField = new Field[avroSchema.getFields().size()];
        int i = 0;
        for (Schema.Field avroField : avroSchema.getFields()) {
            Field field = AvroCarbonWriter.prepareFields(avroField);
            if (field != null) {
                carbonField[i] = field;
            }
            ++i;
        }
        return new Schema(carbonField);
    }

    private static Field prepareFields(Schema.Field avroField) {
        String fieldName = avroField.name();
        org.apache.avro.Schema childSchema = avroField.schema();
        Schema.Type type = childSchema.getType();
        LogicalType logicalType = childSchema.getLogicalType();
        switch (type) {
            case BOOLEAN: {
                return new Field(fieldName, DataTypes.BOOLEAN);
            }
            case INT: {
                if (logicalType instanceof LogicalTypes.Date) {
                    return new Field(fieldName, DataTypes.DATE);
                }
                return new Field(fieldName, DataTypes.INT);
            }
            case LONG: {
                if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros) {
                    return new Field(fieldName, DataTypes.TIMESTAMP);
                }
                return new Field(fieldName, DataTypes.LONG);
            }
            case DOUBLE: {
                return new Field(fieldName, DataTypes.DOUBLE);
            }
            case STRING: 
            case ENUM: {
                return new Field(fieldName, DataTypes.STRING);
            }
            case FLOAT: {
                return new Field(fieldName, DataTypes.FLOAT);
            }
            case MAP: {
                ArrayList<StructField> mapSubFields = new ArrayList<StructField>();
                StructField mapField = AvroCarbonWriter.prepareSubFields(fieldName, childSchema);
                if (null != mapField) {
                    StructField keyValueField = (StructField)mapField.getChildren().get(0);
                    DataType valueType = ((StructField)((StructType)keyValueField.getDataType()).getFields().get(1)).getDataType();
                    MapType mapType = DataTypes.createMapType((DataType)DataTypes.STRING, (DataType)valueType);
                    mapSubFields.add(keyValueField);
                    return new Field(fieldName, (DataType)mapType, mapSubFields);
                }
                return null;
            }
            case RECORD: {
                ArrayList<StructField> structSubFields = new ArrayList<StructField>();
                for (Schema.Field avroSubField : childSchema.getFields()) {
                    StructField structField = AvroCarbonWriter.prepareSubFields(avroSubField.name(), avroSubField.schema());
                    if (structField == null) continue;
                    structSubFields.add(structField);
                }
                return new Field(fieldName, "struct", structSubFields);
            }
            case ARRAY: {
                ArrayList<StructField> arraySubField = new ArrayList<StructField>();
                StructField structField = AvroCarbonWriter.prepareSubFields(fieldName, childSchema.getElementType());
                if (structField != null) {
                    arraySubField.add(structField);
                    return new Field(fieldName, "array", arraySubField);
                }
                return null;
            }
            case UNION: {
                int i = 0;
                ArrayList<StructField> unionFields = new ArrayList<StructField>();
                for (org.apache.avro.Schema avroSubField : avroField.schema().getTypes()) {
                    StructField unionField;
                    if (avroSubField.getType().equals((Object)Schema.Type.NULL) || (unionField = AvroCarbonWriter.prepareSubFields(avroField.name() + i++, avroSubField)) == null) continue;
                    unionFields.add(unionField);
                }
                if (unionFields.isEmpty()) {
                    throw new UnsupportedOperationException("Carbon do not support Avro UNION with only null type");
                }
                return new Field(fieldName, "struct", unionFields);
            }
            case BYTES: {
                if (logicalType instanceof LogicalTypes.Decimal) {
                    int precision = ((LogicalTypes.Decimal)childSchema.getLogicalType()).getPrecision();
                    int scale = ((LogicalTypes.Decimal)childSchema.getLogicalType()).getScale();
                    return new Field(fieldName, (DataType)DataTypes.createDecimalType((int)precision, (int)scale));
                }
                throw new UnsupportedOperationException("carbon not support " + type.toString() + " avro type yet");
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("carbon not support " + type.toString() + " avro type yet");
    }

    private static StructField prepareSubFields(String fieldName, org.apache.avro.Schema childSchema) {
        Schema.Type type = childSchema.getType();
        LogicalType logicalType = childSchema.getLogicalType();
        switch (type) {
            case BOOLEAN: {
                return new StructField(fieldName, DataTypes.BOOLEAN);
            }
            case INT: {
                if (logicalType instanceof LogicalTypes.Date) {
                    return new StructField(fieldName, DataTypes.DATE);
                }
                return new StructField(fieldName, DataTypes.INT);
            }
            case LONG: {
                if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros) {
                    return new StructField(fieldName, DataTypes.TIMESTAMP);
                }
                return new StructField(fieldName, DataTypes.LONG);
            }
            case DOUBLE: {
                return new StructField(fieldName, DataTypes.DOUBLE);
            }
            case STRING: 
            case ENUM: {
                return new StructField(fieldName, DataTypes.STRING);
            }
            case FLOAT: {
                return new StructField(fieldName, DataTypes.FLOAT);
            }
            case MAP: {
                ArrayList<StructField> keyValueFields = new ArrayList<StructField>();
                StructField keyField = new StructField(fieldName + ".key", DataTypes.STRING);
                StructField valueField = AvroCarbonWriter.prepareSubFields(fieldName + ".value", childSchema.getValueType());
                if (null != valueField) {
                    keyValueFields.add(keyField);
                    keyValueFields.add(valueField);
                    StructField mapKeyValueField = new StructField(fieldName + ".val", (DataType)DataTypes.createStructType(keyValueFields));
                    MapType mapType = DataTypes.createMapType((DataType)DataTypes.STRING, (DataType)mapKeyValueField.getDataType());
                    ArrayList<StructField> mapStructFields = new ArrayList<StructField>();
                    mapStructFields.add(mapKeyValueField);
                    return new StructField(fieldName, (DataType)mapType, mapStructFields);
                }
                return null;
            }
            case RECORD: {
                ArrayList<StructField> structSubFields = new ArrayList<StructField>();
                for (Schema.Field avroSubField : childSchema.getFields()) {
                    StructField structField = AvroCarbonWriter.prepareSubFields(avroSubField.name(), avroSubField.schema());
                    if (structField == null) continue;
                    structSubFields.add(structField);
                }
                return new StructField(fieldName, (DataType)DataTypes.createStructType(structSubFields));
            }
            case ARRAY: {
                DataType subType = AvroCarbonWriter.getMappingDataTypeForCollectionRecord(fieldName, childSchema.getElementType());
                if (subType != null) {
                    return new StructField(fieldName, (DataType)DataTypes.createArrayType((DataType)subType));
                }
                return null;
            }
            case UNION: {
                int i = 0;
                ArrayList<StructField> structSubTypes = new ArrayList<StructField>();
                for (org.apache.avro.Schema avroSubField : childSchema.getTypes()) {
                    StructField structField = AvroCarbonWriter.prepareSubFields(fieldName + i++, avroSubField);
                    if (structField == null) continue;
                    structSubTypes.add(structField);
                }
                return new StructField(fieldName, (DataType)DataTypes.createStructType(structSubTypes));
            }
            case BYTES: {
                if (logicalType instanceof LogicalTypes.Decimal) {
                    int precision = ((LogicalTypes.Decimal)childSchema.getLogicalType()).getPrecision();
                    int scale = ((LogicalTypes.Decimal)childSchema.getLogicalType()).getScale();
                    return new StructField(fieldName, (DataType)DataTypes.createDecimalType((int)precision, (int)scale));
                }
                throw new UnsupportedOperationException("carbon not support " + type.toString() + " avro type yet");
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("carbon not support " + type.toString() + " avro type yet");
    }

    private static DataType getMappingDataTypeForCollectionRecord(String fieldName, org.apache.avro.Schema childSchema) {
        LogicalType logicalType = childSchema.getLogicalType();
        switch (childSchema.getType()) {
            case BOOLEAN: {
                return DataTypes.BOOLEAN;
            }
            case INT: {
                if (logicalType != null) {
                    if (logicalType instanceof LogicalTypes.Date) {
                        return DataTypes.DATE;
                    }
                    return DataTypes.INT;
                }
                return DataTypes.INT;
            }
            case LONG: {
                if (logicalType != null) {
                    if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros) {
                        return DataTypes.TIMESTAMP;
                    }
                    return DataTypes.LONG;
                }
                return DataTypes.LONG;
            }
            case DOUBLE: {
                return DataTypes.DOUBLE;
            }
            case STRING: 
            case ENUM: {
                return DataTypes.STRING;
            }
            case FLOAT: {
                return DataTypes.FLOAT;
            }
            case MAP: {
                StructField mapField = AvroCarbonWriter.prepareSubFields(fieldName, childSchema);
                if (mapField != null) {
                    return mapField.getDataType();
                }
                return null;
            }
            case RECORD: {
                ArrayList<StructField> structSubFields = new ArrayList<StructField>();
                for (Schema.Field avroSubField : childSchema.getFields()) {
                    StructField structField = AvroCarbonWriter.prepareSubFields(avroSubField.name(), avroSubField.schema());
                    if (structField == null) continue;
                    structSubFields.add(structField);
                }
                return DataTypes.createStructType(structSubFields);
            }
            case ARRAY: {
                DataType subType = AvroCarbonWriter.getMappingDataTypeForCollectionRecord(fieldName, childSchema.getElementType());
                if (subType != null) {
                    return DataTypes.createArrayType((DataType)subType);
                }
                return null;
            }
            case UNION: {
                int i = 0;
                ArrayList<StructField> unionFields = new ArrayList<StructField>();
                for (org.apache.avro.Schema avroSubField : childSchema.getTypes()) {
                    StructField unionField = AvroCarbonWriter.prepareSubFields(avroSubField.getName() + i++, avroSubField);
                    if (unionField == null) continue;
                    unionFields.add(unionField);
                }
                return DataTypes.createStructType(unionFields);
            }
            case BYTES: {
                if (logicalType instanceof LogicalTypes.Decimal) {
                    int precision = ((LogicalTypes.Decimal)childSchema.getLogicalType()).getPrecision();
                    int scale = ((LogicalTypes.Decimal)childSchema.getLogicalType()).getScale();
                    return DataTypes.createDecimalType((int)precision, (int)scale);
                }
                throw new UnsupportedOperationException("carbon not support " + childSchema.getType().toString() + " avro type yet");
            }
            case NULL: {
                return null;
            }
        }
        throw new UnsupportedOperationException("carbon not support " + childSchema.getType().toString() + " avro type yet");
    }

    @Override
    public void write(Object object) throws IOException {
        try {
            GenericData.Record record = (GenericData.Record)object;
            Object[] csvRecord = this.avroToCsv(record);
            this.writable.set(csvRecord);
            this.recordWriter.write((Object)NullWritable.get(), (Object)this.writable);
        }
        catch (Exception e) {
            this.close();
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.recordWriter.close(this.context);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

