/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file.utils;

import java.util.ArrayList;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.hadoop.conf.Configuration;

public class SDKUtil {
    public static ArrayList listFiles(String sourceImageFolder, String suf) throws Exception {
        return SDKUtil.listFiles(sourceImageFolder, suf, new Configuration(true));
    }

    public static ArrayList listFiles(String sourceImageFolder, String suf, Configuration conf) throws Exception {
        String sufImageFinal = suf;
        ArrayList<String> result = new ArrayList<String>();
        CarbonFile[] fileList = FileFactory.getCarbonFile((String)sourceImageFolder).listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].isDirectory()) {
                result.addAll(SDKUtil.listFiles(fileList[i].getCanonicalPath(), sufImageFinal, conf));
                continue;
            }
            if (!fileList[i].getCanonicalPath().endsWith(sufImageFinal)) continue;
            result.add(fileList[i].getCanonicalPath());
        }
        return result;
    }

    public static Object[] getSplitList(String path, String suf, int numOfSplit, Configuration conf) throws Exception {
        ArrayList fileList = SDKUtil.listFiles(path, suf, conf);
        ArrayList splitList = new ArrayList();
        if (numOfSplit < fileList.size()) {
            float filesPerSplit = (float)fileList.size() / (float)numOfSplit;
            for (int i = 0; i < numOfSplit; ++i) {
                splitList.add(fileList.subList((int)Math.ceil((float)i * filesPerSplit), (int)Math.ceil((float)(i + 1) * filesPerSplit)));
            }
        } else {
            for (int i = 0; i < fileList.size(); ++i) {
                splitList.add(fileList.subList(i, i + 1));
            }
        }
        return splitList.toArray();
    }

    public static Object[] getSplitList(String path, String suf, int numOfSplit) throws Exception {
        return SDKUtil.getSplitList(path, suf, numOfSplit, new Configuration());
    }
}

