/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.util.List;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.carbondata.sdk.file.arrow.ArrowConverter;
import org.apache.hadoop.mapreduce.RecordReader;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class ArrowCarbonReader<T>
extends CarbonReader<T> {
    ArrowCarbonReader(List<RecordReader<Void, T>> readers) {
        super(readers);
    }

    public byte[] readArrowBatch(Schema carbonSchema) throws Exception {
        ArrowConverter arrowConverter = new ArrowConverter(carbonSchema, 0);
        while (this.hasNext()) {
            arrowConverter.addToArrowBuffer(this.readNextBatchRow());
        }
        return arrowConverter.toSerializeArray();
    }

    public VectorSchemaRoot readArrowVectors(Schema carbonSchema) throws Exception {
        ArrowConverter arrowConverter = new ArrowConverter(carbonSchema, 0);
        while (this.hasNext()) {
            arrowConverter.addToArrowBuffer(this.readNextBatchRow());
        }
        return arrowConverter.getArrowVectors();
    }

    public long readArrowBatchAddress(Schema carbonSchema) throws Exception {
        ArrowConverter arrowConverter = new ArrowConverter(carbonSchema, 0);
        while (this.hasNext()) {
            arrowConverter.addToArrowBuffer(this.readNextBatchRow());
        }
        return arrowConverter.copySerializeArrayToOffHeap();
    }

    public void freeArrowBatchMemory(long address) {
        CarbonUnsafe.getUnsafe().freeMemory(address);
    }
}

