/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.hadoop.CarbonRecordReader;
import org.apache.carbondata.hadoop.util.CarbonVectorizedRecordReader;
import org.apache.carbondata.sdk.file.CarbonReaderBuilder;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;

@InterfaceAudience.User
@InterfaceStability.Evolving
public class CarbonReader<T> {
    private List<RecordReader<Void, T>> readers;
    private RecordReader<Void, T> currentReader;
    private int index;
    private boolean initialise;
    private Object[] batchRows;

    CarbonReader(List<RecordReader<Void, T>> readers) {
        if (readers.size() == 0) {
            throw new IllegalArgumentException("no reader");
        }
        this.initialise = true;
        this.readers = readers;
        this.index = 0;
        this.currentReader = readers.get(0);
    }

    public boolean hasNext() throws IOException, InterruptedException {
        this.validateReader();
        if (this.currentReader.nextKeyValue()) {
            return true;
        }
        if (this.index == this.readers.size() - 1) {
            return false;
        }
        this.currentReader.close();
        this.readers.set(this.index, null);
        ++this.index;
        this.currentReader = this.readers.get(this.index);
        return this.currentReader.nextKeyValue();
    }

    public T readNextRow() throws IOException, InterruptedException {
        this.validateReader();
        return (T)this.currentReader.getCurrentValue();
    }

    public Object[] readNextBatchRow() throws Exception {
        this.validateReader();
        if (this.currentReader instanceof CarbonRecordReader) {
            List batchValue = ((CarbonRecordReader)this.currentReader).getBatchValue();
            if (batchValue == null) {
                return null;
            }
            return batchValue.toArray();
        }
        if (this.currentReader instanceof CarbonVectorizedRecordReader) {
            int batch = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.detail.batch.size", String.valueOf(100)));
            this.batchRows = new Object[batch];
            int sum = 0;
            for (int i = 0; i < batch; ++i) {
                this.batchRows[i] = this.currentReader.getCurrentValue();
                ++sum;
                if (i == batch - 1 || this.hasNext()) continue;
                Object[] lessBatch = new Object[sum];
                for (int j = 0; j < sum; ++j) {
                    lessBatch[j] = this.batchRows[j];
                }
                return lessBatch;
            }
            return this.batchRows;
        }
        throw new Exception("Didn't support read next batch row by this reader.");
    }

    public static CarbonReaderBuilder builder(String tablePath, String tableName) {
        return new CarbonReaderBuilder(tablePath, tableName);
    }

    public static CarbonReaderBuilder builder(InputSplit inputSplit) {
        return new CarbonReaderBuilder(inputSplit);
    }

    public static CarbonReaderBuilder builder(String tablePath) {
        UUID uuid = UUID.randomUUID();
        String tableName = "UnknownTable" + uuid;
        return CarbonReader.builder(tablePath, tableName);
    }

    public static CarbonReaderBuilder builder() {
        UUID uuid = UUID.randomUUID();
        String tableName = "UnknownTable" + uuid;
        return new CarbonReaderBuilder(tableName);
    }

    public List<CarbonReader> split(int maxSplits) throws IOException {
        this.validateReader();
        if (maxSplits < 1) {
            throw new RuntimeException(this.getClass().getSimpleName() + ".split: maxSplits must be positive");
        }
        ArrayList<CarbonReader> carbonReaders = new ArrayList<CarbonReader>();
        if (maxSplits < this.readers.size()) {
            float filesPerSplit = (float)this.readers.size() / (float)maxSplits;
            for (int i = 0; i < maxSplits; ++i) {
                carbonReaders.add(new CarbonReader<T>(this.readers.subList((int)Math.ceil((float)i * filesPerSplit), (int)Math.ceil((float)(i + 1) * filesPerSplit))));
            }
        } else {
            for (int i = 0; i < this.readers.size(); ++i) {
                carbonReaders.add(new CarbonReader<T>(this.readers.subList(i, i + 1)));
            }
        }
        this.initialise = false;
        return carbonReaders;
    }

    public void close() throws IOException {
        this.validateReader();
        CarbonProperties.getInstance().addProperty("carbon.detail.batch.size", String.valueOf(100));
        this.currentReader.close();
        this.initialise = false;
    }

    private void validateReader() {
        if (!this.initialise) {
            throw new RuntimeException(this.getClass().getSimpleName() + " not initialise, please create it first.");
        }
    }
}

