/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.sdk.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.annotations.InterfaceStability;
import org.apache.carbondata.common.constants.LoggerAction;
import org.apache.carbondata.common.exceptions.sql.InvalidLoadOptionException;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.datatype.ArrayType;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.MapType;
import org.apache.carbondata.core.metadata.datatype.StructField;
import org.apache.carbondata.core.metadata.datatype.StructType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.TableSchema;
import org.apache.carbondata.core.metadata.schema.table.TableSchemaBuilder;
import org.apache.carbondata.core.metadata.schema.table.column.ColumnSchema;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.model.CarbonLoadModelBuilder;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.carbondata.sdk.file.AvroCarbonWriter;
import org.apache.carbondata.sdk.file.CSVCarbonWriter;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.Field;
import org.apache.carbondata.sdk.file.JsonCarbonWriter;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.User
@InterfaceStability.Unstable
public class CarbonWriterBuilder {
    private Schema schema;
    private String path;
    private String[] sortColumns = new String[0];
    private int blockletSize;
    private int pageSizeInMb;
    private int blockSize;
    private long timestamp;
    private Map<String, String> options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private String taskNo;
    private int localDictionaryThreshold;
    private boolean isLocalDictionaryEnabled = Boolean.parseBoolean("true");
    private short numOfThreads;
    private Configuration hadoopConf;
    private String writtenByApp;
    private String[] invertedIndexColumns;
    private WRITER_TYPE writerType;

    public CarbonWriterBuilder outputPath(String path) {
        Objects.requireNonNull(path, "path should not be null");
        this.path = path;
        return this;
    }

    public CarbonWriterBuilder sortBy(String[] sortColumns) {
        if (sortColumns != null) {
            for (int i = 0; i < sortColumns.length; ++i) {
                sortColumns[i] = sortColumns[i].toLowerCase().trim();
            }
        }
        this.sortColumns = sortColumns;
        return this;
    }

    public CarbonWriterBuilder invertedIndexFor(String[] invertedIndexColumns) {
        if (invertedIndexColumns != null) {
            for (int i = 0; i < invertedIndexColumns.length; ++i) {
                invertedIndexColumns[i] = invertedIndexColumns[i].toLowerCase().trim();
            }
        }
        this.invertedIndexColumns = invertedIndexColumns;
        return this;
    }

    public CarbonWriterBuilder taskNo(long taskNo) {
        this.taskNo = String.valueOf(taskNo);
        return this;
    }

    public CarbonWriterBuilder uniqueIdentifier(long timestamp) {
        Objects.requireNonNull(Long.valueOf(timestamp), "Unique Identifier should not be null");
        this.timestamp = timestamp;
        return this;
    }

    public CarbonWriterBuilder withLoadOptions(Map<String, String> options) {
        Objects.requireNonNull(options, "Load options should not be null");
        for (String string : options.keySet()) {
            if (string.equalsIgnoreCase("bad_records_logger_enable") || string.equalsIgnoreCase("bad_records_action") || string.equalsIgnoreCase("bad_record_path") || string.equalsIgnoreCase("dateformat") || string.equalsIgnoreCase("timestampformat") || string.equalsIgnoreCase("complex_delimiter_level_1") || string.equalsIgnoreCase("complex_delimiter_level_2") || string.equalsIgnoreCase("complex_delimiter_level_3") || string.equalsIgnoreCase("quotechar") || string.equalsIgnoreCase("escapechar") || string.equalsIgnoreCase("binary_decoder")) continue;
            throw new IllegalArgumentException("Unsupported option:" + string + ". Refer method header or documentation");
        }
        for (Map.Entry entry : options.entrySet()) {
            String binaryDecoderChar;
            if (((String)entry.getKey()).equalsIgnoreCase("bad_records_action")) {
                try {
                    LoggerAction.valueOf((String)((String)entry.getValue()).toUpperCase());
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("option BAD_RECORDS_ACTION can have only either FORCE or IGNORE or REDIRECT or FAIL. It shouldn't be " + (String)entry.getValue());
                }
            }
            if (((String)entry.getKey()).equalsIgnoreCase("bad_records_logger_enable")) {
                boolean isValid = CarbonUtil.validateBoolean((String)((String)entry.getValue()));
                if (isValid) continue;
                throw new IllegalArgumentException("Invalid value " + (String)entry.getValue() + " for key " + (String)entry.getKey());
            }
            if (((String)entry.getKey()).equalsIgnoreCase("quotechar")) {
                String quoteChar = (String)entry.getValue();
                if (quoteChar.length() <= 1) continue;
                throw new IllegalArgumentException("QUOTECHAR cannot be more than one character.");
            }
            if (((String)entry.getKey()).equalsIgnoreCase("escapechar")) {
                String escapeChar = (String)entry.getValue();
                if (escapeChar.length() <= 1 || CarbonLoaderUtil.isValidEscapeSequence((String)escapeChar)) continue;
                throw new IllegalArgumentException("ESCAPECHAR cannot be more than one character.");
            }
            if (!((String)entry.getKey()).toLowerCase().equalsIgnoreCase("binary_decoder") || (binaryDecoderChar = (String)entry.getValue()).length() <= 1 || CarbonLoaderUtil.isValidBinaryDecoder((String)binaryDecoderChar)) continue;
            throw new IllegalArgumentException("Binary decoder only support Base64, Hex or no decode for string, don't support " + binaryDecoderChar);
        }
        this.options.putAll(options);
        return this;
    }

    public CarbonWriterBuilder withLoadOption(String key, String value) {
        Objects.requireNonNull(key, "key of load properties should not be null");
        Objects.requireNonNull(key, "value of load properties should not be null");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.withLoadOptions(map);
        return this;
    }

    public CarbonWriterBuilder withTableProperties(Map<String, String> options) {
        Objects.requireNonNull(options, "Table properties should not be null");
        HashSet<String> supportedOptions = new HashSet<String>(Arrays.asList("table_blocksize", "table_blocklet_size", "local_dictionary_threshold", "local_dictionary_enable", "sort_columns", "sort_scope", "long_string_columns", "inverted_index", "table_page_size_inmb"));
        for (String string : options.keySet()) {
            if (supportedOptions.contains(string.toLowerCase())) continue;
            throw new IllegalArgumentException("Unsupported options. Refer method header or documentation");
        }
        for (Map.Entry entry : options.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("table_blocksize")) {
                this.withBlockSize(Integer.parseInt((String)entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("table_blocklet_size")) {
                this.withBlockletSize(Integer.parseInt((String)entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("local_dictionary_threshold")) {
                this.localDictionaryThreshold(Integer.parseInt((String)entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("local_dictionary_enable")) {
                this.enableLocalDictionary(((String)entry.getValue()).equalsIgnoreCase("true"));
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("sort_columns")) {
                String[] sortColumns = ((String)entry.getValue()).trim().isEmpty() ? new String[]{} : ((String)entry.getValue()).split(",");
                this.sortBy(sortColumns);
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("sort_scope")) {
                this.withSortScope(entry);
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("long_string_columns")) {
                this.updateToLoadOptions(entry);
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("inverted_index")) {
                String[] invertedIndexColumns = ((String)entry.getValue()).trim().isEmpty() ? new String[]{} : ((String)entry.getValue()).split(",");
                this.invertedIndexFor(invertedIndexColumns);
                continue;
            }
            if (!((String)entry.getKey()).equalsIgnoreCase("table_page_size_inmb")) continue;
            this.withPageSizeInMb(Integer.parseInt((String)entry.getValue()));
        }
        return this;
    }

    public CarbonWriterBuilder withTableProperty(String key, String value) {
        Objects.requireNonNull(key, "key of table properties should not be null");
        Objects.requireNonNull(key, "value of table properties  should not be null");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.withTableProperties(map);
        return this;
    }

    public CarbonWriterBuilder withThreadSafe(short numOfThreads) {
        if (numOfThreads < 1) {
            throw new IllegalArgumentException("number of threads cannot be lesser than 1. suggest to keep two times the number of cores available");
        }
        this.numOfThreads = numOfThreads;
        return this;
    }

    public CarbonWriterBuilder withHadoopConf(Configuration conf) {
        if (conf != null) {
            this.hadoopConf = conf;
        }
        return this;
    }

    public CarbonWriterBuilder withHadoopConf(String key, String value) {
        if (this.hadoopConf == null) {
            this.hadoopConf = new Configuration(true);
        }
        this.hadoopConf.set(key, value);
        return this;
    }

    public CarbonWriterBuilder withBlockSize(int blockSize) {
        if (blockSize <= 0 || blockSize > 2048) {
            throw new IllegalArgumentException("blockSize should be between 1 MB to 2048 MB");
        }
        this.blockSize = blockSize;
        return this;
    }

    public CarbonWriterBuilder localDictionaryThreshold(int localDictionaryThreshold) {
        if (localDictionaryThreshold <= 0) {
            throw new IllegalArgumentException("Local Dictionary Threshold should be greater than 0");
        }
        this.localDictionaryThreshold = localDictionaryThreshold;
        return this;
    }

    public CarbonWriterBuilder writtenBy(String appName) {
        this.writtenByApp = appName;
        return this;
    }

    public CarbonWriterBuilder enableLocalDictionary(boolean enableLocalDictionary) {
        this.isLocalDictionaryEnabled = enableLocalDictionary;
        return this;
    }

    public CarbonWriterBuilder withBlockletSize(int blockletSize) {
        if (blockletSize <= 0) {
            throw new IllegalArgumentException("blockletSize should be greater than zero");
        }
        this.blockletSize = blockletSize;
        return this;
    }

    public CarbonWriterBuilder withPageSizeInMb(int pageSizeInMb) {
        if (pageSizeInMb < 1 || pageSizeInMb > 1755) {
            throw new IllegalArgumentException("pageSizeInMb must be 1 MB - 1755 MB");
        }
        this.pageSizeInMb = pageSizeInMb;
        return this;
    }

    public CarbonWriterBuilder withCsvInput(Schema schema) {
        Objects.requireNonNull(schema, "schema should not be null");
        this.schema = schema;
        this.writerType = WRITER_TYPE.CSV;
        return this;
    }

    public CarbonWriterBuilder withCsvInput(String jsonSchema) {
        Objects.requireNonNull(jsonSchema, "schema should not be null");
        this.schema = Schema.parseJson(jsonSchema);
        this.writerType = WRITER_TYPE.CSV;
        return this;
    }

    public CarbonWriterBuilder withAvroInput(org.apache.avro.Schema avroSchema) {
        Objects.requireNonNull(avroSchema, "Avro schema should not be null");
        this.schema = AvroCarbonWriter.getCarbonSchemaFromAvroSchema(avroSchema);
        this.writerType = WRITER_TYPE.AVRO;
        return this;
    }

    public CarbonWriterBuilder withJsonInput(Schema carbonSchema) {
        Objects.requireNonNull(carbonSchema, "schema should not be null");
        this.schema = carbonSchema;
        this.writerType = WRITER_TYPE.JSON;
        return this;
    }

    public CarbonWriter build() throws IOException, InvalidLoadOptionException {
        Objects.requireNonNull(this.path, "path should not be null");
        if (this.writerType == null) {
            throw new IOException("'writerType' must be set, use withCsvInput() or withAvroInput() or withJsonInput()  API based on input");
        }
        if (this.writtenByApp == null || this.writtenByApp.isEmpty()) {
            throw new RuntimeException("'writtenBy' must be set when writing carbon files, use writtenBy() API to set it, it can be the name of the application which is using the SDK");
        }
        CarbonLoadModel loadModel = this.buildLoadModel(this.schema);
        loadModel.setSdkWriterCores(this.numOfThreads);
        CarbonProperties.getInstance().addProperty("carbon.writtenby.app.name", this.writtenByApp);
        if (this.hadoopConf == null) {
            this.hadoopConf = FileFactory.getConfiguration();
        }
        if (this.writerType == WRITER_TYPE.AVRO) {
            loadModel.setLoadWithoutConverterStep(true);
            return new AvroCarbonWriter(loadModel, this.hadoopConf);
        }
        if (this.writerType == WRITER_TYPE.JSON) {
            loadModel.setJsonFileLoad(true);
            return new JsonCarbonWriter(loadModel, this.hadoopConf);
        }
        return new CSVCarbonWriter(loadModel, this.hadoopConf);
    }

    private void setCsvHeader(CarbonLoadModel model) {
        Field[] fields = this.schema.getFields();
        StringBuilder builder = new StringBuilder();
        String[] columns = new String[fields.length];
        int i = 0;
        for (Field field : fields) {
            if (null == field) continue;
            builder.append(field.getFieldName());
            builder.append(",");
            columns[i++] = field.getFieldName();
        }
        String header = builder.toString();
        model.setCsvHeader(header.substring(0, header.length() - 1));
        model.setCsvHeaderColumns(columns);
    }

    public CarbonLoadModel buildLoadModel(Schema carbonSchema) throws IOException, InvalidLoadOptionException {
        this.timestamp = System.nanoTime();
        HashSet<String> longStringColumns = new HashSet<String>();
        if (this.options != null && this.options.get("long_string_columns") != null) {
            String[] specifiedLongStrings;
            for (String str : specifiedLongStrings = this.options.get("long_string_columns").toLowerCase().split(",")) {
                longStringColumns.add(str.trim());
            }
            this.validateLongStringColumns(carbonSchema, longStringColumns);
        }
        this.schema = this.updateSchemaFields(carbonSchema, longStringColumns);
        if (this.sortColumns != null && this.sortColumns.length != 0 && (this.options == null || this.options.get("sort_scope") == null) && CarbonProperties.getInstance().getProperty("carbon.load.sort.scope") == null) {
            if (this.options == null) {
                this.options = new HashMap<String, String>();
            }
            this.options.put("sort_scope", "local_sort");
        }
        CarbonTable table = this.buildCarbonTable();
        return this.buildLoadModel(table, this.timestamp, this.taskNo, this.options);
    }

    private void validateLongStringColumns(Schema carbonSchema, Set<String> longStringColumns) {
        for (Field field : carbonSchema.getFields()) {
            if (!longStringColumns.contains(field.getFieldName().toLowerCase()) || field.getDataType() == DataTypes.STRING || field.getDataType() == DataTypes.VARCHAR) continue;
            throw new RuntimeException("long string column : " + field.getFieldName() + " is not supported for data type: " + field.getDataType());
        }
        if (this.sortColumns != null) {
            for (String col : this.sortColumns) {
                if (!longStringColumns.contains(col)) continue;
                throw new RuntimeException("long string column : " + (String)col + "must not be present in sort columns");
            }
        }
    }

    private CarbonTable buildCarbonTable() {
        TableSchemaBuilder tableSchemaBuilder = TableSchema.builder();
        if (this.blockSize > 0) {
            tableSchemaBuilder = tableSchemaBuilder.blockSize(this.blockSize);
        }
        if (this.blockletSize > 0) {
            tableSchemaBuilder = tableSchemaBuilder.blockletSize(this.blockletSize);
        }
        if (this.pageSizeInMb > 0) {
            tableSchemaBuilder = tableSchemaBuilder.pageSizeInMb(this.pageSizeInMb);
        }
        tableSchemaBuilder.enableLocalDictionary(this.isLocalDictionaryEnabled);
        tableSchemaBuilder.localDictionaryThreshold(this.localDictionaryThreshold);
        List<Object> sortColumnsList = new ArrayList();
        if (this.sortColumns == null) {
            for (Field field : this.schema.getFields()) {
                if (null == field || field.getDataType() != DataTypes.STRING && field.getDataType() != DataTypes.DATE && field.getDataType() != DataTypes.TIMESTAMP) continue;
                sortColumnsList.add(field.getFieldName());
            }
            this.sortColumns = new String[sortColumnsList.size()];
            this.sortColumns = sortColumnsList.toArray(this.sortColumns);
        } else {
            sortColumnsList = Arrays.asList(this.sortColumns);
        }
        ColumnSchema[] sortColumnsSchemaList = new ColumnSchema[sortColumnsList.size()];
        ArrayList<String> invertedIdxColumnsList = new ArrayList();
        if (null != this.invertedIndexColumns) {
            invertedIdxColumnsList = Arrays.asList(this.invertedIndexColumns);
        }
        Field[] fields = this.schema.getFields();
        this.buildTableSchema(fields, tableSchemaBuilder, sortColumnsList, sortColumnsSchemaList, invertedIdxColumnsList);
        tableSchemaBuilder.setSortColumns(Arrays.asList(sortColumnsSchemaList));
        String dbName = "";
        String tableName = "_tempTable_" + String.valueOf(this.timestamp);
        TableSchema schema = tableSchemaBuilder.build();
        schema.setTableName(tableName);
        CarbonTable table = CarbonTable.builder().tableName(schema.getTableName()).databaseName(dbName).tablePath(this.path).tableSchema(schema).isTransactionalTable(false).build();
        return table;
    }

    private void buildTableSchema(Field[] fields, TableSchemaBuilder tableSchemaBuilder, List<String> sortColumnsList, ColumnSchema[] sortColumnsSchemaList, List<String> invertedIdxColumnsList) {
        boolean exists;
        HashSet<String> uniqueFields = new HashSet<String>();
        AtomicInteger valIndex = new AtomicInteger(0);
        for (String sortColumn : sortColumnsList) {
            exists = false;
            for (Field field : fields) {
                if (!field.getFieldName().equalsIgnoreCase(sortColumn)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            throw new RuntimeException("column: " + sortColumn + " specified in sort columns does not exist in schema");
        }
        for (String invertedIdxColumn : invertedIdxColumnsList) {
            exists = false;
            for (Field field : fields) {
                if (!field.getFieldName().equalsIgnoreCase(invertedIdxColumn)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            throw new RuntimeException("column: " + invertedIdxColumn + " specified in inverted index columns does not exist in schema");
        }
        boolean i = false;
        for (Field field : fields) {
            if (null == field) continue;
            if (!uniqueFields.add(field.getFieldName())) {
                throw new RuntimeException("Duplicate column " + field.getFieldName() + " found in table schema");
            }
            int isSortColumn = sortColumnsList.indexOf(field.getFieldName());
            int isInvertedIdxColumn = invertedIdxColumnsList.indexOf(field.getFieldName());
            if (isSortColumn > -1 && (field.getDataType() == DataTypes.DOUBLE || field.getDataType() == DataTypes.FLOAT || DataTypes.isDecimal((DataType)field.getDataType()) || field.getDataType().isComplexType() || field.getDataType() == DataTypes.VARCHAR || field.getDataType() == DataTypes.BINARY)) {
                String errorMsg = "sort columns not supported for array, struct, map, double, float, decimal, varchar, binary";
                throw new RuntimeException(errorMsg);
            }
            if (field.getChildren() != null && field.getChildren().size() > 0) {
                if (field.getDataType().getName().equalsIgnoreCase("ARRAY")) {
                    ArrayType complexType = DataTypes.createArrayType((DataType)field.getChildren().get(0).getDataType());
                    tableSchemaBuilder.addColumn(new StructField(field.getFieldName(), (DataType)complexType), valIndex, false, isInvertedIdxColumn > -1);
                    continue;
                }
                if (field.getDataType().getName().equalsIgnoreCase("STRUCT")) {
                    ArrayList<StructField> structFieldsArray = new ArrayList<StructField>(field.getChildren().size());
                    for (StructField childFld : field.getChildren()) {
                        structFieldsArray.add(new StructField(childFld.getFieldName(), childFld.getDataType()));
                    }
                    StructType complexType = DataTypes.createStructType(structFieldsArray);
                    tableSchemaBuilder.addColumn(new StructField(field.getFieldName(), (DataType)complexType), valIndex, false, isInvertedIdxColumn > -1);
                    continue;
                }
                if (!field.getDataType().getName().equalsIgnoreCase("MAP")) continue;
                MapType mapType = DataTypes.createMapType((DataType)((MapType)field.getDataType()).getKeyType(), (DataType)field.getChildren().get(0).getDataType());
                tableSchemaBuilder.addColumn(new StructField(field.getFieldName(), (DataType)mapType), valIndex, false, isInvertedIdxColumn > -1);
                continue;
            }
            ColumnSchema columnSchema = tableSchemaBuilder.addColumn(new StructField(field.getFieldName(), field.getDataType()), valIndex, isSortColumn > -1, isInvertedIdxColumn > -1);
            if (isSortColumn <= -1) continue;
            columnSchema.setSortColumn(true);
            sortColumnsSchemaList[isSortColumn] = columnSchema;
        }
    }

    private CarbonLoadModel buildLoadModel(CarbonTable table, long timestamp, String taskNo, Map<String, String> options) throws InvalidLoadOptionException, IOException {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        CarbonLoadModelBuilder builder = new CarbonLoadModelBuilder(table);
        CarbonLoadModel build = builder.build(options, timestamp, taskNo);
        this.setCsvHeader(build);
        return build;
    }

    private Schema updateSchemaFields(Schema schema, Set<String> longStringColumns) {
        if (schema == null) {
            return null;
        }
        Field[] fields = schema.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null || longStringColumns == null || !longStringColumns.contains(fields[i].getFieldName())) continue;
            fields[i].updateDataTypeToVarchar();
        }
        return new Schema(fields);
    }

    private void updateToLoadOptions(Map.Entry<String, String> entry) {
        if (this.options == null) {
            this.options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.options.put(entry.getKey(), entry.getValue());
    }

    private void withSortScope(Map.Entry<String, String> entry) {
        String sortScope = entry.getValue();
        if (sortScope != null) {
            if (!CarbonUtil.isValidSortOption((String)sortScope)) {
                throw new IllegalArgumentException("Invalid Sort Scope Option: " + sortScope);
            }
            if (sortScope.equalsIgnoreCase("global_sort")) {
                throw new IllegalArgumentException("global sort is not supported");
            }
        }
        this.updateToLoadOptions(entry);
    }

    private static enum WRITER_TYPE {
        CSV,
        AVRO,
        JSON;

    }
}

