/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.streaming.parser;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.util.SparkStreamingUtil$;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;

public final class FieldConverter$ {
    public static FieldConverter$ MODULE$;

    static {
        new FieldConverter$();
    }

    public String objectToString(Object value, String serializationNullFormat, ArrayList<String> complexDelimiters, SimpleDateFormat timeStampFormat, SimpleDateFormat dateFormat, boolean isVarcharType, boolean isComplexType, int level, String binaryCodec) {
        String string;
        if (value == null) {
            string = serializationNullFormat;
        } else {
            String string2;
            Object object = value;
            if (object instanceof String) {
                String string3 = (String)object;
                if (!(isVarcharType || isComplexType || string3.length() <= 32000 || Predef$.MODULE$.Boolean2boolean(CarbonProperties.isBadRecordHandlingEnabledForInsert()))) {
                    throw new IllegalArgumentException("Record of column %s exceeded 32000 characters. Please consider long string data type.");
                }
                string2 = string3;
            } else if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                string2 = bigDecimal.toPlainString();
            } else if (object instanceof Integer) {
                Integer n = (Integer)object;
                string2 = n.toString();
            } else if (object instanceof Double) {
                Double d = (Double)object;
                string2 = d.toString();
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                string2 = timeStampFormat.format(timestamp);
            } else if (object instanceof Date) {
                Date date = (Date)object;
                string2 = dateFormat.format(date);
            } else if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                string2 = bl.toString();
            } else if (object instanceof Short) {
                Short s = (Short)object;
                string2 = s.toString();
            } else if (object instanceof Float) {
                Float f = (Float)object;
                string2 = f.toString();
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                string2 = "base64".equalsIgnoreCase(binaryCodec) ? Base64.getEncoder().encodeToString(byArray) : new String(byArray, Charset.forName("UTF-8"));
            } else if (object instanceof Seq) {
                String string4;
                Seq seq = (Seq)object;
                if (seq.nonEmpty()) {
                    String delimiter = complexDelimiters.get(level);
                    StringBuilder builder = new StringBuilder();
                    seq.foreach((Function1 & Serializable & scala.Serializable)x -> {
                        int nextLevel = level + 1;
                        Object x$1 = x;
                        String x$2 = serializationNullFormat;
                        ArrayList x$3 = complexDelimiters;
                        SimpleDateFormat x$4 = timeStampFormat;
                        SimpleDateFormat x$5 = dateFormat;
                        boolean x$6 = isVarcharType;
                        int x$7 = nextLevel;
                        String x$8 = binaryCodec;
                        boolean x$9 = MODULE$.objectToString$default$7();
                        return builder.append(MODULE$.objectToString(x$1, x$2, x$3, x$4, x$5, x$6, x$9, x$7, x$8)).append(delimiter);
                    });
                    string4 = builder.substring(0, builder.length() - delimiter.length());
                } else {
                    string4 = "!LENGTH_ZERO_DATA_RETURN!";
                }
                string2 = string4;
            } else if (object instanceof Map) {
                String string5;
                Map map = (Map)object;
                if (map.nonEmpty()) {
                    int nextLevel = level + 2;
                    String delimiter = complexDelimiters.get(level);
                    String keyValueDelimiter = complexDelimiters.get(level + 1);
                    StringBuilder builder = new StringBuilder();
                    map.foreach((Function1 & Serializable & scala.Serializable)x -> {
                        Object x$10 = x._1();
                        String x$11 = serializationNullFormat;
                        ArrayList x$12 = complexDelimiters;
                        SimpleDateFormat x$13 = timeStampFormat;
                        SimpleDateFormat x$14 = dateFormat;
                        boolean x$15 = isVarcharType;
                        int x$16 = nextLevel;
                        String x$17 = binaryCodec;
                        boolean x$18 = MODULE$.objectToString$default$7();
                        builder.append(MODULE$.objectToString(x$10, x$11, x$12, x$13, x$14, x$15, x$18, x$16, x$17)).append(keyValueDelimiter);
                        Object x$19 = x._2();
                        String x$20 = serializationNullFormat;
                        ArrayList x$21 = complexDelimiters;
                        SimpleDateFormat x$22 = timeStampFormat;
                        SimpleDateFormat x$23 = dateFormat;
                        boolean x$24 = isVarcharType;
                        int x$25 = nextLevel;
                        String x$26 = binaryCodec;
                        boolean x$27 = MODULE$.objectToString$default$7();
                        return builder.append(MODULE$.objectToString(x$19, x$20, x$21, x$22, x$23, x$24, x$27, x$25, x$26)).append(delimiter);
                    });
                    string5 = builder.substring(0, builder.length() - delimiter.length());
                } else {
                    string5 = "!LENGTH_ZERO_DATA_RETURN!";
                }
                string2 = string5;
            } else if (object instanceof Row) {
                Row row = (Row)object;
                String delimiter = complexDelimiters.get(level);
                StringBuilder builder = new StringBuilder();
                int len = row.length();
                for (int i = 0; i < len; ++i) {
                    int nextLevel = level + 1;
                    Object x$28 = row.apply(i);
                    String x$29 = serializationNullFormat;
                    ArrayList<String> x$30 = complexDelimiters;
                    SimpleDateFormat x$31 = timeStampFormat;
                    SimpleDateFormat x$32 = dateFormat;
                    boolean x$33 = isVarcharType;
                    int x$34 = nextLevel;
                    String x$35 = binaryCodec;
                    boolean x$36 = this.objectToString$default$7();
                    builder.append(this.objectToString(x$28, x$29, x$30, x$31, x$32, x$33, x$36, x$34, x$35)).append(delimiter);
                }
                string2 = builder.substring(0, builder.length() - delimiter.length());
            } else {
                string2 = SparkStreamingUtil$.MODULE$.checkInstant(object, timeStampFormat);
            }
            string = string2;
        }
        return string;
    }

    public boolean objectToString$default$6() {
        return false;
    }

    public boolean objectToString$default$7() {
        return false;
    }

    public int objectToString$default$8() {
        return 0;
    }

    private FieldConverter$() {
        MODULE$ = this;
    }
}

