/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.streaming.segment;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.datastore.page.statistics.SimpleStatsResult;
import org.apache.carbondata.core.locks.CarbonLockFactory;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.blocklet.index.BlockletMinMaxIndex;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.reader.CarbonIndexFileReader;
import org.apache.carbondata.core.statusmanager.FileFormat;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonMetadataUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.CarbonIndexFileWriter;
import org.apache.carbondata.format.BlockIndex;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.streaming.CarbonStreamRecordWriter;
import org.apache.carbondata.streaming.index.StreamFileIndex;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class StreamSegment {
    private static final Logger LOGGER = LogServiceFactory.getLogService((String)StreamSegment.class.getName());

    public static String open(CarbonTable table) throws IOException {
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(table.getAbsoluteTableIdentifier());
        ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
        try {
            if (carbonLock.lockWithRetries()) {
                LOGGER.info((Object)("Acquired lock for table" + table.getDatabaseName() + "." + table.getTableName() + " for stream table get or create segment"));
                LoadMetadataDetails[] details = SegmentStatusManager.readLoadMetadata((String)CarbonTablePath.getMetadataPath((String)table.getTablePath()));
                LoadMetadataDetails streamSegment = null;
                for (LoadMetadataDetails detail : details) {
                    if (!FileFormat.ROW_V1.equals((Object)detail.getFileFormat()) || SegmentStatus.STREAMING != detail.getSegmentStatus()) continue;
                    streamSegment = detail;
                    break;
                }
                if (null == streamSegment) {
                    String string = StreamSegment.createNewSegment(table, details);
                    return string;
                }
                String string = streamSegment.getLoadName();
                return string;
            }
            LOGGER.error((Object)("Not able to acquire the lock for stream table get or create segment for table " + table.getDatabaseName() + "." + table.getTableName()));
            throw new IOException("Failed to get stream segment");
        }
        finally {
            if (carbonLock.unlock()) {
                LOGGER.info((Object)("Table unlocked successfully after stream table get or create segment" + table.getDatabaseName() + "." + table.getTableName()));
            } else {
                LOGGER.error((Object)("Unable to unlock table lock for stream table" + table.getDatabaseName() + "." + table.getTableName() + " during stream table get or create segment"));
            }
        }
    }

    private static String createNewSegment(CarbonTable table, LoadMetadataDetails[] details) throws IOException {
        int segmentId = SegmentStatusManager.createNewSegmentId((LoadMetadataDetails[])details);
        LoadMetadataDetails newDetail = new LoadMetadataDetails();
        newDetail.setLoadName(String.valueOf(segmentId));
        newDetail.setFileFormat(FileFormat.ROW_V1);
        newDetail.setLoadStartTime(System.currentTimeMillis());
        newDetail.setSegmentStatus(SegmentStatus.STREAMING);
        LoadMetadataDetails[] newDetails = new LoadMetadataDetails[details.length + 1];
        for (int i = 0; i < details.length; ++i) {
            newDetails[i] = details[i];
        }
        newDetails[i] = newDetail;
        SegmentStatusManager.writeLoadDetailsIntoFile((String)CarbonTablePath.getTableStatusFilePath((String)table.getTablePath()), (LoadMetadataDetails[])newDetails);
        return newDetail.getLoadName();
    }

    public static String close(CarbonTable table, String segmentId) throws IOException {
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(table.getAbsoluteTableIdentifier());
        ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
        try {
            if (carbonLock.lockWithRetries()) {
                LoadMetadataDetails[] details;
                LOGGER.info((Object)("Acquired lock for table" + table.getDatabaseName() + "." + table.getTableName() + " for stream table finish segment"));
                for (LoadMetadataDetails detail : details = SegmentStatusManager.readLoadMetadata((String)CarbonTablePath.getMetadataPath((String)table.getTablePath()))) {
                    if (!segmentId.equals(detail.getLoadName())) continue;
                    detail.setLoadEndTime(System.currentTimeMillis());
                    detail.setSegmentStatus(SegmentStatus.STREAMING_FINISH);
                    break;
                }
                String string = StreamSegment.createNewSegment(table, details);
                return string;
            }
            LOGGER.error((Object)("Not able to acquire the status update lock for streaming table " + table.getDatabaseName() + "." + table.getTableName()));
            throw new IOException("Failed to get stream segment");
        }
        finally {
            if (carbonLock.unlock()) {
                LOGGER.info((Object)("Table unlocked successfully after table status update" + table.getDatabaseName() + "." + table.getTableName()));
            } else {
                LOGGER.error((Object)("Unable to unlock Table lock for table" + table.getDatabaseName() + "." + table.getTableName() + " during table status update"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishStreaming(CarbonTable carbonTable) throws IOException {
        block8: {
            ICarbonLock statusLock = CarbonLockFactory.getCarbonLockObj((AbsoluteTableIdentifier)carbonTable.getTableInfo().getOrCreateAbsoluteTableIdentifier(), (String)"tablestatus.lock");
            try {
                if (statusLock.lockWithRetries()) {
                    LoadMetadataDetails[] details = SegmentStatusManager.readLoadMetadata((String)carbonTable.getMetadataPath());
                    boolean updated = false;
                    for (LoadMetadataDetails detail : details) {
                        if (SegmentStatus.STREAMING != detail.getSegmentStatus()) continue;
                        detail.setLoadEndTime(System.currentTimeMillis());
                        detail.setSegmentStatus(SegmentStatus.STREAMING_FINISH);
                        updated = true;
                    }
                    if (updated) {
                        SegmentStatusManager.writeLoadDetailsIntoFile((String)CarbonTablePath.getTableStatusFilePath((String)carbonTable.getTablePath()), (LoadMetadataDetails[])details);
                    }
                    break block8;
                }
                String msg = "Failed to acquire table status lock of " + carbonTable.getDatabaseName() + "." + carbonTable.getTableName();
                LOGGER.error((Object)msg);
                throw new IOException(msg);
            }
            finally {
                if (statusLock.unlock()) {
                    LOGGER.info((Object)("Table unlocked successfully after table status update" + carbonTable.getDatabaseName() + "." + carbonTable.getTableName()));
                } else {
                    LOGGER.error((Object)("Unable to unlock Table lock for table " + carbonTable.getDatabaseName() + "." + carbonTable.getTableName() + " during table status update"));
                }
            }
        }
    }

    public static BlockletMinMaxIndex collectMinMaxIndex(SimpleStatsResult[] dimStats, SimpleStatsResult[] mrsStats) {
        int index;
        int index2;
        BlockletMinMaxIndex minMaxIndex = new BlockletMinMaxIndex();
        byte[][] maxIndexes = new byte[dimStats.length + mrsStats.length][];
        for (index2 = 0; index2 < dimStats.length; ++index2) {
            maxIndexes[index2] = CarbonUtil.getValueAsBytes((DataType)dimStats[index2].getDataType(), (Object)dimStats[index2].getMax());
        }
        for (index2 = 0; index2 < mrsStats.length; ++index2) {
            maxIndexes[dimStats.length + index2] = CarbonUtil.getValueAsBytes((DataType)mrsStats[index2].getDataType(), (Object)mrsStats[index2].getMax());
        }
        minMaxIndex.setMaxValues((byte[][])maxIndexes);
        byte[][] minIndexes = new byte[maxIndexes.length][];
        for (index = 0; index < dimStats.length; ++index) {
            minIndexes[index] = CarbonUtil.getValueAsBytes((DataType)dimStats[index].getDataType(), (Object)dimStats[index].getMin());
        }
        for (index = 0; index < mrsStats.length; ++index) {
            minIndexes[dimStats.length + index] = CarbonUtil.getValueAsBytes((DataType)mrsStats[index].getDataType(), (Object)mrsStats[index].getMin());
        }
        minMaxIndex.setMinValues((byte[][])minIndexes);
        boolean[] isMinMaxSet = new boolean[dimStats.length + mrsStats.length];
        Arrays.fill(isMinMaxSet, true);
        minMaxIndex.setIsMinMaxSet(isMinMaxSet);
        return minMaxIndex;
    }

    private static StreamFileIndex createStreamBlockIndex(String fileName, BlockletMinMaxIndex minMaxIndex, int blockletRowCount) {
        return new StreamFileIndex(fileName, minMaxIndex, blockletRowCount);
    }

    public static StreamFileIndex appendBatchData(CarbonIterator<Object[]> inputIterators, TaskAttemptContext job, CarbonLoadModel carbonLoadModel) throws Exception {
        CarbonStreamRecordWriter writer = null;
        try {
            writer = new CarbonStreamRecordWriter(job, carbonLoadModel);
            StreamSegment.recoverFileIfRequired(writer.getSegmentDir(), writer.getFileName(), CarbonTablePath.getCarbonStreamIndexFileName());
            int blockletRowCount = 0;
            while (inputIterators.hasNext()) {
                writer.write(null, inputIterators.next());
                ++blockletRowCount;
            }
            inputIterators.close();
            StreamFileIndex streamFileIndex = StreamSegment.createStreamBlockIndex(writer.getFileName(), writer.getBatchMinMaxIndex(), blockletRowCount);
            return streamFileIndex;
        }
        catch (Throwable ex) {
            if (writer != null) {
                LOGGER.error((Object)("Failed to append batch data to stream segment: " + writer.getSegmentDir()), ex);
                writer.setHasException(true);
            }
            throw ex;
        }
        finally {
            if (writer != null) {
                writer.close(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverSegmentIfRequired(String segmentDir) throws IOException {
        if (FileFactory.isFileExist((String)segmentDir)) {
            String indexName = CarbonTablePath.getCarbonStreamIndexFileName();
            String indexPath = segmentDir + File.separator + indexName;
            CarbonFile index = FileFactory.getCarbonFile((String)indexPath);
            CarbonFile[] files = StreamSegment.listDataFiles(segmentDir);
            if (index.exists()) {
                if (files.length > 0) {
                    CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
                    try {
                        indexReader.openThriftReader(indexPath);
                        HashMap<String, Long> tableSizeMap = new HashMap<String, Long>();
                        while (indexReader.hasNext()) {
                            BlockIndex blockIndex = indexReader.readBlockIndexInfo();
                            tableSizeMap.put(blockIndex.getFile_name(), blockIndex.getFile_size());
                        }
                        for (CarbonFile file : files) {
                            Long size = (Long)tableSizeMap.get(file.getName());
                            if (null == size || size == 0L) {
                                file.delete();
                                continue;
                            }
                            if (size >= file.getSize()) continue;
                            FileFactory.truncateFile((String)file.getCanonicalPath(), (long)size);
                        }
                    }
                    finally {
                        indexReader.closeThriftReader();
                    }
                }
            } else if (files.length > 0) {
                for (CarbonFile file : files) {
                    file.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverFileIfRequired(String segmentDir, String fileName, String indexName) throws IOException {
        String filePath = segmentDir + File.separator + fileName;
        CarbonFile file = FileFactory.getCarbonFile((String)filePath);
        String indexPath = segmentDir + File.separator + indexName;
        CarbonFile index = FileFactory.getCarbonFile((String)indexPath);
        if (file.exists() && index.exists()) {
            CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
            try {
                indexReader.openThriftReader(indexPath);
                while (indexReader.hasNext()) {
                    BlockIndex blockIndex = indexReader.readBlockIndexInfo();
                    if (!blockIndex.getFile_name().equals(fileName)) continue;
                    if (blockIndex.getFile_size() == 0L) {
                        file.delete();
                    } else if (blockIndex.getFile_size() < file.getSize()) {
                        FileFactory.truncateFile((String)filePath, (long)blockIndex.getFile_size());
                    }
                    break;
                }
            }
            finally {
                indexReader.closeThriftReader();
            }
        }
    }

    public static CarbonFile[] listDataFiles(String segmentDir) {
        CarbonFile carbonDir = FileFactory.getCarbonFile((String)segmentDir);
        if (carbonDir.exists()) {
            return carbonDir.listFiles(file -> CarbonTablePath.isCarbonDataFile((String)file.getName()));
        }
        return new CarbonFile[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BlockIndex> readIndexFile(String indexPath) throws IOException {
        ArrayList<BlockIndex> blockIndexList = new ArrayList<BlockIndex>();
        CarbonFile index = FileFactory.getCarbonFile((String)indexPath);
        if (index.exists()) {
            CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
            try {
                indexReader.openThriftReader(indexPath);
                while (indexReader.hasNext()) {
                    blockIndexList.add(indexReader.readBlockIndexInfo());
                }
            }
            finally {
                indexReader.closeThriftReader();
            }
        }
        return blockIndexList;
    }

    private static void mergeBatchMinMax(StreamFileIndex blockletIndex, BlockletMinMaxIndex fileIndex, DataType[] msrDataTypes) throws IOException {
        if (fileIndex == null) {
            blockletIndex.setMinMaxIndex(null);
            return;
        }
        BlockletMinMaxIndex minMaxIndex = blockletIndex.getMinMaxIndex();
        if (minMaxIndex == null) {
            blockletIndex.setMinMaxIndex(fileIndex);
            return;
        }
        SerializableComparator[] comparators = StreamSegment.getSerializableComparators(msrDataTypes);
        byte[][] minValues = minMaxIndex.getMinValues();
        byte[][] mergedMinValues = fileIndex.getMinValues();
        if (minValues == null || minValues.length == 0) {
            minMaxIndex.setMinValues(mergedMinValues);
        } else if (mergedMinValues != null && mergedMinValues.length != 0) {
            if (minValues.length != mergedMinValues.length) {
                throw new IOException("the lengths of the min values should be same.");
            }
            StreamSegment.mergeMinValues(msrDataTypes, comparators, minValues, mergedMinValues);
        }
        byte[][] maxValues = minMaxIndex.getMaxValues();
        byte[][] mergedMaxValues = fileIndex.getMaxValues();
        if (maxValues == null || maxValues.length == 0) {
            minMaxIndex.setMaxValues(mergedMaxValues);
        } else if (mergedMaxValues != null && mergedMaxValues.length != 0) {
            if (maxValues.length != mergedMaxValues.length) {
                throw new IOException("the lengths of the max values should be same.");
            }
            StreamSegment.mergeMaxValues(msrDataTypes, comparators, maxValues, mergedMaxValues);
        }
    }

    private static SerializableComparator[] getSerializableComparators(DataType[] msrDataTypes) {
        SerializableComparator[] comparators = new SerializableComparator[msrDataTypes.length];
        for (int index = 0; index < comparators.length; ++index) {
            comparators[index] = Comparator.getComparatorByDataTypeForMeasure((DataType)msrDataTypes[index]);
        }
        return comparators;
    }

    private static void mergeMaxValues(DataType[] msrDataTypes, SerializableComparator[] comparators, byte[][] maxValues, byte[][] mergedMaxValues) {
        int dimCount = maxValues.length - msrDataTypes.length;
        for (int index = 0; index < maxValues.length; ++index) {
            Object mergedObject;
            if (index < dimCount) {
                if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(maxValues[index], mergedMaxValues[index]) >= 0) continue;
                maxValues[index] = mergedMaxValues[index];
                continue;
            }
            Object object = DataTypeUtil.getMeasureObjectFromDataType((byte[])maxValues[index], (DataType)msrDataTypes[index - dimCount]);
            if (comparators[index - dimCount].compare(object, mergedObject = DataTypeUtil.getMeasureObjectFromDataType((byte[])mergedMaxValues[index], (DataType)msrDataTypes[index - dimCount])) >= 0) continue;
            maxValues[index] = mergedMaxValues[index];
        }
    }

    private static void mergeMinValues(DataType[] msrDataTypes, SerializableComparator[] comparators, byte[][] minValues, byte[][] mergedMinValues) {
        int dimCount = minValues.length - msrDataTypes.length;
        for (int index = 0; index < minValues.length; ++index) {
            Object mergedObject;
            if (index < dimCount) {
                if (ByteUtil.UnsafeComparer.INSTANCE.compareTo(minValues[index], mergedMinValues[index]) <= 0) continue;
                minValues[index] = mergedMinValues[index];
                continue;
            }
            Object object = DataTypeUtil.getMeasureObjectFromDataType((byte[])minValues[index], (DataType)msrDataTypes[index - dimCount]);
            if (comparators[index - dimCount].compare(object, mergedObject = DataTypeUtil.getMeasureObjectFromDataType((byte[])mergedMinValues[index], (DataType)msrDataTypes[index - dimCount])) <= 0) continue;
            minValues[index] = mergedMinValues[index];
        }
    }

    public static BlockletMinMaxIndex mergeBlockletMinMax(BlockletMinMaxIndex to, BlockletMinMaxIndex from, DataType[] msrDataTypes) {
        if (to == null) {
            return from;
        }
        if (from == null) {
            return to;
        }
        SerializableComparator[] comparators = StreamSegment.getSerializableComparators(msrDataTypes);
        byte[][] minValues = to.getMinValues();
        byte[][] mergedMinValues = from.getMinValues();
        StreamSegment.mergeMinValues(msrDataTypes, comparators, minValues, mergedMinValues);
        byte[][] maxValues = to.getMaxValues();
        byte[][] mergedMaxValues = from.getMaxValues();
        StreamSegment.mergeMaxValues(msrDataTypes, comparators, maxValues, mergedMaxValues);
        return to;
    }

    private static void updateStreamFileIndex(Map<String, StreamFileIndex> indexMap, String indexPath, DataType[] msrDataTypes) throws IOException {
        List<BlockIndex> blockIndexList = StreamSegment.readIndexFile(indexPath);
        for (BlockIndex blockIndex : blockIndexList) {
            BlockletMinMaxIndex fileIndex = CarbonMetadataUtil.convertExternalMinMaxIndex((org.apache.carbondata.format.BlockletMinMaxIndex)blockIndex.getBlock_index().getMin_max_index());
            StreamFileIndex blockletIndex = indexMap.get(blockIndex.getFile_name());
            if (blockletIndex == null) {
                indexMap.put(blockIndex.getFile_name(), new StreamFileIndex(blockIndex.getFile_name(), fileIndex, blockIndex.getNum_rows()));
                continue;
            }
            blockletIndex.setRowCount(blockletIndex.getRowCount() + blockIndex.getNum_rows());
            StreamSegment.mergeBatchMinMax(blockletIndex, fileIndex, msrDataTypes);
        }
    }

    public static void updateIndexFile(String segmentDir, StreamFileIndex[] blockIndexes, DataType[] msrDataTypes) throws IOException {
        String filePath = CarbonTablePath.getCarbonStreamIndexFilePath((String)segmentDir);
        HashMap<String, StreamFileIndex> indexMap = new HashMap<String, StreamFileIndex>();
        for (StreamFileIndex fileIndex : blockIndexes) {
            indexMap.put(fileIndex.getFileName(), fileIndex);
        }
        StreamSegment.updateStreamFileIndex(indexMap, filePath, msrDataTypes);
        String tempFilePath = filePath + ".write";
        CarbonIndexFileWriter writer = new CarbonIndexFileWriter();
        try {
            CarbonFile[] files;
            writer.openThriftWriter(tempFilePath);
            for (CarbonFile file : files = StreamSegment.listDataFiles(segmentDir)) {
                BlockIndex blockIndex = new BlockIndex();
                blockIndex.setFile_name(file.getName());
                blockIndex.setFile_size(file.getSize());
                blockIndex.setOffset(-1L);
                BlockletIndex blockletIndex = new BlockletIndex();
                blockIndex.setBlock_index(blockletIndex);
                StreamFileIndex streamFileIndex = (StreamFileIndex)indexMap.get(blockIndex.getFile_name());
                if (streamFileIndex != null) {
                    blockletIndex.setMin_max_index(CarbonMetadataUtil.convertMinMaxIndex((BlockletMinMaxIndex)streamFileIndex.getMinMaxIndex()));
                    blockIndex.setNum_rows(streamFileIndex.getRowCount());
                } else {
                    blockIndex.setNum_rows(-1L);
                }
                writer.writeThrift((TBase)blockIndex);
            }
            writer.close();
            CarbonFile tempFile = FileFactory.getCarbonFile((String)tempFilePath);
            if (!tempFile.renameForce(filePath)) {
                throw new IOException("temporary file renaming failed, src=" + tempFilePath + ", dest=" + filePath);
            }
        }
        catch (IOException ex) {
            try {
                writer.close();
            }
            catch (IOException t) {
                LOGGER.error((Object)t);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long size(String segmentDir) throws IOException {
        String indexPath;
        CarbonFile index;
        long size = 0L;
        if (FileFactory.isFileExist((String)segmentDir) && (index = FileFactory.getCarbonFile((String)(indexPath = CarbonTablePath.getCarbonStreamIndexFilePath((String)segmentDir)))).exists()) {
            CarbonIndexFileReader indexReader = new CarbonIndexFileReader();
            try {
                indexReader.openThriftReader(indexPath);
                while (indexReader.hasNext()) {
                    BlockIndex blockIndex = indexReader.readBlockIndexInfo();
                    size += blockIndex.getFile_size();
                }
            }
            finally {
                indexReader.closeThriftReader();
            }
        }
        return size;
    }
}

