/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.audittrail.applib.app;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.RestrictTo;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.clock.ClockService;
import org.apache.causeway.extensions.audittrail.applib.CausewayModuleExtAuditTrailApplib;
import org.apache.causeway.extensions.audittrail.applib.dom.AuditTrailEntry;
import org.apache.causeway.extensions.audittrail.applib.dom.AuditTrailEntryRepository;
import org.jspecify.annotations.Nullable;

@Named(value="causeway.ext.auditTrail.AuditTrailMenu")
@DomainService
@DomainServiceLayout(menuBar=DomainServiceLayout.MenuBar.SECONDARY, named="Activity")
public class AuditTrailMenu {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.auditTrail.AuditTrailMenu";
    final AuditTrailEntryRepository auditTrailEntryRepository;
    final ClockService clockService;

    private LocalDate now() {
        return this.clockService.getClock().nowAsLocalDate(ZoneId.systemDefault());
    }

    @Inject
    @Generated
    public AuditTrailMenu(AuditTrailEntryRepository auditTrailEntryRepository, ClockService clockService) {
        this.auditTrailEntryRepository = auditTrailEntryRepository;
        this.clockService = clockService;
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING, semantics=SemanticsOf.SAFE, typeOf=AuditTrailEntry.class)
    @ActionLayout(cssClassFa="fa-search", sequence="40")
    public class findAll {
        @MemberSupport
        public List<? extends AuditTrailEntry> act() {
            return AuditTrailMenu.this.auditTrailEntryRepository.findAll();
        }

        public class DomainEvent
        extends ActionDomainEvent<findAll> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE, typeOf=AuditTrailEntry.class)
    @ActionLayout(cssClassFa="fa-search", sequence="30")
    public class findAuditEntries {
        @MemberSupport
        public List<? extends AuditTrailEntry> act(@Nullable LocalDate from, @Nullable LocalDate to) {
            return AuditTrailMenu.this.auditTrailEntryRepository.findByFromAndTo(from, to);
        }

        @MemberSupport
        public LocalDate default0Act() {
            return AuditTrailMenu.this.now().minusDays(7L);
        }

        @MemberSupport
        public LocalDate default1Act() {
            return AuditTrailMenu.this.now();
        }

        public class DomainEvent
        extends ActionDomainEvent<findAuditEntries> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE, typeOf=AuditTrailEntry.class)
    @ActionLayout(cssClassFa="fa-search", sequence="20")
    public class findMostRecent {
        @MemberSupport
        public List<? extends AuditTrailEntry> act() {
            return AuditTrailMenu.this.auditTrailEntryRepository.findMostRecent();
        }

        public class DomainEvent
        extends ActionDomainEvent<findMostRecent> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends CausewayModuleExtAuditTrailApplib.ActionDomainEvent<T> {
    }
}

