/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.audittrail.applib.contributions;

import jakarta.inject.Inject;
import java.util.Comparator;
import java.util.Optional;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.applib.services.metamodel.BeanSort;
import org.apache.causeway.applib.services.metamodel.MetaModelService;
import org.apache.causeway.extensions.audittrail.applib.CausewayModuleExtAuditTrailApplib;
import org.apache.causeway.extensions.audittrail.applib.dom.AuditTrailEntry;
import org.apache.causeway.extensions.audittrail.applib.dom.AuditTrailEntryRepository;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntry;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;

@Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE)
@ActionLayout(cssClassFa="fa-bolt", position=ActionLayout.Position.PANEL_DROPDOWN, fieldSetId="metadata", sequence="900.4")
public class Object_createdByCommand {
    private final Object domainObject;
    @Inject
    MetaModelService metaModelService;
    @Inject
    AuditTrailEntryRepository auditTrailEntryRepository;
    @Inject
    CommandLogEntryRepository commandLogEntryRepository;
    @Inject
    BookmarkService bookmarkService;

    @MemberSupport
    public Object act() {
        Optional<CommandLogEntry> commandIfAny = this.bookmarkService.bookmarksFor(this.domainObject).stream().map(target -> this.auditTrailEntryRepository.findFirstByTarget((Bookmark)target)).filter(Optional::isPresent).map(Optional::get).map(AuditTrailEntry::getInteractionId).map(x -> this.commandLogEntryRepository.findByInteractionId(x)).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparing(CommandLogEntry::getTimestamp));
        return commandIfAny.isPresent() ? commandIfAny.get() : this.domainObject;
    }

    @MemberSupport
    public boolean hideAct() {
        Class<?> domainClass = this.domainObject.getClass();
        BeanSort beanSort = this.metaModelService.sortOf(domainClass, MetaModelService.Mode.RELAXED);
        return !beanSort.isEntity();
    }

    @Generated
    public Object_createdByCommand(Object domainObject) {
        this.domainObject = domainObject;
    }

    public static class ActionDomainEvent
    extends CausewayModuleExtAuditTrailApplib.ActionDomainEvent<Object_createdByCommand> {
    }
}

