/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.audittrail.applib.contributions;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.id.LogicalType;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureId;
import org.apache.causeway.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.applib.services.metamodel.BeanSort;
import org.apache.causeway.applib.services.metamodel.MetaModelService;
import org.apache.causeway.extensions.audittrail.applib.CausewayModuleExtAuditTrailApplib;
import org.apache.causeway.extensions.audittrail.applib.dom.AuditTrailEntry;
import org.apache.causeway.extensions.audittrail.applib.dom.AuditTrailEntryRepository;

@Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE)
@ActionLayout(cssClassFa="fa-bolt", position=ActionLayout.Position.PANEL_DROPDOWN, fieldSetId="metadata", sequence="900.3")
public class Object_recentAuditTrailEntries {
    private final Object domainObject;
    @Inject
    MetaModelService metaModelService;
    @Inject
    ApplicationFeatureRepository applicationFeatureRepository;
    @Inject
    AuditTrailEntryRepository auditTrailEntryRepository;
    @Inject
    BookmarkService bookmarkService;

    @MemberSupport
    public List<? extends AuditTrailEntry> act(String propertyName) {
        ArrayList<AuditTrailEntry> auditTrailEntries = new ArrayList<AuditTrailEntry>();
        this.bookmarkService.bookmarksFor(this.domainObject).forEach(bookmark -> {
            List<AuditTrailEntry> recent = this.auditTrailEntryRepository.findRecentByTargetAndPropertyId((Bookmark)bookmark, propertyName);
            auditTrailEntries.addAll(recent);
        });
        auditTrailEntries.sort(Comparator.comparing(AuditTrailEntry::getTimestamp).reversed());
        return auditTrailEntries;
    }

    @MemberSupport
    public List<String> choices0Act() {
        Class<?> domainClass = this.domainObject.getClass();
        Optional logicalTypeIfAny = this.metaModelService.lookupLogicalTypeByClass(domainClass);
        if (logicalTypeIfAny.isEmpty()) {
            return Collections.emptyList();
        }
        SortedSet propertyFeatureIds = this.applicationFeatureRepository.propertyIdsFor((LogicalType)logicalTypeIfAny.get());
        return propertyFeatureIds.stream().map(ApplicationFeatureId::getLogicalMemberName).collect(Collectors.toList());
    }

    @MemberSupport
    public String default0Act() {
        List<String> choices = this.choices0Act();
        return choices.size() == 1 ? choices.get(0) : null;
    }

    @MemberSupport
    public boolean hideAct() {
        Class<?> domainClass = this.domainObject.getClass();
        BeanSort beanSort = this.metaModelService.sortOf(domainClass, MetaModelService.Mode.RELAXED);
        return !beanSort.isEntity();
    }

    @Generated
    public Object_recentAuditTrailEntries(Object domainObject) {
        this.domainObject = domainObject;
    }

    public static class ActionDomainEvent
    extends CausewayModuleExtAuditTrailApplib.ActionDomainEvent<Object_recentAuditTrailEntries> {
    }
}

