/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.audittrail.applib.dom;

import jakarta.inject.Named;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.UUID;
import lombok.Generated;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.DomainObjectLayout;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.annotation.PropertyLayout;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.mixins.system.DomainChangeRecord;
import org.apache.causeway.applib.mixins.system.HasInteractionIdAndSequence;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.publishing.spi.EntityPropertyChange;
import org.apache.causeway.applib.util.ObjectContracts;
import org.apache.causeway.applib.util.TitleBuffer;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.base._Temporals;
import org.apache.causeway.extensions.audittrail.applib.CausewayModuleExtAuditTrailApplib;

@Named(value="causeway.ext.auditTrail.AuditTrailEntry")
@DomainObject(editing=Editing.DISABLED, entityChangePublishing=Publishing.DISABLED)
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class, iconUiEvent=IconUiEvent.class, cssClassUiEvent=CssClassUiEvent.class, layoutUiEvent=LayoutUiEvent.class)
public abstract class AuditTrailEntry
implements DomainChangeRecord,
Comparable<AuditTrailEntry> {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.auditTrail.AuditTrailEntry";
    public static final String SCHEMA = "causewayExtAuditTrail";
    public static final String TABLE = "AuditTrailEntry";
    private static final ObjectContracts.ObjectContract<AuditTrailEntry> contract = ObjectContracts.contract(AuditTrailEntry.class).thenUse("timestamp", AuditTrailEntry::getTimestamp).thenUse("username", AuditTrailEntry::getUsername).thenUse("target", e -> e.getTarget() != null ? e.getTarget().toString() : null).thenUse("propertyId", AuditTrailEntry::getPropertyId);

    @Programmatic
    public void init(EntityPropertyChange change) {
        this.setTimestamp(change.getTimestamp());
        this.setUsername(change.getUsername());
        this.setTarget(change.getTarget());
        this.setLogicalMemberIdentifier(change.getLogicalMemberIdentifier());
        this.setSequence(change.getSequence());
        this.setPropertyId(change.getPropertyId());
        this.setPreValue(_Strings.trimmed((String)change.getPreValue(), (int)255));
        this.setPostValue(_Strings.trimmed((String)change.getPostValue(), (int)255));
        this.setInteractionId(change.getInteractionId());
    }

    @ObjectSupport
    public String title() {
        TitleBuffer buf = new TitleBuffer();
        buf.append(_Temporals.DEFAULT_LOCAL_DATETIME_FORMATTER.format(this.getTimestamp().toLocalDateTime()));
        buf.append(" ").append(this.getLogicalMemberIdentifier());
        return buf.toString();
    }

    @DomainChangeRecord.Type
    public DomainChangeRecord.ChangeType getType() {
        return DomainChangeRecord.ChangeType.AUDIT_ENTRY;
    }

    @InteractionId
    public abstract UUID getInteractionId();

    public abstract void setInteractionId(UUID var1);

    @Username
    public abstract String getUsername();

    public abstract void setUsername(String var1);

    @Timestamp
    public abstract java.sql.Timestamp getTimestamp();

    public abstract void setTimestamp(java.sql.Timestamp var1);

    @Target
    public abstract Bookmark getTarget();

    public abstract void setTarget(Bookmark var1);

    @Sequence
    public abstract int getSequence();

    public abstract void setSequence(int var1);

    @LogicalMemberIdentifier
    public abstract String getLogicalMemberIdentifier();

    public abstract void setLogicalMemberIdentifier(String var1);

    @PropertyId
    public abstract String getPropertyId();

    public abstract void setPropertyId(String var1);

    @PreValue
    public abstract String getPreValue();

    public abstract void setPreValue(String var1);

    @PostValue
    public abstract String getPostValue();

    public abstract void setPostValue(String var1);

    public String toString() {
        return contract.toString((Object)this);
    }

    @Override
    public int compareTo(AuditTrailEntry other) {
        return contract.compare((Object)this, (Object)other);
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.NOWHERE)
    @DomainChangeRecord.PreValue
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PreValue {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.NOWHERE)
    @DomainChangeRecord.PostValue
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PostValue {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, optionality=Optionality.MANDATORY)
    @DomainChangeRecord.PropertyId
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PropertyId {
        public static final int MAX_LENGTH = 100;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(hidden=Where.ALL_TABLES)
    @DomainChangeRecord.LogicalMemberIdentifier
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LogicalMemberIdentifier {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @HasInteractionIdAndSequence.Sequence
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Sequence {
        public static final String NAME = "sequence";
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<Integer> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Target
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Target {
        public static final int MAX_LENGTH = 1500;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<Bookmark> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Timestamp
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Timestamp {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Username
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Username {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.InteractionId
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InteractionId {
        public static final String NAME = "interactionId";
        public static final int MAX_LENGTH = 36;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<UUID> {
        }
    }

    public static abstract class ActionDomainEvent
    extends CausewayModuleExtAuditTrailApplib.ActionDomainEvent<AuditTrailEntry> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends CausewayModuleExtAuditTrailApplib.CollectionDomainEvent<AuditTrailEntry, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtAuditTrailApplib.PropertyDomainEvent<AuditTrailEntry, T> {
    }

    public static class LayoutUiEvent
    extends CausewayModuleExtAuditTrailApplib.LayoutUiEvent<AuditTrailEntry> {
    }

    public static class CssClassUiEvent
    extends CausewayModuleExtAuditTrailApplib.CssClassUiEvent<AuditTrailEntry> {
    }

    public static class IconUiEvent
    extends CausewayModuleExtAuditTrailApplib.IconUiEvent<AuditTrailEntry> {
    }

    public static class TitleUiEvent
    extends CausewayModuleExtAuditTrailApplib.TitleUiEvent<AuditTrailEntry> {
    }

    public static final class Nq {
        public static final String FIND_FIRST_BY_TARGET = "findFirstByTarget";
        public static final String FIND_RECENT_BY_TARGET = "findRecentByTarget";
        public static final String FIND_RECENT_BY_TARGET_AND_PROPERTY_ID = "findRecentByTargetAndPropertyId";
        public static final String FIND_BY_INTERACTION_ID = "findByInteractionId";
        public static final String FIND_BY_TARGET_AND_TIMESTAMP_BETWEEN = "findByTargetAndTimestampBetween";
        public static final String FIND_BY_TARGET_AND_TIMESTAMP_AFTER = "findByTargetAndTimestampAfter";
        public static final String FIND_BY_TARGET_AND_TIMESTAMP_BEFORE = "findByTargetAndTimestampBefore";
        public static final String FIND_BY_TARGET = "findByTarget";
        public static final String FIND_BY_TIMESTAMP_BETWEEN = "findByTimestampBetween";
        public static final String FIND_BY_TIMESTAMP_AFTER = "findByTimestampAfter";
        public static final String FIND_BY_TIMESTAMP_BEFORE = "findByTimestampBefore";
        public static final String FIND = "find";
        public static final String FIND_MOST_RECENT = "causeway.ext.auditTrail.AuditTrailEntry.findMostRecent";
        public static final String FIND_BY_USERNAME_AND_TIMESTAMP_BETWEEN = "findByUsernameAndTimestampBetween";
        public static final String FIND_BY_USERNAME_AND_TIMESTAMP_AFTER = "findByUsernameAndTimestampAfter";
        public static final String FIND_BY_USERNAME_AND_TIMESTAMP_BEFORE = "findByUsernameAndTimestampBefore";
        public static final String FIND_BY_USERNAME = "findByUsername";
        public static final String FIND_BY_USERNAME_AND_TARGET_AND_TIMESTAMP_BETWEEN = "findByUsernameAndTargetAndTimestampBetween";
        public static final String FIND_BY_USERNAME_AND_TARGET_AND_TIMESTAMP_AFTER = "findByUsernameAndTargetAndTimestampAfter";
        public static final String FIND_BY_USERNAME_AND_TARGET_AND_TIMESTAMP_BEFORE = "findByUsernameAndTargetAndTimestampBefore";
        public static final String FIND_BY_USERNAME_AND_TARGET = "findByUsernameAndTarget";
        public static final String FIND_RECENT_BY_USERNAME = "causeway.ext.auditTrail.AuditTrailEntry.findRecentByUsername";

        @Generated
        private Nq() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

