/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.audittrail.applib.dom;

import jakarta.inject.Inject;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.causeway.applib.query.NamedQuery;
import org.apache.causeway.applib.query.Query;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.applib.services.publishing.spi.EntityPropertyChange;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.config.environment.CausewaySystemEnvironment;
import org.apache.causeway.extensions.audittrail.applib.dom.AuditTrailEntry;
import org.apache.causeway.extensions.audittrail.applib.dom.AuditTrailEntryRepository;

public abstract class AuditTrailEntryRepositoryAbstract<E extends AuditTrailEntry>
implements AuditTrailEntryRepository {
    @Inject
    RepositoryService repositoryService;
    @Inject
    FactoryService factoryService;
    @Inject
    CausewaySystemEnvironment causewaySystemEnvironment;
    private final Class<E> auditTrailEntryClass;

    protected AuditTrailEntryRepositoryAbstract(Class<E> auditTrailEntryClass) {
        this.auditTrailEntryClass = auditTrailEntryClass;
    }

    public Class<E> getEntityClass() {
        return this.auditTrailEntryClass;
    }

    @Override
    public AuditTrailEntry createFor(EntityPropertyChange change) {
        AuditTrailEntry entry = (AuditTrailEntry)this.factoryService.detachedEntity(this.auditTrailEntryClass);
        entry.init(change);
        return (AuditTrailEntry)this.repositoryService.persistAndFlush((Object)entry);
    }

    @Override
    public Can<AuditTrailEntry> createFor(Can<EntityPropertyChange> entityPropertyChanges) {
        return Can.ofCollection((Collection)((Collection)this.repositoryService.execInBulk(() -> entityPropertyChanges.map(this::createFor).toList())));
    }

    @Override
    public Optional<AuditTrailEntry> findFirstByTarget(Bookmark target) {
        return (Optional)_Casts.uncheckedCast((Object)this.repositoryService.firstMatch(Query.named(this.auditTrailEntryClass, (String)"findFirstByTarget").withParameter("target", (Object)target).withLimit(2L)));
    }

    @Override
    public List<AuditTrailEntry> findRecentByTarget(Bookmark target) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches(Query.named(this.auditTrailEntryClass, (String)"findRecentByTarget").withParameter("target", (Object)target).withLimit(100L)));
    }

    @Override
    public List<AuditTrailEntry> findRecentByTargetAndPropertyId(Bookmark target, String propertyId) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches(Query.named(this.auditTrailEntryClass, (String)"findRecentByTargetAndPropertyId").withParameter("target", (Object)target).withParameter("propertyId", (Object)propertyId).withLimit(30L)));
    }

    @Override
    public List<AuditTrailEntry> findByInteractionId(UUID interactionId) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches((Query)Query.named(this.auditTrailEntryClass, (String)"findByInteractionId").withParameter("interactionId", (Object)interactionId)));
    }

    @Override
    public List<AuditTrailEntry> findByTargetAndFromAndTo(Bookmark target, LocalDate from, LocalDate to) {
        Timestamp fromTs = AuditTrailEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(from, 0);
        Timestamp toTs = AuditTrailEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(to, 1);
        NamedQuery query = from != null ? (to != null ? Query.named(this.auditTrailEntryClass, (String)"findByTargetAndTimestampBetween").withParameter("target", (Object)target).withParameter("from", (Object)fromTs).withParameter("to", (Object)toTs) : Query.named(this.auditTrailEntryClass, (String)"findByTargetAndTimestampAfter").withParameter("target", (Object)target).withParameter("from", (Object)fromTs)) : (to != null ? Query.named(this.auditTrailEntryClass, (String)"findByTargetAndTimestampBefore").withParameter("target", (Object)target).withParameter("to", (Object)toTs) : Query.named(this.auditTrailEntryClass, (String)"findByTarget").withParameter("target", (Object)target));
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches((Query)query));
    }

    @Override
    public List<AuditTrailEntry> findByFromAndTo(LocalDate from, LocalDate to) {
        Timestamp fromTs = AuditTrailEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(from, 0);
        Timestamp toTs = AuditTrailEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(to, 1);
        NamedQuery query = from != null ? (to != null ? Query.named(this.auditTrailEntryClass, (String)"findByTimestampBetween").withParameter("from", (Object)fromTs).withParameter("to", (Object)toTs) : Query.named(this.auditTrailEntryClass, (String)"findByTimestampAfter").withParameter("from", (Object)fromTs)) : (to != null ? Query.named(this.auditTrailEntryClass, (String)"findByTimestampBefore").withParameter("to", (Object)toTs) : Query.named(this.auditTrailEntryClass, (String)"find"));
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches((Query)query));
    }

    private static Timestamp toTimestampStartOfDayWithOffset(LocalDate dt, int daysOffset) {
        return dt != null ? Timestamp.valueOf(dt.atStartOfDay().plusDays(daysOffset)) : null;
    }

    @Override
    public List<AuditTrailEntry> findMostRecent() {
        return this.findMostRecent(100);
    }

    @Override
    public List<AuditTrailEntry> findMostRecent(int limit) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches(Query.named(this.auditTrailEntryClass, (String)"causeway.ext.auditTrail.AuditTrailEntry.findMostRecent").withLimit((long)limit)));
    }

    @Override
    public List<AuditTrailEntry> findByUsernameAndFromAndTo(String username, LocalDate from, LocalDate to) {
        Timestamp fromTs = AuditTrailEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(from, 0);
        Timestamp toTs = AuditTrailEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(to, 1);
        NamedQuery query = from != null ? (to != null ? Query.named(this.auditTrailEntryClass, (String)"findByUsernameAndTimestampBetween").withParameter("username", (Object)username).withParameter("from", (Object)fromTs).withParameter("to", (Object)toTs) : Query.named(this.auditTrailEntryClass, (String)"findByUsernameAndTimestampAfter").withParameter("username", (Object)username).withParameter("from", (Object)fromTs)) : (to != null ? Query.named(this.auditTrailEntryClass, (String)"findByUsernameAndTimestampBefore").withParameter("username", (Object)username).withParameter("to", (Object)toTs) : Query.named(this.auditTrailEntryClass, (String)"findByUsername").withParameter("username", (Object)username));
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches((Query)query));
    }

    @Override
    public List<AuditTrailEntry> findByUsernameAndTargetAndFromAndTo(String username, Bookmark target, LocalDate from, LocalDate to) {
        Timestamp fromTs = AuditTrailEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(from, 0);
        Timestamp toTs = AuditTrailEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(to, 1);
        NamedQuery query = from != null ? (to != null ? Query.named(this.auditTrailEntryClass, (String)"findByUsernameAndTargetAndTimestampBetween").withParameter("username", (Object)username).withParameter("target", (Object)target).withParameter("from", (Object)fromTs).withParameter("to", (Object)toTs) : Query.named(this.auditTrailEntryClass, (String)"findByUsernameAndTargetAndTimestampAfter").withParameter("username", (Object)username).withParameter("target", (Object)target).withParameter("from", (Object)fromTs)) : (to != null ? Query.named(this.auditTrailEntryClass, (String)"findByUsernameAndTargetAndTimestampBefore").withParameter("username", (Object)username).withParameter("target", (Object)target).withParameter("to", (Object)toTs) : Query.named(this.auditTrailEntryClass, (String)"findByUsernameAndTarget").withParameter("username", (Object)username).withParameter("target", (Object)target));
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches((Query)query));
    }

    @Override
    public List<AuditTrailEntry> findRecentByUsername(String username) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches(Query.named(this.auditTrailEntryClass, (String)"causeway.ext.auditTrail.AuditTrailEntry.findRecentByUsername").withParameter("username", (Object)username).withLimit(100L)));
    }

    @Override
    public List<AuditTrailEntry> findAll() {
        if (this.causewaySystemEnvironment.getDeploymentType().isProduction()) {
            throw new IllegalStateException("Cannot call 'findAll' in production systems");
        }
        return (List)_Casts.uncheckedCast((Object)this.repositoryService.allMatches((Query)Query.named(this.auditTrailEntryClass, (String)"find")));
    }

    @Override
    public void removeAll() {
        if (this.causewaySystemEnvironment.getDeploymentType().isProduction()) {
            throw new IllegalStateException("Cannot call 'removeAll' in production systems");
        }
        this.repositoryService.removeAll(this.auditTrailEntryClass);
    }
}

