/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.audittrail.applib.spiimpl;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import lombok.Generated;
import org.apache.causeway.applib.services.publishing.spi.EntityPropertyChange;
import org.apache.causeway.applib.services.publishing.spi.EntityPropertyChangeSubscriber;
import org.apache.causeway.applib.services.xactn.TransactionService;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.audittrail.applib.dom.AuditTrailEntryRepository;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.ext.auditTrail.EntityPropertyChangeSubscriberForAuditTrail")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class EntityPropertyChangeSubscriberForAuditTrail
implements EntityPropertyChangeSubscriber {
    static final String LOGICAL_TYPE_NAME = "causeway.ext.auditTrail.EntityPropertyChangeSubscriberForAuditTrail";
    final TransactionService transactionService;
    final AuditTrailEntryRepository auditTrailEntryRepository;
    final CausewayConfiguration causewayConfiguration;

    public boolean isEnabled() {
        return this.causewayConfiguration.getExtensions().getAuditTrail().getPersist().isEnabled();
    }

    public void onChanging(EntityPropertyChange entityPropertyChange) {
        if (!this.isEnabled()) {
            return;
        }
        this.auditTrailEntryRepository.createFor(entityPropertyChange);
    }

    public void onChanging(Can<EntityPropertyChange> entityPropertyChanges) {
        if (!this.isEnabled()) {
            return;
        }
        this.auditTrailEntryRepository.createFor(entityPropertyChanges);
    }

    @Inject
    @Generated
    public EntityPropertyChangeSubscriberForAuditTrail(TransactionService transactionService, AuditTrailEntryRepository auditTrailEntryRepository, CausewayConfiguration causewayConfiguration) {
        this.transactionService = transactionService;
        this.auditTrailEntryRepository = auditTrailEntryRepository;
        this.causewayConfiguration = causewayConfiguration;
    }
}

