/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.app;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.RestrictTo;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.clock.ClockService;
import org.apache.causeway.extensions.commandlog.applib.CausewayModuleExtCommandLogApplib;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntry;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;
import org.jspecify.annotations.Nullable;

@Named(value="causeway.ext.commandLog.CommandLogMenu")
@DomainService
@DomainServiceLayout(menuBar=DomainServiceLayout.MenuBar.SECONDARY, named="Activity")
@Priority(value=0x1FFFFFFF)
public class CommandLogMenu {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.commandLog.CommandLogMenu";
    final CommandLogEntryRepository commandLogEntryRepository;
    final ClockService clockService;

    private LocalDate now() {
        return this.clockService.getClock().nowAsLocalDate(ZoneId.systemDefault());
    }

    @Inject
    @Generated
    public CommandLogMenu(CommandLogEntryRepository commandLogEntryRepository, ClockService clockService) {
        this.commandLogEntryRepository = commandLogEntryRepository;
        this.clockService = clockService;
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING, semantics=SemanticsOf.SAFE, typeOf=CommandLogEntry.class)
    @ActionLayout(cssClassFa="fa-search", sequence="40")
    public class findAll {
        @MemberSupport
        public List<? extends CommandLogEntry> act() {
            return CommandLogMenu.this.commandLogEntryRepository.findAll();
        }

        public class DomainEvent
        extends ActionDomainEvent<findAll> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE, typeOf=CommandLogEntry.class)
    @ActionLayout(cssClassFa="fa-search", sequence="30")
    public class findCommands {
        @MemberSupport
        public List<? extends CommandLogEntry> act(@Nullable LocalDate from, @Nullable LocalDate to) {
            return CommandLogMenu.this.commandLogEntryRepository.findByFromAndTo(from, to);
        }

        @MemberSupport
        public LocalDate default0Act() {
            return CommandLogMenu.this.now().minusDays(7L);
        }

        @MemberSupport
        public LocalDate default1Act() {
            return CommandLogMenu.this.now();
        }

        public class DomainEvent
        extends ActionDomainEvent<findCommands> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE, typeOf=CommandLogEntry.class)
    @ActionLayout(cssClassFa="fa-search", sequence="10")
    public class findMostRecent {
        @MemberSupport
        public List<? extends CommandLogEntry> act() {
            return CommandLogMenu.this.commandLogEntryRepository.findMostRecent();
        }

        public class DomainEvent
        extends ActionDomainEvent<findMostRecent> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE, typeOf=CommandLogEntry.class)
    @ActionLayout(cssClassFa="fa-bolt", sequence="10")
    public class activeCommands {
        @MemberSupport
        public List<? extends CommandLogEntry> act() {
            return CommandLogMenu.this.commandLogEntryRepository.findCurrent();
        }

        public class DomainEvent
        extends ActionDomainEvent<activeCommands> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends CausewayModuleExtCommandLogApplib.ActionDomainEvent<T> {
    }
}

