/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.contributions;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.causeway.applib.annotation.Collection;
import org.apache.causeway.applib.annotation.CollectionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.mixins.security.HasUsername;
import org.apache.causeway.extensions.commandlog.applib.CausewayModuleExtCommandLogApplib;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntry;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;

@Collection(domainEvent=CollectionDomainEvent.class)
@CollectionLayout(defaultView="table", paged=5, sequence="3")
public class HasUsername_recentCommandsByUser {
    private final HasUsername hasUsername;
    @Inject
    CommandLogEntryRepository commandLogEntryRepository;

    public HasUsername_recentCommandsByUser(HasUsername hasUsername) {
        this.hasUsername = hasUsername;
    }

    @MemberSupport
    public List<? extends CommandLogEntry> coll() {
        String username = this.hasUsername.getUsername();
        return username != null ? this.commandLogEntryRepository.findRecentByUsername(username) : Collections.emptyList();
    }

    @MemberSupport
    public boolean hideColl() {
        return this.hasUsername.getUsername() == null;
    }

    public static class CollectionDomainEvent
    extends CausewayModuleExtCommandLogApplib.CollectionDomainEvent<HasUsername_recentCommandsByUser, CommandLogEntry> {
    }
}

