/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.contributions;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.mixins.system.HasInteractionId;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.extensions.commandlog.applib.CausewayModuleExtCommandLogApplib;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntry;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;

@Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE)
@ActionLayout(cssClassFa="fa-bolt", describedAs="Returns the last (published) 30 commands that have either targeted this object, or that have returned this object as their result", position=ActionLayout.Position.PANEL_DROPDOWN, fieldSetId="metadata", sequence="900.1")
public class Object_recentCommands {
    private final Object domainObject;
    @Inject
    CommandLogEntryRepository commandLogEntryRepository;
    @Inject
    BookmarkService bookmarkService;

    @MemberSupport
    public List<? extends CommandLogEntry> act() {
        ArrayList<CommandLogEntry> commandLogEntries = new ArrayList<CommandLogEntry>();
        this.bookmarkService.bookmarksFor(this.domainObject).forEach(bookmark -> {
            List<CommandLogEntry> recent = this.commandLogEntryRepository.findRecentByTargetOrResult((Bookmark)bookmark);
            commandLogEntries.addAll(recent);
        });
        commandLogEntries.sort(Comparator.comparing(CommandLogEntry::getTimestamp).reversed());
        return commandLogEntries;
    }

    @MemberSupport
    public boolean hideAct() {
        return this.domainObject instanceof HasInteractionId;
    }

    @Generated
    public Object_recentCommands(Object domainObject) {
        this.domainObject = domainObject;
    }

    public static class ActionDomainEvent
    extends CausewayModuleExtCommandLogApplib.ActionDomainEvent<Object_recentCommands> {
    }
}

