/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.dom;

import jakarta.inject.Inject;
import java.sql.Timestamp;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.apache.causeway.applib.jaxb.JavaSqlJaxbAdapters;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.command.Command;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.services.wrapper.WrapperFactory;
import org.apache.causeway.applib.services.wrapper.control.AsyncControl;
import org.apache.causeway.applib.services.wrapper.control.SyncControl;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;
import org.apache.causeway.extensions.commandlog.applib.dom.ExecuteIn;
import org.apache.causeway.schema.cmd.v2.CommandDto;
import org.apache.causeway.schema.common.v2.OidDto;
import org.apache.causeway.schema.common.v2.PeriodDto;
import org.springframework.stereotype.Service;

@Service
public class BackgroundService {
    @Inject
    WrapperFactory wrapperFactory;
    @Inject
    CommandLogEntryRepository commandLogEntryRepository;

    public <T> WrapperFactory.AsyncProxy<T> execute(T object) {
        return this.wrapperFactory.asyncWrap(object, this.asyncControl().withCheckRules());
    }

    public <T> WrapperFactory.AsyncProxy<T> executeSkipRules(T object) {
        return this.wrapperFactory.asyncWrap(object, this.asyncControl().withSkipRules());
    }

    public <T> WrapperFactory.AsyncProxy<T> executeMixin(Class<T> mixinClass, Object mixedIn) {
        return this.wrapperFactory.asyncWrapMixin(mixinClass, mixedIn, this.asyncControl().withCheckRules());
    }

    public <T> WrapperFactory.AsyncProxy<T> executeMixinSkipRules(Class<T> mixinClass, Object mixedIn) {
        return this.wrapperFactory.asyncWrapMixin(mixinClass, mixedIn, this.asyncControl().withSkipRules());
    }

    AsyncControl asyncControl() {
        return AsyncControl.defaults().with((ExecutorService)ForkJoinPool.commonPool()).withNoExecute().listen((SyncControl.CommandListener)new CommandPersistor(this.commandLogEntryRepository));
    }

    record CommandPersistor(CommandLogEntryRepository commandLogEntryRepository) implements SyncControl.CommandListener
    {
        private static final JavaSqlJaxbAdapters.TimestampToXMLGregorianCalendarAdapter GREGORIAN_CALENDAR_ADAPTER = new JavaSqlJaxbAdapters.TimestampToXMLGregorianCalendarAdapter();

        public void onCommand(UUID parentInteractionId, InteractionContext interactionContext, CommandDto commandDto) {
            commandDto.setInteractionId(UUID.randomUUID().toString());
            commandDto.setTimestamp(GREGORIAN_CALENDAR_ADAPTER.marshal(interactionContext.getClock().nowAsJavaSqlTimestamp()));
            commandDto.setUsername(interactionContext.getUser().name());
            PeriodDto periodDto = new PeriodDto();
            periodDto.setStartedAt(null);
            periodDto.setCompletedAt(null);
            commandDto.setTimings(periodDto);
            Command childCommand = CommandPersistor.newCommand(commandDto);
            this.commandLogEntryRepository.createEntryAndPersist(childCommand, parentInteractionId, ExecuteIn.BACKGROUND);
        }

        private static Command newCommand(final CommandDto commandDto) {
            return new Command(UUID.fromString(commandDto.getInteractionId())){

                public String getUsername() {
                    return commandDto.getUsername();
                }

                public Timestamp getTimestamp() {
                    return GREGORIAN_CALENDAR_ADAPTER.unmarshal(commandDto.getTimestamp());
                }

                public CommandDto getCommandDto() {
                    return commandDto;
                }

                public String getLogicalMemberIdentifier() {
                    return commandDto.getMember().getLogicalMemberIdentifier();
                }

                public Bookmark getTarget() {
                    return Bookmark.forOidDto((OidDto)((OidDto)commandDto.getTargets().getOid().get(0)));
                }

                public Timestamp getStartedAt() {
                    return GREGORIAN_CALENDAR_ADAPTER.unmarshal(commandDto.getTimings().getStartedAt());
                }

                public Timestamp getCompletedAt() {
                    return GREGORIAN_CALENDAR_ADAPTER.unmarshal(commandDto.getTimings().getCompletedAt());
                }

                public Bookmark getResult() {
                    return null;
                }

                public Throwable getException() {
                    return null;
                }
            };
        }
    }
}

