/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.dom;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.constraints.Digits;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Domain;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.DomainObjectLayout;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.annotation.PropertyLayout;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.Where;
import org.apache.causeway.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;
import org.apache.causeway.applib.mixins.system.DomainChangeRecord;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.command.Command;
import org.apache.causeway.applib.services.commanddto.HasCommandDto;
import org.apache.causeway.applib.services.commanddto.conmap.UserDataKeys;
import org.apache.causeway.applib.services.tablecol.TableColumnOrderForCollectionTypeAbstract;
import org.apache.causeway.applib.util.ObjectContracts;
import org.apache.causeway.applib.util.TitleBuffer;
import org.apache.causeway.applib.util.ToString;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.commons.internal.base._Temporals;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.extensions.commandlog.applib.CausewayModuleExtCommandLogApplib;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;
import org.apache.causeway.schema.cmd.v2.CommandDto;
import org.apache.causeway.schema.cmd.v2.MapDto;
import org.apache.causeway.schema.common.v2.OidDto;
import org.springframework.stereotype.Service;

@Named(value="causeway.ext.commandLog.CommandLogEntry")
@DomainObject(editing=Editing.DISABLED, entityChangePublishing=Publishing.DISABLED)
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class, iconUiEvent=IconUiEvent.class, cssClassUiEvent=CssClassUiEvent.class, layoutUiEvent=LayoutUiEvent.class)
public abstract class CommandLogEntry
implements Comparable<CommandLogEntry>,
DomainChangeRecord,
HasCommandDto {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.commandLog.CommandLogEntry";
    public static final String SCHEMA = "causewayExtCommandLog";
    public static final String TABLE = "CommandLogEntry";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    @Inject
    CommandLogEntryRepository commandLogEntryRepository;
    static final ToString<CommandLogEntry> stringifier = ObjectContracts.toString((String)"interactionId", CommandLogEntry::getInteractionId).thenToString("username", CommandLogEntry::getUsername).thenToString("timestamp", CommandLogEntry::getTimestamp).thenToString("target", CommandLogEntry::getTarget).thenToString("logicalMemberIdentifier", CommandLogEntry::getLogicalMemberIdentifier).thenToStringOmitIfAbsent("startedAt", CommandLogEntry::getStartedAt).thenToStringOmitIfAbsent("completedAt", CommandLogEntry::getCompletedAt);

    @Programmatic
    public void sync(Command command) {
        this.setInteractionId(command.getInteractionId());
        this.setUsername(command.getUsername());
        this.setTimestamp(command.getTimestamp());
        this.setCommandDto(command.getCommandDto());
        this.setTarget(command.getTarget());
        this.setLogicalMemberIdentifier(command.getLogicalMemberIdentifier());
        this.setStartedAt(command.getStartedAt());
        this.setCompletedAt(command.getCompletedAt());
        this.setResult(command.getResult());
        this.setException(command.getException());
        this.setReplayState(org.apache.causeway.extensions.commandlog.applib.dom.ReplayState.UNDEFINED);
    }

    public CommandLogEntry(CommandDto commandDto, org.apache.causeway.extensions.commandlog.applib.dom.ReplayState replayState, int targetIndex) {
        this.setInteractionId(UUID.fromString(commandDto.getInteractionId()));
        this.setUsername(commandDto.getUsername());
        this.setTimestamp(JavaSqlXMLGregorianCalendarMarshalling.toTimestamp((XMLGregorianCalendar)commandDto.getTimestamp()));
        this.setCommandDto(commandDto);
        this.setTarget(Bookmark.forOidDto((OidDto)((OidDto)commandDto.getTargets().getOid().get(targetIndex))));
        this.setLogicalMemberIdentifier(commandDto.getMember().getLogicalMemberIdentifier());
        this.setParentInteractionId(null);
        this.setStartedAt(JavaSqlXMLGregorianCalendarMarshalling.toTimestamp((XMLGregorianCalendar)commandDto.getTimings().getStartedAt()));
        this.setCompletedAt(JavaSqlXMLGregorianCalendarMarshalling.toTimestamp((XMLGregorianCalendar)commandDto.getTimings().getCompletedAt()));
        CommandLogEntry.copyOver(commandDto, UserDataKeys.RESULT, value -> this.setResult(Bookmark.parse((String)value).orElse(null)));
        CommandLogEntry.copyOver(commandDto, UserDataKeys.EXCEPTION, this::setException);
        this.setReplayState(replayState);
    }

    static void copyOver(CommandDto commandDto, String key, Consumer<String> consume) {
        commandDto.getUserData().getEntry().stream().filter(x -> Objects.equals(x.getKey(), key)).map(MapDto.Entry::getValue).filter(Objects::nonNull).filter(x -> x.length() > 0).findFirst().ifPresent(consume);
    }

    @ObjectSupport
    public String title() {
        return new TitleBuffer().append(formatter.format(this.getTimestamp().toLocalDateTime())).append(" ").append(this.getLogicalMemberIdentifier()).toString();
    }

    @DomainChangeRecord.Type
    public DomainChangeRecord.ChangeType getType() {
        return DomainChangeRecord.ChangeType.COMMAND;
    }

    @InteractionId
    public abstract UUID getInteractionId();

    public abstract void setInteractionId(UUID var1);

    @Username
    public abstract String getUsername();

    public abstract void setUsername(String var1);

    @Timestamp
    public abstract java.sql.Timestamp getTimestamp();

    public abstract void setTimestamp(java.sql.Timestamp var1);

    @Target
    public abstract Bookmark getTarget();

    public abstract void setTarget(Bookmark var1);

    @ExecuteIn
    public abstract org.apache.causeway.extensions.commandlog.applib.dom.ExecuteIn getExecuteIn();

    public abstract void setExecuteIn(org.apache.causeway.extensions.commandlog.applib.dom.ExecuteIn var1);

    @Domain.Exclude
    public abstract UUID getParentInteractionId();

    public abstract void setParentInteractionId(UUID var1);

    @Parent
    public <C extends CommandLogEntry> C getParent() {
        if (this.getParentInteractionId() == null) {
            return null;
        }
        Optional<CommandLogEntry> parentCommandLogEntryIfAny = this.commandLogEntryRepository.findByInteractionId(this.getParentInteractionId());
        CommandLogEntry commandLogEntry = parentCommandLogEntryIfAny.orElse(null);
        return (C)((CommandLogEntry)_Casts.uncheckedCast((Object)commandLogEntry));
    }

    @LogicalMemberIdentifier
    public abstract String getLogicalMemberIdentifier();

    public abstract void setLogicalMemberIdentifier(String var1);

    @CommandDtoAnnot
    public abstract CommandDto getCommandDto();

    public abstract void setCommandDto(CommandDto var1);

    @StartedAt
    public abstract java.sql.Timestamp getStartedAt();

    public abstract void setStartedAt(java.sql.Timestamp var1);

    @CompletedAt
    public abstract java.sql.Timestamp getCompletedAt();

    public abstract void setCompletedAt(java.sql.Timestamp var1);

    @Digits(integer=5, fraction=3)
    @Duration
    public @Digits(integer=5, fraction=3) BigDecimal getDuration() {
        return _Temporals.secondsBetweenAsDecimal((java.sql.Timestamp)this.getStartedAt(), (java.sql.Timestamp)this.getCompletedAt()).orElse(null);
    }

    @IsComplete
    public boolean isComplete() {
        return this.getCompletedAt() != null;
    }

    @Result
    public abstract Bookmark getResult();

    public abstract void setResult(Bookmark var1);

    @Exception
    public abstract String getException();

    public abstract void setException(String var1);

    public void setException(Throwable exception) {
        this.setException(_Exceptions.asStacktrace((Throwable)exception));
    }

    @ResultSummary
    public String getResultSummary() {
        if (this.getCompletedAt() == null) {
            return "";
        }
        if (!_Strings.isNullOrEmpty((CharSequence)this.getException())) {
            return "EXCEPTION";
        }
        if (this.getResult() != null) {
            return "OK";
        }
        return "OK (VOID)";
    }

    @IsCaused
    public boolean isCausedException() {
        return this.getException() != null;
    }

    @ReplayState
    public abstract org.apache.causeway.extensions.commandlog.applib.dom.ReplayState getReplayState();

    public abstract void setReplayState(org.apache.causeway.extensions.commandlog.applib.dom.ReplayState var1);

    @ReplayStateFailureReason
    public abstract String getReplayStateFailureReason();

    public abstract void setReplayStateFailureReason(String var1);

    @MemberSupport
    public boolean hideReplayStateFailureReason() {
        return this.getReplayState() == null || !this.getReplayState().isFailed();
    }

    @Programmatic
    public void saveAnalysis(String analysis) {
        if (analysis == null) {
            this.setReplayState(org.apache.causeway.extensions.commandlog.applib.dom.ReplayState.OK);
        } else {
            this.setReplayState(org.apache.causeway.extensions.commandlog.applib.dom.ReplayState.FAILED);
            this.setReplayStateFailureReason(_Strings.trimmed((String)analysis, (int)255));
        }
    }

    @Override
    public int compareTo(CommandLogEntry other) {
        return this.getTimestamp().compareTo(other.getTimestamp());
    }

    public String toString() {
        return stringifier.toString((Object)this);
    }

    @Generated
    public CommandLogEntry() {
    }

    @Service
    @Priority(value=0x5FFFFFF5)
    public static class TableColumnOrderDefault
    extends TableColumnOrderForCollectionTypeAbstract<CommandLogEntry> {
        public TableColumnOrderDefault() {
            super(CommandLogEntry.class);
        }

        protected List<String> orderParented(Object parent, String collectionId, List<String> propertyIds) {
            return this.ordered(propertyIds);
        }

        protected List<String> orderStandalone(List<String> propertyIds) {
            return this.ordered(propertyIds);
        }

        private List<String> ordered(List<String> propertyIds) {
            return Arrays.asList("timestamp", "target", "logicalMemberIdentifier", "username", "complete", "resultSummary", "duration", "interactionId");
        }
    }

    @Property(domainEvent=DomainEvent.class, optionality=Optionality.OPTIONAL, maxLength=255)
    @PropertyLayout(hidden=Where.ALL_TABLES, multiLine=5)
    @Parameter(optionality=Optionality.OPTIONAL, maxLength=255)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReplayStateFailureReason {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReplayState {
        public static final int MAX_LENGTH = 10;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<org.apache.causeway.extensions.commandlog.applib.dom.ReplayState> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.OBJECT_FORMS)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IsCaused {

        public static class DomainEvent
        extends PropertyDomainEvent<Boolean> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.OBJECT_FORMS, named="Result")
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ResultSummary {

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(hidden=Where.ALL_TABLES, multiLine=3, named="Exception (if any)")
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Exception {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @PropertyLayout(hidden=Where.ALL_TABLES, named="Result Bookmark")
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Result {
        public static final int MAX_LENGTH = 2000;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<Bookmark> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.OBJECT_FORMS)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IsComplete {

        public static class DomainEvent
        extends PropertyDomainEvent<Boolean> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @Digits(integer=5, fraction=3)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Duration {
        public static final int DIGITS_INTEGER = 5;
        public static final int DIGITS_FRACTION = 3;

        public static class DomainEvent
        extends PropertyDomainEvent<BigDecimal> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.OPTIONAL)
    @Parameter(optionality=Optionality.OPTIONAL)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CompletedAt {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.OPTIONAL)
    @Parameter(optionality=Optionality.OPTIONAL)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StartedAt {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @HasCommandDto.CommandDtoAnnot
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CommandDtoAnnot {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<CommandDto> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @DomainChangeRecord.LogicalMemberIdentifier
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LogicalMemberIdentifier {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class, optionality=Optionality.OPTIONAL)
    @PropertyLayout(hidden=Where.ALL_TABLES)
    @Parameter(optionality=Optionality.OPTIONAL)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Parent {
        public static final String NAME = "parentInteractionId";
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<CommandLogEntry> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExecuteIn {
        public static final int MAX_LENGTH = 10;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<org.apache.causeway.extensions.commandlog.applib.dom.ExecuteIn> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Target
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Target {
        public static final int MAX_LENGTH = 1500;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<Bookmark> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Timestamp
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Timestamp {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Username
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Username {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.InteractionId
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InteractionId {
        public static final String NAME = "interactionId";
        public static final int MAX_LENGTH = 36;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<UUID> {
        }
    }

    public static final class Nq {
        public static final String FIND_BY_INTERACTION_ID = "causeway.ext.commandLog.CommandLogEntry.findByInteractionId";
        public static final String FIND_BY_PARENT_INTERACTION_ID = "causeway.ext.commandLog.CommandLogEntry.findByParentInteractionId";
        public static final String FIND_CURRENT = "causeway.ext.commandLog.CommandLogEntry.findCurrent";
        public static final String FIND_COMPLETED = "causeway.ext.commandLog.CommandLogEntry.findCompleted";
        public static final String FIND_RECENT_BY_TARGET = "causeway.ext.commandLog.CommandLogEntry.findRecentByTarget";
        public static final String FIND_RECENT_BY_TARGET_OR_RESULT = "causeway.ext.commandLog.CommandLogEntry.findRecentByTargetOrResult";
        public static final String FIND_BY_TARGET_AND_TIMESTAMP_BETWEEN = "causeway.ext.commandLog.CommandLogEntry.findByTargetAndTimestampBetween";
        public static final String FIND_BY_TARGET_AND_TIMESTAMP_AFTER = "causeway.ext.commandLog.CommandLogEntry.findByTargetAndTimestampAfter";
        public static final String FIND_BY_TARGET_AND_TIMESTAMP_BEFORE = "causeway.ext.commandLog.CommandLogEntry.findByTargetAndTimestampBefore";
        public static final String FIND_BY_TARGET = "causeway.ext.commandLog.CommandLogEntry.findByTarget";
        public static final String FIND_BY_TIMESTAMP_BETWEEN = "causeway.ext.commandLog.CommandLogEntry.findByTimestampBetween";
        public static final String FIND_BY_TIMESTAMP_AFTER = "causeway.ext.commandLog.CommandLogEntry.findByTimestampAfter";
        public static final String FIND_BY_TIMESTAMP_BEFORE = "causeway.ext.commandLog.CommandLogEntry.findByTimestampBefore";
        public static final String FIND = "causeway.ext.commandLog.CommandLogEntry.find";
        public static final String FIND_MOST_RECENT = "causeway.ext.commandLog.CommandLogEntry.findMostRecent";
        public static final String FIND_RECENT_BY_USERNAME = "causeway.ext.commandLog.CommandLogEntry.findRecentByUsername";
        public static final String FIND_FIRST = "causeway.ext.commandLog.CommandLogEntry.findFirst";
        public static final String FIND_SINCE = "causeway.ext.commandLog.CommandLogEntry.findSince";
        public static final String FIND_MOST_RECENT_REPLAYED = "causeway.ext.commandLog.CommandLogEntry.findMostRecentReplayed";
        public static final String FIND_MOST_RECENT_COMPLETED = "causeway.ext.commandLog.CommandLogEntry.findMostRecentCompleted";
        public static final String FIND_BY_REPLAY_STATE = "causeway.ext.commandLog.CommandLogEntry.findNotYetReplayed";
        public static final String FIND_BACKGROUND_AND_NOT_YET_STARTED = "causeway.ext.commandLog.CommandLogEntry.findBackgroundAndNotYetStarted";
        public static final String FIND_RECENT_BACKGROUND_BY_TARGET = "causeway.ext.commandLog.CommandLogEntry.findRecentBackgroundByTarget";

        @Generated
        private Nq() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static abstract class ActionDomainEvent
    extends CausewayModuleExtCommandLogApplib.ActionDomainEvent<CommandLogEntry> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends CausewayModuleExtCommandLogApplib.CollectionDomainEvent<CommandLogEntry, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtCommandLogApplib.PropertyDomainEvent<CommandLogEntry, T> {
    }

    public static class LayoutUiEvent
    extends CausewayModuleExtCommandLogApplib.LayoutUiEvent<CommandLogEntry> {
    }

    public static class CssClassUiEvent
    extends CausewayModuleExtCommandLogApplib.CssClassUiEvent<CommandLogEntry> {
    }

    public static class IconUiEvent
    extends CausewayModuleExtCommandLogApplib.IconUiEvent<CommandLogEntry> {
    }

    public static class TitleUiEvent
    extends CausewayModuleExtCommandLogApplib.TitleUiEvent<CommandLogEntry> {
    }
}

