/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.dom;

import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.causeway.applib.exceptions.RecoverableException;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.command.Command;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntry;
import org.apache.causeway.extensions.commandlog.applib.dom.ExecuteIn;
import org.apache.causeway.schema.cmd.v2.CommandDto;
import org.apache.causeway.schema.cmd.v2.CommandsDto;
import org.jspecify.annotations.Nullable;

public interface CommandLogEntryRepository {
    public CommandLogEntry createEntryAndPersist(Command var1, UUID var2, ExecuteIn var3);

    public Optional<CommandLogEntry> findByInteractionId(UUID var1);

    public List<CommandLogEntry> findByParent(CommandLogEntry var1);

    public List<CommandLogEntry> findByParentInteractionId(UUID var1);

    public List<CommandLogEntry> findByFromAndTo(@Nullable LocalDate var1, @Nullable LocalDate var2);

    public List<CommandLogEntry> findCurrent();

    public List<CommandLogEntry> findCompleted();

    public List<CommandLogEntry> findByTargetAndFromAndTo(Bookmark var1, @Nullable LocalDate var2, @Nullable LocalDate var3);

    public List<CommandLogEntry> findMostRecent();

    public List<CommandLogEntry> findMostRecent(int var1);

    public List<CommandLogEntry> findRecentByUsername(String var1);

    public List<CommandLogEntry> findRecentByTarget(Bookmark var1);

    public List<CommandLogEntry> findRecentByTargetOrResult(Bookmark var1);

    public List<CommandLogEntry> findSince(UUID var1, Integer var2);

    public List<CommandLogEntry> findBackgroundAndNotYetStarted();

    public List<CommandLogEntry> findRecentBackgroundByTarget(Bookmark var1);

    public Optional<CommandLogEntry> findMostRecentReplayed();

    public Optional<CommandLogEntry> findMostRecentCompleted();

    public List<CommandLogEntry> findNotYetReplayed();

    public CommandLogEntry saveForReplay(CommandDto var1);

    public List<CommandLogEntry> saveForReplay(CommandsDto var1);

    public void persist(CommandLogEntry var1);

    public void truncateLog();

    public List<CommandLogEntry> findCommandsOnPrimaryElseFail(@Nullable UUID var1, @Nullable Integer var2) throws NotFoundException;

    public List<CommandLogEntry> findAll();

    public void removeAll();

    public static class NotFoundException
    extends RecoverableException {
        private static final long serialVersionUID = 1L;
        private final UUID interactionId;

        public NotFoundException(UUID interactionId) {
            super("Command not found");
            this.interactionId = interactionId;
        }

        @Generated
        public UUID getInteractionId() {
            return this.interactionId;
        }
    }
}

