/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.dom;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.causeway.applib.jaxb.JavaSqlXMLGregorianCalendarMarshalling;
import org.apache.causeway.applib.query.NamedQuery;
import org.apache.causeway.applib.query.Query;
import org.apache.causeway.applib.query.QueryRange;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.command.Command;
import org.apache.causeway.applib.services.factory.FactoryService;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.applib.util.schema.CommandDtoUtils;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.core.config.environment.CausewaySystemEnvironment;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntry;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;
import org.apache.causeway.extensions.commandlog.applib.dom.ExecuteIn;
import org.apache.causeway.extensions.commandlog.applib.dom.ReplayState;
import org.apache.causeway.schema.cmd.v2.CommandDto;
import org.apache.causeway.schema.cmd.v2.CommandsDto;
import org.apache.causeway.schema.cmd.v2.MapDto;
import org.apache.causeway.schema.common.v2.InteractionType;
import org.apache.causeway.schema.common.v2.OidDto;
import org.jspecify.annotations.Nullable;

public abstract class CommandLogEntryRepositoryAbstract<C extends CommandLogEntry>
implements CommandLogEntryRepository {
    @Inject
    Provider<RepositoryService> repositoryServiceProvider;
    @Inject
    FactoryService factoryService;
    @Inject
    CausewaySystemEnvironment causewaySystemEnvironment;
    private final Class<C> commandLogEntryClass;

    protected CommandLogEntryRepositoryAbstract(Class<C> commandLogEntryClass) {
        this.commandLogEntryClass = commandLogEntryClass;
    }

    public Class<C> getEntityClass() {
        return this.commandLogEntryClass;
    }

    public C createEntryAndPersist(Command command, UUID parentInteractionIdIfAny, ExecuteIn executeIn) {
        CommandLogEntry c = (CommandLogEntry)this.factoryService.detachedEntity(this.commandLogEntryClass);
        c.sync(command);
        c.setParentInteractionId(parentInteractionIdIfAny);
        c.setExecuteIn(executeIn);
        this.persist(c);
        return (C)c;
    }

    @Override
    public Optional<CommandLogEntry> findByInteractionId(UUID interactionId) {
        return (Optional)_Casts.uncheckedCast((Object)this.repositoryService().firstMatch((Query)Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByInteractionId").withParameter("interactionId", (Object)interactionId)));
    }

    @Override
    public List<CommandLogEntry> findByParent(CommandLogEntry parent) {
        return this.findByParentInteractionId(parent.getInteractionId());
    }

    @Override
    public List<CommandLogEntry> findByParentInteractionId(UUID parentInteractionId) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByParentInteractionId").withParameter("parentInteractionId", (Object)parentInteractionId)));
    }

    @Override
    public List<CommandLogEntry> findByFromAndTo(@Nullable LocalDate from, @Nullable LocalDate to) {
        Timestamp fromTs = CommandLogEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(from, 0);
        Timestamp toTs = CommandLogEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(to, 1);
        NamedQuery query = from != null ? (to != null ? Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByTimestampBetween").withParameter("from", (Object)fromTs).withParameter("to", (Object)toTs) : Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByTimestampAfter").withParameter("from", (Object)fromTs)) : (to != null ? Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByTimestampBefore").withParameter("to", (Object)toTs) : Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.find"));
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)query));
    }

    @Override
    public List<CommandLogEntry> findCurrent() {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findCurrent")));
    }

    @Override
    public List<CommandLogEntry> findCompleted() {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findCompleted")));
    }

    @Override
    public List<CommandLogEntry> findByTargetAndFromAndTo(Bookmark target, @Nullable LocalDate from, @Nullable LocalDate to) {
        Timestamp fromTs = CommandLogEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(from, 0);
        Timestamp toTs = CommandLogEntryRepositoryAbstract.toTimestampStartOfDayWithOffset(to, 1);
        NamedQuery query = from != null ? (to != null ? Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByTargetAndTimestampBetween").withParameter("target", (Object)target).withParameter("from", (Object)fromTs).withParameter("to", (Object)toTs) : Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByTargetAndTimestampAfter").withParameter("target", (Object)target).withParameter("from", (Object)fromTs)) : (to != null ? Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByTargetAndTimestampBefore").withParameter("target", (Object)target).withParameter("to", (Object)toTs) : Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByTarget").withParameter("target", (Object)target));
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)query));
    }

    @Override
    public List<CommandLogEntry> findMostRecent() {
        return this.findMostRecent(100);
    }

    @Override
    public List<CommandLogEntry> findMostRecent(int limit) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches(Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findMostRecent").withLimit((long)limit)));
    }

    @Override
    public List<CommandLogEntry> findRecentByUsername(String username) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches(Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findRecentByUsername").withParameter("username", (Object)username).withLimit(30L)));
    }

    @Override
    public List<CommandLogEntry> findRecentByTarget(Bookmark target) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches(Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findRecentByTarget").withParameter("target", (Object)target).withLimit(30L)));
    }

    @Override
    public List<CommandLogEntry> findRecentByTargetOrResult(Bookmark targetOrResult) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches(Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findRecentByTargetOrResult").withParameter("targetOrResult", (Object)targetOrResult).withLimit(30L)));
    }

    @Override
    public List<CommandLogEntry> findSince(UUID interactionId, Integer batchSize) {
        if (interactionId == null) {
            return this.findFirst();
        }
        C from = this.findByInteractionIdElseNull(interactionId);
        if (from == null) {
            return Collections.emptyList();
        }
        return this.findSince(((CommandLogEntry)from).getTimestamp(), batchSize);
    }

    private List<CommandLogEntry> findFirst() {
        Optional firstCommandIfAny = (Optional)_Casts.uncheckedCast((Object)this.repositoryService().firstMatch((Query)Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findFirst")));
        return firstCommandIfAny.map(Collections::singletonList).orElse(Collections.emptyList());
    }

    @Override
    public List<CommandLogEntry> findBackgroundAndNotYetStarted() {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findBackgroundAndNotYetStarted")));
    }

    @Override
    public List<CommandLogEntry> findRecentBackgroundByTarget(Bookmark target) {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches(Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findRecentBackgroundByTarget").withParameter("target", (Object)target).withLimit(30L)));
    }

    @Override
    public Optional<CommandLogEntry> findMostRecentReplayed() {
        return (Optional)_Casts.uncheckedCast((Object)this.repositoryService().firstMatch((Query)Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findMostRecentReplayed")));
    }

    @Override
    public Optional<CommandLogEntry> findMostRecentCompleted() {
        return (Optional)_Casts.uncheckedCast((Object)this.repositoryService().firstMatch((Query)Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findMostRecentCompleted")));
    }

    @Override
    public List<CommandLogEntry> findNotYetReplayed() {
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches(Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findNotYetReplayed").withParameter("replayState", (Object)ReplayState.PENDING).withLimit(10L)));
    }

    public C saveForReplay(CommandDto dto) {
        MapDto userData;
        if (dto.getMember().getInteractionType() == InteractionType.ACTION_INVOCATION && (userData = dto.getUserData()) == null) {
            throw new IllegalStateException(String.format("Can only persist action DTOs with additional userData; got: \n%s", CommandDtoUtils.dtoMapper().toString((Object)dto)));
        }
        CommandLogEntry commandJdo = (CommandLogEntry)this.factoryService.detachedEntity(this.commandLogEntryClass);
        commandJdo.setInteractionId(UUID.fromString(dto.getInteractionId()));
        commandJdo.setTimestamp(JavaSqlXMLGregorianCalendarMarshalling.toTimestamp((XMLGregorianCalendar)dto.getTimestamp()));
        commandJdo.setUsername(dto.getUsername());
        commandJdo.setReplayState(ReplayState.PENDING);
        OidDto firstTargetOidDto = (OidDto)dto.getTargets().getOid().get(0);
        commandJdo.setTarget(Bookmark.forOidDto((OidDto)firstTargetOidDto));
        commandJdo.setCommandDto(dto);
        commandJdo.setLogicalMemberIdentifier(dto.getMember().getLogicalMemberIdentifier());
        this.persist(commandJdo);
        return (C)commandJdo;
    }

    @Override
    public List<CommandLogEntry> saveForReplay(CommandsDto commandsDto) {
        List commandDtos = commandsDto.getCommandDto();
        ArrayList<CommandLogEntry> commands = new ArrayList<CommandLogEntry>();
        for (CommandDto dto : commandDtos) {
            commands.add((CommandLogEntry)this.saveForReplay(dto));
        }
        return commands;
    }

    @Override
    public void persist(CommandLogEntry commandLogEntry) {
        this.repositoryService().persistAndFlush((Object)commandLogEntry);
    }

    @Override
    public void truncateLog() {
        this.repositoryService().removeAll(this.commandLogEntryClass);
    }

    @Override
    public List<CommandLogEntry> findCommandsOnPrimaryElseFail(@Nullable UUID interactionId, @Nullable Integer batchSize) throws CommandLogEntryRepository.NotFoundException {
        List<CommandLogEntry> commands = this.findSince(interactionId, batchSize);
        if (commands == null) {
            throw new CommandLogEntryRepository.NotFoundException(interactionId);
        }
        return commands;
    }

    private C findByInteractionIdElseNull(UUID interactionId) {
        NamedQuery q = Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findByInteractionId").withParameter("interactionId", (Object)interactionId);
        return (C)((CommandLogEntry)this.repositoryService().uniqueMatch((Query)q).orElse(null));
    }

    private List<CommandLogEntry> findSince(Timestamp timestamp, Integer batchSize) {
        boolean needsTrimFix = batchSize != null && batchSize == 1;
        NamedQuery q = Query.named(this.commandLogEntryClass, (String)"causeway.ext.commandLog.CommandLogEntry.findSince").withParameter("timestamp", (Object)timestamp).withRange(QueryRange.limit((long)(needsTrimFix ? 2L : (long)batchSize.intValue())));
        List commandJdos = (List)_Casts.uncheckedCast((Object)this.repositoryService().allMatches((Query)q));
        return needsTrimFix && commandJdos.size() > 1 ? commandJdos.subList(0, 1) : commandJdos;
    }

    private RepositoryService repositoryService() {
        return (RepositoryService)this.repositoryServiceProvider.get();
    }

    private static Timestamp toTimestampStartOfDayWithOffset(@Nullable LocalDate dt, int daysOffset) {
        return dt != null ? new Timestamp(Instant.from(dt.atStartOfDay().plusDays(daysOffset).atZone(ZoneId.systemDefault())).toEpochMilli()) : null;
    }

    @Override
    public List<CommandLogEntry> findAll() {
        if (this.causewaySystemEnvironment.getDeploymentType().isProduction()) {
            throw new IllegalStateException("Cannot call 'findAll' in production systems");
        }
        return (List)_Casts.uncheckedCast((Object)this.repositoryService().allInstances(this.commandLogEntryClass));
    }

    @Override
    public void removeAll() {
        if (this.causewaySystemEnvironment.getDeploymentType().isProduction()) {
            throw new IllegalStateException("Cannot call 'removeAll' in production systems");
        }
        this.repositoryService().removeAll(this.commandLogEntryClass);
    }
}

