/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.fakescheduler;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.services.command.CommandExecutorService;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.applib.services.xactn.TransactionService;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.concurrent._ConcurrentContext;
import org.apache.causeway.commons.internal.concurrent._ConcurrentTask;
import org.apache.causeway.commons.internal.concurrent._ConcurrentTaskList;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntry;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;
import org.apache.causeway.extensions.commandlog.applib.spi.RunBackgroundCommandsJobListener;
import org.apache.causeway.schema.cmd.v2.CommandDto;
import org.jspecify.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;

@Service
public class FakeScheduler {
    @Inject
    List<RunBackgroundCommandsJobListener> listeners;
    @Inject
    CommandLogEntryRepository commandLogEntryRepository;
    @Inject
    CommandExecutorService commandExecutorService;
    @Inject
    TransactionService transactionService;
    @Inject
    InteractionService interactionService;

    public CommandBulkExecutionResult runBackgroundCommands(long waitForMillis, NoCommandsPolicy noCommandsPolicy) throws InterruptedException {
        List<CommandDto> commandDtos = this.pendingCommandDtos();
        if (commandDtos.isEmpty()) {
            switch (noCommandsPolicy.ordinal()) {
                case 1: {
                    return CommandBulkExecutionResult.builder().failure(new IllegalStateException("There are no background commands to be started")).build();
                }
            }
            return CommandBulkExecutionResult.happyCase();
        }
        this.transactionService.flushTransaction();
        _ConcurrentTaskList tasks = _ConcurrentTaskList.named((String)"Execute Command DTOs");
        tasks.addRunnable("Bulk run all pending CommandDtos then call listeners", () -> {
            for (CommandDto commandDto : commandDtos) {
                this.executeCommandWithinTransaction(commandDto);
            }
            List interactionIds = commandDtos.stream().map(CommandDto::getInteractionId).collect(Collectors.toList());
            this.listeners.forEach(listener -> this.invokeListenerCallbackWithinTransaction((RunBackgroundCommandsJobListener)listener, interactionIds));
        });
        tasks.submit(_ConcurrentContext.singleThreaded());
        boolean hasTimedOut = !tasks.await(waitForMillis, TimeUnit.MILLISECONDS);
        return CommandBulkExecutionResult.builder().hasTimedOut(hasTimedOut).failure(tasks.getTasks().stream().map(_ConcurrentTask::getFailedWith).filter(_NullSafe::isPresent).findAny().orElse(null)).remainingCommandsToProcessCount(this.commandLogEntryRepository.findBackgroundAndNotYetStarted().size()).build();
    }

    private List<CommandDto> pendingCommandDtos() {
        return this.commandLogEntryRepository.findBackgroundAndNotYetStarted().stream().map(CommandLogEntry::getCommandDto).collect(Collectors.toList());
    }

    private void executeCommandWithinTransaction(CommandDto commandDto) {
        this.interactionService.runAnonymous(() -> this.transactionService.runTransactional(Propagation.REQUIRED, () -> {
            Optional<CommandLogEntry> commandLogEntryIfAny = this.commandLogEntryRepository.findByInteractionId(UUID.fromString(commandDto.getInteractionId()));
            commandLogEntryIfAny.ifPresent(commandLogEntry -> this.commandExecutorService.executeCommand(CommandExecutorService.InteractionContextPolicy.NO_SWITCH, commandDto));
        }).ifFailureFail());
    }

    private void invokeListenerCallbackWithinTransaction(RunBackgroundCommandsJobListener listener, List<String> interactionIds) {
        this.interactionService.runAnonymous(() -> this.transactionService.runTransactional(Propagation.REQUIRED, () -> listener.executed(interactionIds)));
    }

    public static enum NoCommandsPolicy {
        RELAXED,
        STRICT;

    }

    public record CommandBulkExecutionResult(@Nullable Throwable failure, boolean hasTimedOut, int remainingCommandsToProcessCount) {
        static CommandBulkExecutionResult happyCase() {
            return CommandBulkExecutionResult.builder().build();
        }

        @Generated
        public static CommandBulkExecutionResultBuilder builder() {
            return new CommandBulkExecutionResultBuilder();
        }

        @Generated
        public static class CommandBulkExecutionResultBuilder {
            @Generated
            private Throwable failure;
            @Generated
            private boolean hasTimedOut;
            @Generated
            private int remainingCommandsToProcessCount;

            @Generated
            CommandBulkExecutionResultBuilder() {
            }

            @Generated
            public CommandBulkExecutionResultBuilder failure(@Nullable Throwable failure) {
                this.failure = failure;
                return this;
            }

            @Generated
            public CommandBulkExecutionResultBuilder hasTimedOut(boolean hasTimedOut) {
                this.hasTimedOut = hasTimedOut;
                return this;
            }

            @Generated
            public CommandBulkExecutionResultBuilder remainingCommandsToProcessCount(int remainingCommandsToProcessCount) {
                this.remainingCommandsToProcessCount = remainingCommandsToProcessCount;
                return this;
            }

            @Generated
            public CommandBulkExecutionResult build() {
                return new CommandBulkExecutionResult(this.failure, this.hasTimedOut, this.remainingCommandsToProcessCount);
            }

            @Generated
            public String toString() {
                return "FakeScheduler.CommandBulkExecutionResult.CommandBulkExecutionResultBuilder(failure=" + String.valueOf(this.failure) + ", hasTimedOut=" + this.hasTimedOut + ", remainingCommandsToProcessCount=" + this.remainingCommandsToProcessCount + ")";
            }
        }
    }
}

