/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.job;

import jakarta.inject.Inject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.causeway.applib.services.clock.ClockService;
import org.apache.causeway.applib.services.command.CommandExecutorService;
import org.apache.causeway.applib.services.iactnlayer.InteractionContext;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.applib.services.user.UserMemento;
import org.apache.causeway.applib.services.xactn.TransactionService;
import org.apache.causeway.applib.util.schema.CommandDtoUtils;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.services.deadlock.DeadlockRecognizer;
import org.apache.causeway.core.runtimeservices.transaction.TransactionServiceSpring;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntry;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;
import org.apache.causeway.extensions.commandlog.applib.job.BackgroundCommandsJobControl;
import org.apache.causeway.extensions.commandlog.applib.spi.RunBackgroundCommandsJobListener;
import org.apache.causeway.schema.cmd.v2.CommandDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;

@Component
@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class RunBackgroundCommandsJob
implements Job {
    @Generated
    private static final Logger log = LogManager.getLogger(RunBackgroundCommandsJob.class);
    static final int RETRY_COUNT = 3;
    static final long RETRY_INTERVAL_MILLIS = 1000L;
    @Inject
    InteractionService interactionService;
    @Inject
    TransactionService transactionService;
    @Inject
    ClockService clockService;
    @Inject
    CommandLogEntryRepository commandLogEntryRepository;
    @Inject
    CommandExecutorService commandExecutorService;
    @Inject
    BackgroundCommandsJobControl backgroundCommandsJobControl;
    @Inject
    DeadlockRecognizer deadlockRecognizer;
    @Inject
    List<RunBackgroundCommandsJobListener> listeners;
    @Autowired
    private CausewayConfiguration causewayConfiguration;
    @Inject
    TransactionServiceSpring transactionServiceSpring;

    public void execute(JobExecutionContext quartzContext) {
        if (this.backgroundCommandsJobControl.isPaused()) {
            log.debug("currently paused");
            return;
        }
        UserMemento userMemento = UserMemento.ofNameAndRoleNames((String)"scheduler_user", (String[])new String[]{"admin_role"});
        InteractionContext interactionContext = InteractionContext.builder().user(userMemento).build();
        Optional<List<CommandDto>> commandDtosIfAny = this.pendingCommandDtos(interactionContext);
        commandDtosIfAny.ifPresent(commandDtos -> {
            CausewayConfiguration.Extensions.CommandLog.RunBackgroundCommands.OnFailurePolicy onFailurePolicy;
            CommandDto dto;
            Try<?> attempt;
            ArrayList<CommandAndResult> commandResults = new ArrayList<CommandAndResult>();
            Iterator iterator = commandDtos.iterator();
            while (iterator.hasNext() && (!(attempt = this.executeCommandWithinTransaction(dto = (CommandDto)iterator.next(), interactionContext)).isFailure() || (onFailurePolicy = this.causewayConfiguration.getExtensions().getCommandLog().getRunBackgroundCommands().getOnFailurePolicy()) != CausewayConfiguration.Extensions.CommandLog.RunBackgroundCommands.OnFailurePolicy.STOP_THE_LINE)) {
                CommandAndResult apply = CommandAndResult.of(dto, attempt);
                commandResults.add(apply);
            }
            List interactionIds = commandResults.stream().filter(commandAndResult -> commandAndResult.getExecutionResult().isSuccess()).map(CommandAndResult::getCommandDto).map(CommandDto::getInteractionId).collect(Collectors.toList());
            this.listeners.forEach(listener -> this.invokeListenerCallbackWithinTransaction((RunBackgroundCommandsJobListener)listener, interactionIds, interactionContext));
        });
    }

    private Optional<List<CommandDto>> pendingCommandDtos(InteractionContext interactionContext) {
        return this.interactionService.callAndCatch(interactionContext, () -> (List)this.transactionService.callTransactional(Propagation.REQUIRES_NEW, () -> this.commandLogEntryRepository.findBackgroundAndNotYetStarted().stream().map(CommandLogEntry::getCommandDto).limit(this.causewayConfiguration.getExtensions().getCommandLog().getRunBackgroundCommands().getBatchSize()).collect(Collectors.toList())).ifFailureFail().valueAsNonNullElseFail()).ifFailureFail().getValue();
    }

    private Try<?> executeCommandWithinTransaction(CommandDto commandDto, InteractionContext interactionContext) {
        Try result;
        int remainingAttempts = 3;
        while (true) {
            if ((result = (Try)this.interactionService.call(interactionContext, () -> {
                Optional<CommandLogEntry> commandLogEntryIfAny = this.commandLogEntryRepository.findByInteractionId(UUID.fromString(commandDto.getInteractionId()));
                if (commandLogEntryIfAny.isEmpty()) {
                    return Try.empty();
                }
                CommandLogEntry commandLogEntry = commandLogEntryIfAny.get();
                return this.commandExecutorService.executeCommand(CommandExecutorService.InteractionContextPolicy.NO_SWITCH, commandDto).ifSuccess(bookmarkToResultIfAny -> commandLogEntry.setCompletedAt(this.clockService.getClock().nowAsJavaSqlTimestamp())).mapFailure(throwable -> new ThrowableWithDetailsOfAttempt((Throwable)throwable, commandLogEntry.getStartedAt()));
            })).isSuccess()) {
                return result;
            }
            if (!this.isEncounteredDeadlock(result)) break;
            if (--remainingAttempts <= 0) {
                log.debug("Deadlock occurred too many times, giving up on command: " + CommandDtoUtils.dtoMapper().toString((Object)commandDto));
                break;
            }
            log.debug("Deadlock occurred, retrying command: " + CommandDtoUtils.dtoMapper().toString((Object)commandDto));
            RunBackgroundCommandsJob.sleep(1000L);
        }
        CausewayConfiguration.Extensions.CommandLog.RunBackgroundCommands.OnFailurePolicy onFailurePolicy = this.causewayConfiguration.getExtensions().getCommandLog().getRunBackgroundCommands().getOnFailurePolicy();
        switch (onFailurePolicy) {
            case CONTINUE_WITH_NEXT: {
                result.ifFailure(throwable -> this.captureFailure((Throwable)throwable, commandDto, interactionContext));
                break;
            }
        }
        return result;
    }

    private void captureFailure(Throwable throwable, CommandDto commandDto, InteractionContext interactionContext) {
        log.error("Failed to execute command.  As per onFailurePolicy, updating CommandLogEntry with result then continuing; command: " + CommandDtoUtils.dtoMapper().toString((Object)commandDto), throwable);
        this.interactionService.run(interactionContext, () -> {
            Optional<CommandLogEntry> commandLogEntryIfAny = this.commandLogEntryRepository.findByInteractionId(UUID.fromString(commandDto.getInteractionId()));
            commandLogEntryIfAny.ifPresent(commandLogEntry -> {
                if (throwable instanceof ThrowableWithDetailsOfAttempt) {
                    ThrowableWithDetailsOfAttempt throwableWithDetailsOfAttempt = (ThrowableWithDetailsOfAttempt)throwable;
                    commandLogEntry.setStartedAt(throwableWithDetailsOfAttempt.getStartedAt());
                    commandLogEntry.setException(throwableWithDetailsOfAttempt.getOriginal());
                } else {
                    commandLogEntry.setException(throwable);
                }
                commandLogEntry.setCompletedAt(this.clockService.getClock().nowAsJavaSqlTimestamp());
            });
        });
    }

    private void invokeListenerCallbackWithinTransaction(RunBackgroundCommandsJobListener listener, List<String> interactionIds, InteractionContext interactionContext) {
        this.interactionService.runAndCatch(interactionContext, () -> this.transactionService.runTransactional(Propagation.REQUIRES_NEW, () -> listener.executed(interactionIds))).ifFailureFail();
    }

    private boolean isEncounteredDeadlock(Try<?> result) {
        if (!result.isFailure()) {
            return false;
        }
        return result.getFailure().map(throwable -> this.deadlockRecognizer.isDeadlock(throwable)).orElse(false);
    }

    private static void sleep(long retryIntervalMs) {
        try {
            Thread.sleep(retryIntervalMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class ThrowableWithDetailsOfAttempt
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final Throwable original;
        private final Timestamp startedAt;

        @Generated
        public Throwable getOriginal() {
            return this.original;
        }

        @Generated
        public Timestamp getStartedAt() {
            return this.startedAt;
        }

        @Generated
        private ThrowableWithDetailsOfAttempt(Throwable original, Timestamp startedAt) {
            this.original = original;
            this.startedAt = startedAt;
        }

        @Generated
        public static ThrowableWithDetailsOfAttempt of(Throwable original, Timestamp startedAt) {
            return new ThrowableWithDetailsOfAttempt(original, startedAt);
        }
    }

    static class CommandAndResult {
        private final CommandDto commandDto;
        private final Try<?> executionResult;

        @Generated
        public CommandDto getCommandDto() {
            return this.commandDto;
        }

        @Generated
        public Try<?> getExecutionResult() {
            return this.executionResult;
        }

        @Generated
        private CommandAndResult(CommandDto commandDto, Try<?> executionResult) {
            this.commandDto = commandDto;
            this.executionResult = executionResult;
        }

        @Generated
        public static CommandAndResult of(CommandDto commandDto, Try<?> executionResult) {
            return new CommandAndResult(commandDto, executionResult);
        }
    }
}

