/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.commandlog.applib.subscriber;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.causeway.applib.services.clock.ClockService;
import org.apache.causeway.applib.services.command.Command;
import org.apache.causeway.applib.services.publishing.spi.CommandSubscriber;
import org.apache.causeway.applib.services.repository.RepositoryService;
import org.apache.causeway.applib.util.schema.CommandDtoUtils;
import org.apache.causeway.commons.functional.Try;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntry;
import org.apache.causeway.extensions.commandlog.applib.dom.CommandLogEntryRepository;
import org.apache.causeway.extensions.commandlog.applib.dom.ExecuteIn;
import org.apache.causeway.schema.cmd.v2.CommandDto;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.ext.commandLog.CommandSubscriberForCommandLog")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class CommandSubscriberForCommandLog
implements CommandSubscriber {
    @Generated
    private static final Logger log = LogManager.getLogger(CommandSubscriberForCommandLog.class);
    static final String LOGICAL_TYPE_NAME = "causeway.ext.commandLog.CommandSubscriberForCommandLog";
    final CommandLogEntryRepository commandLogEntryRepository;
    final RepositoryService repositoryService;
    final CausewayConfiguration causewayConfiguration;
    final ClockService clockService;

    public boolean isEnabled() {
        return this.causewayConfiguration.getExtensions().getCommandLog().getPersist().isEnabled();
    }

    public void onReady(Command command) {
        block6: {
            block5: {
                if (!this.isEnabled()) {
                    return;
                }
                Optional<CommandLogEntry> existingCommandLogEntryIfAny = this.commandLogEntryRepository.findByInteractionId(command.getInteractionId());
                if (!existingCommandLogEntryIfAny.isPresent()) break block5;
                CommandLogEntry commandLogEntry = existingCommandLogEntryIfAny.get();
                switch (commandLogEntry.getExecuteIn()) {
                    case FOREGROUND: {
                        String commandDtoXml;
                        if (!log.isWarnEnabled()) break;
                        CommandDto existingCommandDto = existingCommandLogEntryIfAny.get().getCommandDto();
                        String existingCommandDtoXml = Try.call(() -> CommandDtoUtils.dtoMapper().toString((Object)existingCommandDto)).getValue().orElse("Dto to Xml failure");
                        if (!existingCommandDtoXml.equals(commandDtoXml = Try.call(() -> CommandDtoUtils.dtoMapper().toString((Object)command.getCommandDto())).getValue().orElse("Dto to Xml failure"))) {
                            log.warn("existing: \n{}", (Object)existingCommandDtoXml);
                            log.warn("proposed: \n{}", (Object)commandDtoXml);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block6;
            }
            UUID parentInteractionId = command.getParentInteractionId();
            this.commandLogEntryRepository.createEntryAndPersist(command, parentInteractionId, ExecuteIn.FOREGROUND);
        }
    }

    public void onStarted(Command command) {
        if (!this.isEnabled()) {
            return;
        }
        this.commandLogEntryRepository.findByInteractionId(command.getInteractionId()).ifPresent(commandLogEntry -> commandLogEntry.sync(command));
    }

    public void onCompleted(Command command) {
        if (!this.isEnabled()) {
            return;
        }
        this.commandLogEntryRepository.findByInteractionId(command.getInteractionId()).ifPresent(commandLogEntry -> commandLogEntry.sync(command));
    }

    @Inject
    @Generated
    public CommandSubscriberForCommandLog(CommandLogEntryRepository commandLogEntryRepository, RepositoryService repositoryService, CausewayConfiguration causewayConfiguration, ClockService clockService) {
        this.commandLogEntryRepository = commandLogEntryRepository;
        this.repositoryService = repositoryService;
        this.causewayConfiguration = causewayConfiguration;
        this.clockService = clockService;
    }
}

