/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.executionlog.applib.app;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.DomainServiceLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.RestrictTo;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.services.clock.ClockService;
import org.apache.causeway.extensions.executionlog.applib.CausewayModuleExtExecutionLogApplib;
import org.apache.causeway.extensions.executionlog.applib.dom.ExecutionLogEntry;
import org.apache.causeway.extensions.executionlog.applib.dom.ExecutionLogEntryRepository;
import org.jspecify.annotations.Nullable;

@Named(value="causeway.ext.executionLog.ExecutionLogMenu")
@DomainService
@DomainServiceLayout(menuBar=DomainServiceLayout.MenuBar.SECONDARY, named="Activity")
@Priority(value=0x1FFFFFFF)
public class ExecutionLogMenu {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.executionLog.ExecutionLogMenu";
    final ExecutionLogEntryRepository executionLogEntryRepository;
    final ClockService clockService;

    private LocalDate now() {
        return this.clockService.getClock().nowAsLocalDate(ZoneId.systemDefault());
    }

    @Inject
    @Generated
    public ExecutionLogMenu(ExecutionLogEntryRepository executionLogEntryRepository, ClockService clockService) {
        this.executionLogEntryRepository = executionLogEntryRepository;
        this.clockService = clockService;
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, restrictTo=RestrictTo.PROTOTYPING, semantics=SemanticsOf.SAFE, typeOf=ExecutionLogEntry.class)
    @ActionLayout(cssClassFa="fa-search", sequence="40")
    public class findAll {
        @MemberSupport
        public List<? extends ExecutionLogEntry> act() {
            return ExecutionLogMenu.this.executionLogEntryRepository.findAll();
        }

        public class DomainEvent
        extends ActionDomainEvent<findAll> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE, typeOf=ExecutionLogEntry.class)
    @ActionLayout(cssClassFa="fa-search", sequence="30")
    public class findExecutions {
        @MemberSupport
        public List<? extends ExecutionLogEntry> act(@Nullable LocalDate from, @Nullable LocalDate to) {
            return ExecutionLogMenu.this.executionLogEntryRepository.findByFromAndTo(from, to);
        }

        @MemberSupport
        public LocalDate default0Act() {
            return ExecutionLogMenu.this.now().minusDays(7L);
        }

        @MemberSupport
        public LocalDate default1Act() {
            return ExecutionLogMenu.this.now();
        }

        public class DomainEvent
        extends ActionDomainEvent<findExecutions> {
        }
    }

    @Action(commandPublishing=Publishing.DISABLED, domainEvent=DomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE, typeOf=ExecutionLogEntry.class)
    @ActionLayout(cssClassFa="fa-search", sequence="20")
    public class findMostRecent {
        @MemberSupport
        public List<? extends ExecutionLogEntry> act() {
            return ExecutionLogMenu.this.executionLogEntryRepository.findMostRecent();
        }

        public class DomainEvent
        extends ActionDomainEvent<findMostRecent> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends CausewayModuleExtExecutionLogApplib.ActionDomainEvent<T> {
    }
}

