/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.executionlog.applib.contributions;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.MemberSupport;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.applib.mixins.system.HasInteractionId;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.extensions.executionlog.applib.CausewayModuleExtExecutionLogApplib;
import org.apache.causeway.extensions.executionlog.applib.dom.ExecutionLogEntry;
import org.apache.causeway.extensions.executionlog.applib.dom.ExecutionLogEntryRepository;

@Action(commandPublishing=Publishing.DISABLED, domainEvent=ActionDomainEvent.class, executionPublishing=Publishing.DISABLED, semantics=SemanticsOf.SAFE)
@ActionLayout(cssClassFa="fa-bolt", describedAs="Returns the last (published) 30 command executions that have targeted this object", fieldSetId="metadata", position=ActionLayout.Position.PANEL_DROPDOWN, sequence="900.2")
public class Object_recentExecutions {
    private final Object domainObject;
    @Inject
    ExecutionLogEntryRepository executionLogEntryRepository;
    @Inject
    BookmarkService bookmarkService;

    @MemberSupport
    public List<? extends ExecutionLogEntry> act() {
        ArrayList<ExecutionLogEntry> executionLogEntries = new ArrayList<ExecutionLogEntry>();
        this.bookmarkService.bookmarksFor(this.domainObject).forEach(bookmark -> {
            List<ExecutionLogEntry> recent = this.executionLogEntryRepository.findRecentByTarget((Bookmark)bookmark);
            executionLogEntries.addAll(recent);
        });
        executionLogEntries.sort(Comparator.comparing(ExecutionLogEntry::getTimestamp).reversed());
        return executionLogEntries;
    }

    @MemberSupport
    public boolean hideAct() {
        return this.domainObject instanceof HasInteractionId;
    }

    @Generated
    public Object_recentExecutions(Object domainObject) {
        this.domainObject = domainObject;
    }

    public static class ActionDomainEvent
    extends CausewayModuleExtExecutionLogApplib.ActionDomainEvent<Object_recentExecutions> {
    }
}

