/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.extensions.executionlog.applib.dom;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.constraints.Digits;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.DomainObjectLayout;
import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.ObjectSupport;
import org.apache.causeway.applib.annotation.Optionality;
import org.apache.causeway.applib.annotation.Parameter;
import org.apache.causeway.applib.annotation.Programmatic;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.annotation.Publishing;
import org.apache.causeway.applib.annotation.ValueSemantics;
import org.apache.causeway.applib.mixins.system.DomainChangeRecord;
import org.apache.causeway.applib.mixins.system.HasInteractionIdAndSequence;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.bookmark.BookmarkService;
import org.apache.causeway.applib.services.iactn.ActionInvocation;
import org.apache.causeway.applib.services.iactn.Execution;
import org.apache.causeway.applib.services.iactn.HasInteractionDto;
import org.apache.causeway.applib.services.iactn.PropertyEdit;
import org.apache.causeway.applib.services.tablecol.TableColumnOrderForCollectionTypeAbstract;
import org.apache.causeway.applib.util.ObjectContracts;
import org.apache.causeway.applib.util.TitleBuffer;
import org.apache.causeway.applib.util.ToString;
import org.apache.causeway.commons.internal.base._Temporals;
import org.apache.causeway.extensions.executionlog.applib.CausewayModuleExtExecutionLogApplib;
import org.apache.causeway.extensions.executionlog.applib.dom.ExecutionLogEntryType;
import org.apache.causeway.schema.common.v2.OidDto;
import org.apache.causeway.schema.ixn.v2.InteractionDto;
import org.apache.causeway.schema.ixn.v2.MemberExecutionDto;
import org.jspecify.annotations.NonNull;
import org.springframework.stereotype.Service;

@Named(value="causeway.ext.executionLog.ExecutionLogEntry")
@DomainObject(editing=Editing.DISABLED, entityChangePublishing=Publishing.DISABLED)
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class, iconUiEvent=IconUiEvent.class, cssClassUiEvent=CssClassUiEvent.class, layoutUiEvent=LayoutUiEvent.class)
public abstract class ExecutionLogEntry
implements Comparable<ExecutionLogEntry>,
DomainChangeRecord,
HasInteractionIdAndSequence,
HasInteractionDto {
    public static final String LOGICAL_TYPE_NAME = "causeway.ext.executionLog.ExecutionLogEntry";
    public static final String SCHEMA = "causewayExtExecutionLog";
    public static final String TABLE = "ExecutionLogEntry";
    @Inject
    BookmarkService bookmarkService;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    static final ToString<ExecutionLogEntry> stringifier = ObjectContracts.toString((String)"interactionId", ExecutionLogEntry::getInteractionId).thenToString("sequence", ExecutionLogEntry::getSequence).thenToString("username", ExecutionLogEntry::getUsername).thenToString("type", ExecutionLogEntry::getExecutionType).thenToString("timestamp", ExecutionLogEntry::getTimestamp).thenToString("target", ExecutionLogEntry::getTarget).thenToString("logicalMemberIdentifier", ExecutionLogEntry::getLogicalMemberIdentifier).thenToStringOmitIfAbsent("startedAt", ExecutionLogEntry::getStartedAt).thenToStringOmitIfAbsent("completedAt", ExecutionLogEntry::getCompletedAt);

    public ExecutionLogEntry(@NonNull Execution<? extends MemberExecutionDto, ?> execution) {
        this.init(execution);
    }

    @Programmatic
    public void init(Execution<? extends MemberExecutionDto, ?> execution) {
        UUID interactionId = execution.getInteraction().getInteractionId();
        this.setInteractionId(interactionId);
        MemberExecutionDto memberExecutionDto = execution.getDto();
        this.setSequence(memberExecutionDto.getSequence());
        InteractionDto interactionDto = new InteractionDto();
        interactionDto.setInteractionId(interactionId.toString());
        interactionDto.setExecution(memberExecutionDto);
        this.setInteractionDto(interactionDto);
        this.setTimestamp(execution.getStartedAt());
        this.setStartedAt(execution.getStartedAt());
        this.setCompletedAt(execution.getCompletedAt());
        this.setLogicalMemberIdentifier(memberExecutionDto.getLogicalMemberIdentifier());
        this.setTarget(Bookmark.forOidDto((OidDto)memberExecutionDto.getTarget()));
        this.setUsername(memberExecutionDto.getUsername());
        if (execution instanceof PropertyEdit) {
            this.setExecutionType(ExecutionLogEntryType.PROPERTY_EDIT);
        } else if (execution instanceof ActionInvocation) {
            this.setExecutionType(ExecutionLogEntryType.ACTION_INVOCATION);
        } else {
            throw new IllegalArgumentException(String.format("Execution subtype unknown: %s", execution.getClass().getName()));
        }
    }

    @ObjectSupport
    public String title() {
        return new TitleBuffer().append(formatter.format(this.getTimestamp().toLocalDateTime())).append(" ").append(this.getLogicalMemberIdentifier()).toString();
    }

    @DomainChangeRecord.Type
    public DomainChangeRecord.ChangeType getType() {
        return DomainChangeRecord.ChangeType.EXECUTION;
    }

    @InteractionId
    public abstract UUID getInteractionId();

    public abstract void setInteractionId(UUID var1);

    @Sequence
    public abstract int getSequence();

    public abstract void setSequence(int var1);

    @ExecutionType
    public abstract ExecutionLogEntryType getExecutionType();

    public abstract void setExecutionType(ExecutionLogEntryType var1);

    @Username
    public abstract String getUsername();

    public abstract void setUsername(String var1);

    @Timestamp
    public abstract java.sql.Timestamp getTimestamp();

    public abstract void setTimestamp(java.sql.Timestamp var1);

    @Target
    public abstract Bookmark getTarget();

    public abstract void setTarget(Bookmark var1);

    @LogicalMemberIdentifier
    public abstract String getLogicalMemberIdentifier();

    public abstract void setLogicalMemberIdentifier(String var1);

    @ValueSemantics(provider="pretty-render")
    @InteractionDtoAnnot
    public abstract InteractionDto getInteractionDto();

    public abstract void setInteractionDto(InteractionDto var1);

    @StartedAt
    public abstract java.sql.Timestamp getStartedAt();

    public abstract void setStartedAt(java.sql.Timestamp var1);

    @CompletedAt
    public abstract java.sql.Timestamp getCompletedAt();

    public abstract void setCompletedAt(java.sql.Timestamp var1);

    @Duration
    public BigDecimal getDuration() {
        return _Temporals.secondsBetweenAsDecimal((java.sql.Timestamp)this.getStartedAt(), (java.sql.Timestamp)this.getCompletedAt()).orElse(null);
    }

    @Override
    public int compareTo(ExecutionLogEntry other) {
        return this.getTimestamp().compareTo(other.getTimestamp());
    }

    public String toString() {
        return stringifier.toString((Object)this);
    }

    @Generated
    public ExecutionLogEntry() {
    }

    @Service
    @Priority(value=0x5FFFFFF5)
    public static class TableColumnOrderDefault
    extends TableColumnOrderForCollectionTypeAbstract<ExecutionLogEntry> {
        public TableColumnOrderDefault() {
            super(ExecutionLogEntry.class);
        }

        protected List<String> orderParented(Object parent, String collectionId, List<String> propertyIds) {
            return this.ordered(propertyIds);
        }

        protected List<String> orderStandalone(List<String> propertyIds) {
            return this.ordered(propertyIds);
        }

        private List<String> ordered(List<String> propertyIds) {
            return Arrays.asList("timestamp", "target", "logicalMemberIdentifier", "username", "duration", "interactionId", "sequence");
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @Digits(integer=5, fraction=3)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Duration {
        public static final int DIGITS_INTEGER = 5;
        public static final int DIGITS_FRACTION = 3;

        public static class DomainEvent
        extends PropertyDomainEvent<BigDecimal> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.OPTIONAL)
    @Parameter(optionality=Optionality.OPTIONAL)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CompletedAt {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED, optionality=Optionality.OPTIONAL)
    @Parameter(optionality=Optionality.OPTIONAL)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StartedAt {
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @HasInteractionDto.InteractionDtoAnnot
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InteractionDtoAnnot {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<InteractionDto> {
        }
    }

    @Property(domainEvent=DomainEvent.class, editing=Editing.DISABLED)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LogicalMemberIdentifier {
        public static final int MAX_LENGTH = 255;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Target
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Target {
        public static final int MAX_LENGTH = 1500;
        public static final boolean NULLABLE = true;
        public static final String ALLOWS_NULL = "true";

        public static class DomainEvent
        extends PropertyDomainEvent<Bookmark> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Timestamp
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Timestamp {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<java.sql.Timestamp> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.Username
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Username {
        public static final int MAX_LENGTH = 120;
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<String> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExecutionType {
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";
        public static final int MAX_LENGTH = 30;

        public static class DomainEvent
        extends PropertyDomainEvent<ExecutionLogEntryType> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @HasInteractionIdAndSequence.Sequence
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Sequence {
        public static final String NAME = "sequence";
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<Integer> {
        }
    }

    @Property(domainEvent=DomainEvent.class)
    @DomainChangeRecord.InteractionId
    @java.lang.annotation.Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InteractionId {
        public static final int MAX_LENGTH = 36;
        public static final String NAME = "interactionId";
        public static final boolean NULLABLE = false;
        public static final String ALLOWS_NULL = "false";

        public static class DomainEvent
        extends PropertyDomainEvent<UUID> {
        }
    }

    protected static final class Util {
        public static String abbreviated(String str, int maxLength) {
            return str != null ? (str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...") : null;
        }

        @Generated
        private Util() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class Nq {
        public static final String FIND_BY_INTERACTION_ID = "causeway.ext.executionLog.ExecutionLogEntry.findByInteractionId";
        public static final String FIND_BY_INTERACTION_ID_AND_SEQUENCE = "causeway.ext.executionLog.ExecutionLogEntry.findByInteractionIdAndSequence";
        public static final String FIND_BY_TARGET_AND_TIMESTAMP_BETWEEN = "causeway.ext.executionLog.ExecutionLogEntry.findByTargetAndTimestampBetween";
        public static final String FIND_BY_TARGET_AND_TIMESTAMP_AFTER = "causeway.ext.executionLog.ExecutionLogEntry.findByTargetAndTimestampAfter";
        public static final String FIND_BY_TARGET_AND_TIMESTAMP_BEFORE = "causeway.ext.executionLog.ExecutionLogEntry.findByTargetAndTimestampBefore";
        public static final String FIND_BY_TARGET = "causeway.ext.executionLog.ExecutionLogEntry.findByTarget";
        public static final String FIND_BY_TIMESTAMP_BETWEEN = "causeway.ext.executionLog.ExecutionLogEntry.findByTimestampBetween";
        public static final String FIND_BY_TIMESTAMP_AFTER = "causeway.ext.executionLog.ExecutionLogEntry.findByTimestampAfter";
        public static final String FIND_BY_TIMESTAMP_BEFORE = "causeway.ext.executionLog.ExecutionLogEntry.findByTimestampBefore";
        public static final String FIND = "causeway.ext.executionLog.ExecutionLogEntry.find";
        public static final String FIND_MOST_RECENT = "causeway.ext.executionLog.ExecutionLogEntry.findMostRecent";
        public static final String FIND_RECENT_BY_USERNAME = "causeway.ext.executionLog.ExecutionLogEntry.findRecentByUsername";
        public static final String FIND_RECENT_BY_TARGET = "causeway.ext.executionLog.ExecutionLogEntry.findRecentByTarget";

        @Generated
        private Nq() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static abstract class ActionDomainEvent
    extends CausewayModuleExtExecutionLogApplib.ActionDomainEvent<ExecutionLogEntry> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends CausewayModuleExtExecutionLogApplib.CollectionDomainEvent<ExecutionLogEntry, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends CausewayModuleExtExecutionLogApplib.PropertyDomainEvent<ExecutionLogEntry, T> {
    }

    public static class LayoutUiEvent
    extends CausewayModuleExtExecutionLogApplib.LayoutUiEvent<ExecutionLogEntry> {
    }

    public static class CssClassUiEvent
    extends CausewayModuleExtExecutionLogApplib.CssClassUiEvent<ExecutionLogEntry> {
    }

    public static class IconUiEvent
    extends CausewayModuleExtExecutionLogApplib.IconUiEvent<ExecutionLogEntry> {
    }

    public static class TitleUiEvent
    extends CausewayModuleExtExecutionLogApplib.TitleUiEvent<ExecutionLogEntry> {
    }
}

